/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedTypeEncoder;

public abstract class AbstractDescribedMapTypeEncoder<K, V, M>
extends AbstractDescribedTypeEncoder<M> {
    public byte getMapEncoding(M value) {
        return -47;
    }

    public abstract boolean hasMap(M var1);

    public abstract int getMapSize(M var1);

    public abstract void writeMapEntries(ProtonBuffer var1, EncoderState var2, M var3);

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, M value) {
        buffer.writeByte(0);
        state.getEncoder().writeUnsignedLong(buffer, state, this.getDescriptorCode().byteValue());
        if (this.hasMap(value)) {
            int count = this.getMapSize(value);
            byte encodingCode = this.getMapEncoding(value);
            buffer.writeByte(encodingCode);
            switch (encodingCode) {
                case -63: {
                    this.writeSmallType(buffer, state, value, count);
                    break;
                }
                case -47: {
                    this.writeLargeType(buffer, state, value, count);
                }
            }
        } else {
            state.getEncoder().writeNull(buffer, state);
        }
    }

    private void writeSmallType(ProtonBuffer buffer, EncoderState state, M value, int elementCount) {
        int startIndex = buffer.getWriteIndex();
        buffer.writeByte(0);
        buffer.writeByte((byte)(elementCount * 2));
        this.writeMapEntries(buffer, state, value);
        int writeSize = buffer.getWriteIndex() - startIndex - 1;
        buffer.setByte(startIndex, writeSize);
    }

    private void writeLargeType(ProtonBuffer buffer, EncoderState state, M value, int elementCount) {
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(elementCount * 2);
        this.writeMapEntries(buffer, state, value);
        int writeSize = buffer.getWriteIndex() - startIndex - 4;
        buffer.setInt(startIndex, writeSize);
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-16);
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        buffer.writeByte(0);
        state.getEncoder().writeUnsignedLong(buffer, state, this.getDescriptorCode());
        this.writeRawArray(buffer, state, values);
        int writeSize = buffer.getWriteIndex() - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size too large: " + writeSize);
        }
        buffer.setInt(startIndex, writeSize);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-47);
        for (int i = 0; i < values.length; ++i) {
            Object map = values[i];
            int count = this.getMapSize(map);
            int mapStartIndex = buffer.getWriteIndex();
            buffer.writeInt(0);
            buffer.writeInt(count * 2);
            this.writeMapEntries(buffer, state, map);
            int writeSize = buffer.getWriteIndex() - mapStartIndex - 4;
            buffer.setInt(mapStartIndex, writeSize);
        }
    }
}

