/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.transactions;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transactions.Declared;

public final class DeclaredTypeDecoder
extends AbstractDescribedTypeDecoder<Declared> {
    private static final int MIN_DECLARED_LIST_ENTRIES = 1;
    private static final int MAX_DECLARED_LIST_ENTRIES = 1;

    @Override
    public Class<Declared> getTypeClass() {
        return Declared.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Declared.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Declared.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Declared readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readDeclared(buffer, state, (ListTypeDecoder)DeclaredTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Declared[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Declared[] result = new Declared[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDeclared(buffer, state, (ListTypeDecoder)DeclaredTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        DeclaredTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private Declared readDeclared(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Declared declared = new Declared();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 1) {
            throw new DecodeException("The txn-id field cannot be omitted");
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Declared list encoding: " + count);
        }
        if (count == 1) {
            declared.setTxnId(state.getDecoder().readBinary(buffer, state));
        }
        return declared;
    }

    @Override
    public Declared readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readDeclared(stream, state, (ListTypeDecoder)DeclaredTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Declared[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Declared[] result = new Declared[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDeclared(stream, state, (ListTypeDecoder)DeclaredTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        DeclaredTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private Declared readDeclared(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Declared declared = new Declared();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 1) {
            throw new DecodeException("The txn-id field cannot be omitted");
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Declared list encoding: " + count);
        }
        if (count == 1) {
            declared.setTxnId(state.getDecoder().readBinary(stream, state));
        }
        return declared;
    }
}

