/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.transactions;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transactions.Declare;
import org.apache.qpid.protonj2.types.transactions.GlobalTxId;

public final class DeclareTypeDecoder
extends AbstractDescribedTypeDecoder<Declare> {
    private static final int MIN_DECLARE_LIST_ENTRIES = 0;
    private static final int MAX_DECLARE_LIST_ENTRIES = 1;

    @Override
    public Class<Declare> getTypeClass() {
        return Declare.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Declare.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Declare.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Declare readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readDeclare(buffer, state, (ListTypeDecoder)DeclareTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Declare[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Declare[] result = new Declare[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDeclare(buffer, state, (ListTypeDecoder)DeclareTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        DeclareTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private Declare readDeclare(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Declare declare = new Declare();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Declare list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Declare list encoding: " + count);
        }
        if (count == 1) {
            declare.setGlobalId(state.getDecoder().readObject(buffer, state, GlobalTxId.class));
        }
        return declare;
    }

    @Override
    public Declare readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readDeclare(stream, state, (ListTypeDecoder)DeclareTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Declare[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Declare[] result = new Declare[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDeclare(stream, state, (ListTypeDecoder)DeclareTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        DeclareTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private Declare readDeclare(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Declare declare = new Declare();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Declare list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Declare list encoding: " + count);
        }
        if (count == 1) {
            declare.setGlobalId(state.getDecoder().readObject(stream, state, GlobalTxId.class));
        }
        return declare;
    }
}

