/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.security;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.security.SaslMechanisms;

public final class SaslMechanismsTypeDecoder
extends AbstractDescribedTypeDecoder<SaslMechanisms> {
    private static final int REQUIRED_SASL_MECHANISMS_LIST_ENTRIES = 1;

    @Override
    public UnsignedLong getDescriptorCode() {
        return SaslMechanisms.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return SaslMechanisms.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<SaslMechanisms> getTypeClass() {
        return SaslMechanisms.class;
    }

    @Override
    public SaslMechanisms readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readProperties(buffer, state, (ListTypeDecoder)SaslMechanismsTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public SaslMechanisms[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        SaslMechanisms[] result = new SaslMechanisms[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readProperties(buffer, state, (ListTypeDecoder)SaslMechanismsTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        SaslMechanismsTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private SaslMechanisms readProperties(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        SaslMechanisms mechanisms = new SaslMechanisms();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count != 1) {
            throw new DecodeException("SASL Mechanisms must contain at least one mechanisms entry: " + count);
        }
        mechanisms.setSaslServerMechanisms(state.getDecoder().readMultiple(buffer, state, Symbol.class));
        return mechanisms;
    }

    @Override
    public SaslMechanisms readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readProperties(stream, state, (ListTypeDecoder)SaslMechanismsTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public SaslMechanisms[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        SaslMechanisms[] result = new SaslMechanisms[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readProperties(stream, state, (ListTypeDecoder)SaslMechanismsTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        SaslMechanismsTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private SaslMechanisms readProperties(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        SaslMechanisms mechanisms = new SaslMechanisms();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count != 1) {
            throw new DecodeException("SASL Mechanisms must contain at least one mechanisms entry: " + count);
        }
        mechanisms.setSaslServerMechanisms(state.getDecoder().readMultiple(stream, state, Symbol.class));
        return mechanisms;
    }
}

