/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.primitives;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.types.Decimal128;

public final class Decimal128TypeDecoder
extends AbstractPrimitiveTypeDecoder<Decimal128> {
    @Override
    public Class<Decimal128> getTypeClass() {
        return Decimal128.class;
    }

    @Override
    public int getTypeCode() {
        return 148;
    }

    @Override
    public Decimal128 readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        long msb = buffer.readLong();
        long lsb = buffer.readLong();
        return new Decimal128(msb, lsb);
    }

    @Override
    public Decimal128 readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        long msb = ProtonStreamUtils.readLong(stream);
        long lsb = ProtonStreamUtils.readLong(stream);
        return new Decimal128(msb, lsb);
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.skipBytes(16);
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        ProtonStreamUtils.skipBytes(stream, 16L);
    }
}

