/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.primitives;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.PrimitiveArrayTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.PrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.primitives.BooleanTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ByteTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.CharacterTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.DoubleTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.FloatTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Integer32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Integer8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Long8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.LongTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ShortTypeDecoder;

public abstract class AbstractArrayTypeDecoder
extends AbstractPrimitiveTypeDecoder<Object>
implements PrimitiveArrayTypeDecoder {
    @Override
    public Class<Object> getTypeClass() {
        return Object.class;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public Object readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int size = this.readSize(buffer);
        int count = this.readCount(buffer);
        size = this.getTypeCode() == 240 ? (size -= 8) : (size -= 2);
        if (size > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Array size indicated %d is greater than the amount of data available to decode (%d)", size, buffer.getReadableBytes()));
        }
        return AbstractArrayTypeDecoder.decodeArray(buffer, state, count);
    }

    @Override
    public Object readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        this.readSize(stream);
        return AbstractArrayTypeDecoder.decodeAsObject(stream, state, this.readCount(stream));
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.skipBytes(this.readSize(buffer));
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        ProtonStreamUtils.skipBytes(stream, this.readSize(stream));
    }

    protected abstract int readSize(ProtonBuffer var1);

    protected abstract int readCount(ProtonBuffer var1);

    protected abstract int readSize(InputStream var1);

    protected abstract int readCount(InputStream var1);

    private static Object decodeArray(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        if (decoder instanceof PrimitiveTypeDecoder) {
            PrimitiveTypeDecoder primitiveTypeDecoder = (PrimitiveTypeDecoder)decoder;
            int typeCode = primitiveTypeDecoder.getTypeCode();
            if (primitiveTypeDecoder.isJavaPrimitive()) {
                if (typeCode != 65 && typeCode != 66 && count > buffer.getReadableBytes()) {
                    throw new DecodeException(String.format("Array element count %d is specified to be greater than the amount of data available (%d)", count, buffer.getReadableBytes()));
                }
                Class<?> typeClass = decoder.getTypeClass();
                if (Boolean.class.equals(typeClass)) {
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((BooleanTypeDecoder)decoder, buffer, state, count);
                }
                if (Byte.class.equals(typeClass)) {
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((ByteTypeDecoder)decoder, buffer, state, count);
                }
                if (Short.class.equals(typeClass)) {
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((ShortTypeDecoder)decoder, buffer, state, count);
                }
                if (Integer.class.equals(typeClass)) {
                    if (primitiveTypeDecoder.getTypeCode() == 113) {
                        return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((Integer32TypeDecoder)decoder, buffer, state, count);
                    }
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((Integer8TypeDecoder)decoder, buffer, state, count);
                }
                if (Long.class.equals(typeClass)) {
                    if (primitiveTypeDecoder.getTypeCode() == 129) {
                        return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((LongTypeDecoder)decoder, buffer, state, count);
                    }
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((Long8TypeDecoder)decoder, buffer, state, count);
                }
                if (Double.class.equals(typeClass)) {
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((DoubleTypeDecoder)decoder, buffer, state, count);
                }
                if (Float.class.equals(typeClass)) {
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((FloatTypeDecoder)decoder, buffer, state, count);
                }
                if (Character.class.equals(typeClass)) {
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((CharacterTypeDecoder)decoder, buffer, state, count);
                }
                throw new DecodeException("Unexpected class " + decoder.getClass().getName());
            }
            if (decoder.isArrayType()) {
                return AbstractArrayTypeDecoder.decodeNonPrimitiveArray(decoder, buffer, state, count);
            }
            if (typeCode != 68 && typeCode != 67 && typeCode != 69 && count > buffer.getReadableBytes()) {
                throw new DecodeException(String.format("Array element count %d is specified to be greater than the amount of data available (%d)", count, buffer.getReadableBytes()));
            }
            return decoder.readArrayElements(buffer, state, count);
        }
        if (count > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Array element count %d is specified to be greater than the amount of data available (%d)", count, buffer.getReadableBytes()));
        }
        return AbstractArrayTypeDecoder.decodeNonPrimitiveArray(decoder, buffer, state, count);
    }

    private static Object decodeNonPrimitiveArray(TypeDecoder<?> decoder, ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        if (decoder.isArrayType()) {
            PrimitiveArrayTypeDecoder arrayDecoder = (PrimitiveArrayTypeDecoder)decoder;
            Object[] array = new Object[count];
            for (int i = 0; i < count; ++i) {
                array[i] = arrayDecoder.readValue(buffer, state);
            }
            return array;
        }
        return decoder.readArrayElements(buffer, state, count);
    }

    private static boolean[] decodePrimitiveTypeArray(BooleanTypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        boolean[] array = new boolean[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static byte[] decodePrimitiveTypeArray(ByteTypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        byte[] array = new byte[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static char[] decodePrimitiveTypeArray(CharacterTypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        char[] array = new char[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static short[] decodePrimitiveTypeArray(ShortTypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        short[] array = new short[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static int[] decodePrimitiveTypeArray(Integer32TypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static int[] decodePrimitiveTypeArray(Integer8TypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static long[] decodePrimitiveTypeArray(LongTypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        long[] array = new long[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static long[] decodePrimitiveTypeArray(Long8TypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        long[] array = new long[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static float[] decodePrimitiveTypeArray(FloatTypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        float[] array = new float[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static double[] decodePrimitiveTypeArray(DoubleTypeDecoder decoder, ProtonBuffer buffer, DecoderState state, int count) {
        double[] array = new double[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(buffer, state);
        }
        return array;
    }

    private static Object decodeAsObject(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        PrimitiveTypeDecoder primitiveTypeDecoder;
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        if (decoder instanceof PrimitiveTypeDecoder && (primitiveTypeDecoder = (PrimitiveTypeDecoder)decoder).isJavaPrimitive()) {
            Class<?> typeClass = decoder.getTypeClass();
            if (Boolean.class.equals(typeClass)) {
                return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((BooleanTypeDecoder)decoder, stream, state, count);
            }
            if (Byte.class.equals(typeClass)) {
                return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((ByteTypeDecoder)decoder, stream, state, count);
            }
            if (Short.class.equals(typeClass)) {
                return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((ShortTypeDecoder)decoder, stream, state, count);
            }
            if (Integer.class.equals(typeClass)) {
                if (primitiveTypeDecoder.getTypeCode() == 113) {
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((Integer32TypeDecoder)decoder, stream, state, count);
                }
                return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((Integer8TypeDecoder)decoder, stream, state, count);
            }
            if (Long.class.equals(typeClass)) {
                if (primitiveTypeDecoder.getTypeCode() == 129) {
                    return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((LongTypeDecoder)decoder, stream, state, count);
                }
                return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((Long8TypeDecoder)decoder, stream, state, count);
            }
            if (Double.class.equals(typeClass)) {
                return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((DoubleTypeDecoder)decoder, stream, state, count);
            }
            if (Float.class.equals(typeClass)) {
                return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((FloatTypeDecoder)decoder, stream, state, count);
            }
            if (Character.class.equals(typeClass)) {
                return AbstractArrayTypeDecoder.decodePrimitiveTypeArray((CharacterTypeDecoder)decoder, stream, state, count);
            }
            throw new DecodeException("Unexpected class " + decoder.getClass().getName());
        }
        return AbstractArrayTypeDecoder.decodeNonPrimitiveArray(decoder, stream, state, count);
    }

    private static Object[] decodeNonPrimitiveArray(StreamTypeDecoder<?> decoder, InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        if (decoder.isArrayType()) {
            PrimitiveArrayTypeDecoder arrayDecoder = (PrimitiveArrayTypeDecoder)decoder;
            Object[] array = new Object[count];
            for (int i = 0; i < count; ++i) {
                array[i] = arrayDecoder.readValue(stream, state);
            }
            return array;
        }
        return decoder.readArrayElements(stream, state, count);
    }

    private static boolean[] decodePrimitiveTypeArray(BooleanTypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        boolean[] array = new boolean[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }

    private static byte[] decodePrimitiveTypeArray(ByteTypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        byte[] array = new byte[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }

    private static char[] decodePrimitiveTypeArray(CharacterTypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        char[] array = new char[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }

    private static short[] decodePrimitiveTypeArray(ShortTypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        short[] array = new short[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }

    private static int[] decodePrimitiveTypeArray(Integer32TypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }

    private static int[] decodePrimitiveTypeArray(Integer8TypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }

    private static long[] decodePrimitiveTypeArray(LongTypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        long[] array = new long[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }

    private static long[] decodePrimitiveTypeArray(Long8TypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        long[] array = new long[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }

    private static float[] decodePrimitiveTypeArray(FloatTypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        float[] array = new float[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }

    private static double[] decodePrimitiveTypeArray(DoubleTypeDecoder decoder, InputStream stream, StreamDecoderState state, int count) {
        double[] array = new double[count];
        for (int i = 0; i < count; ++i) {
            array[i] = decoder.readPrimitiveValue(stream, state);
        }
        return array;
    }
}

