/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Received;

public final class ReceivedTypeDecoder
extends AbstractDescribedTypeDecoder<Received> {
    private static final int REQUIRED_RECEIVED_LIST_ENTRIES = 2;

    @Override
    public Class<Received> getTypeClass() {
        return Received.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Received.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Received.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Received readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readReceived(buffer, state, (ListTypeDecoder)ReceivedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Received[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Received[] result = new Received[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readReceived(buffer, state, (ListTypeDecoder)ReceivedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        ReceivedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private Received readReceived(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Received received = new Received();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count != 2) {
            throw new DecodeException("Invalid number of entries in Received list encoding: " + count);
        }
        block4: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    received.setSectionNumber(state.getDecoder().readUnsignedInteger(buffer, state));
                    continue block4;
                }
                case 1: {
                    received.setSectionOffset(state.getDecoder().readUnsignedLong(buffer, state));
                }
            }
        }
        return received;
    }

    @Override
    public Received readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readReceived(stream, state, (ListTypeDecoder)ReceivedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Received[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Received[] result = new Received[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readReceived(stream, state, (ListTypeDecoder)ReceivedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ReceivedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private Received readReceived(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Received received = new Received();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count != 2) {
            throw new DecodeException("Invalid number of entries in Received list encoding: " + count);
        }
        block4: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    received.setSectionNumber(state.getDecoder().readUnsignedInteger(stream, state));
                    continue block4;
                }
                case 1: {
                    received.setSectionOffset(state.getDecoder().readUnsignedLong(stream, state));
                }
            }
        }
        return received;
    }
}

