/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.decoders.ProtonDecoder;
import org.apache.qpid.protonj2.codec.decoders.UTF8Decoder;

public final class ProtonDecoderState
implements DecoderState {
    private static final int MAX_CHAR_BUFFER_CACHE_SIZE = 100;
    private final CharsetDecoder STRING_DECODER = StandardCharsets.UTF_8.newDecoder();
    private final ProtonDecoder decoder;
    private final char[] decodeCache = new char[100];
    private UTF8Decoder stringDecoder;

    public ProtonDecoderState(ProtonDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public ProtonDecoder getDecoder() {
        return this.decoder;
    }

    @Override
    public ProtonDecoderState reset() {
        return this;
    }

    public UTF8Decoder getStringDecoder() {
        return this.stringDecoder;
    }

    public ProtonDecoderState setStringDecoder(UTF8Decoder stringDecoder) {
        this.stringDecoder = stringDecoder;
        return this;
    }

    @Override
    public String decodeUTF8(ProtonBuffer buffer, int length) throws DecodeException {
        if (this.stringDecoder == null) {
            return ProtonDecoderState.internalDecode(buffer, length, this.STRING_DECODER, length > 100 ? new char[length] : this.decodeCache);
        }
        int originalPosition = buffer.getReadIndex();
        try {
            String string = this.stringDecoder.decodeUTF8(buffer, length);
            return string;
        }
        catch (Exception ex) {
            throw new DecodeException("Cannot parse encoded UTF8 String", ex);
        }
        finally {
            buffer.setReadIndex(originalPosition + length);
        }
    }

    private static String internalDecode(ProtonBuffer buffer, int length, CharsetDecoder decoder, char[] scratch) {
        byte b;
        int offset;
        int bufferInitialPosition = buffer.getReadIndex();
        for (offset = 0; offset < length && (b = buffer.getByte(bufferInitialPosition + offset)) >= 0; ++offset) {
            scratch[offset] = (char)b;
        }
        buffer.setReadIndex(bufferInitialPosition + offset);
        if (offset == length) {
            return new String(scratch, 0, length);
        }
        return ProtonDecoderState.internalDecodeUTF8(buffer, length, scratch, offset, decoder);
    }

    private static String internalDecodeUTF8(ProtonBuffer buffer, int length, char[] chars, int offset, CharsetDecoder decoder) {
        CharBuffer out = CharBuffer.wrap(chars);
        out.position(offset);
        ProtonBuffer slice = buffer.slice(buffer.getReadIndex(), length - offset);
        buffer.setReadIndex(buffer.getReadIndex() + slice.getReadableBytes());
        ByteBuffer byteBuffer = slice.toByteBuffer();
        try {
            Object cr;
            while (true) {
                Object object = cr = byteBuffer.hasRemaining() ? decoder.decode(byteBuffer, out, true) : CoderResult.UNDERFLOW;
                if (((CoderResult)cr).isUnderflow()) {
                    cr = decoder.flush(out);
                }
                if (((CoderResult)cr).isUnderflow()) break;
                ((CoderResult)cr).throwException();
            }
            cr = out.flip().toString();
            return cr;
        }
        catch (CharacterCodingException e) {
            throw new DecodeException("Cannot parse encoded UTF8 String", e);
        }
        finally {
            decoder.reset();
        }
    }
}

