/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;

public final class ProtonNettyByteBuffer
implements ProtonBuffer {
    private final ByteBuf wrapped;

    public ProtonNettyByteBuffer(ByteBuf toWrap) {
        this.wrapped = toWrap;
    }

    public ProtonNettyByteBuffer(int maximumCapacity) {
        this.wrapped = Unpooled.buffer((int)1024, (int)maximumCapacity);
    }

    public ByteBuf unwrap() {
        return this.wrapped;
    }

    @Override
    public int capacity() {
        return this.wrapped.capacity();
    }

    @Override
    public ProtonBuffer capacity(int newCapacity) {
        this.wrapped.capacity(newCapacity);
        return this;
    }

    @Override
    public ProtonBuffer clear() {
        this.wrapped.clear();
        return this;
    }

    @Override
    public int compareTo(ProtonBuffer other) {
        int length = this.getReadIndex() + Math.min(this.getReadableBytes(), other.getReadableBytes());
        int i = this.getReadIndex();
        int j = other.getReadIndex();
        while (i < length) {
            int cmp = Integer.compare(this.getByte(i) & 0xFF, other.getByte(j) & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return this.getReadableBytes() - other.getReadableBytes();
    }

    @Override
    public ProtonBuffer copy() {
        return new ProtonNettyByteBuffer(this.wrapped.copy());
    }

    @Override
    public ProtonBuffer copy(int index, int length) {
        return new ProtonNettyByteBuffer(this.wrapped.copy(index, length));
    }

    @Override
    public ProtonBuffer duplicate() {
        return new ProtonNettyByteBuffer(this.wrapped.duplicate());
    }

    @Override
    public ProtonBuffer ensureWritable(int minWritableBytes) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.wrapped.ensureWritable(minWritableBytes);
        return this;
    }

    @Override
    public byte[] getArray() {
        return this.wrapped.array();
    }

    @Override
    public int getArrayOffset() {
        return this.wrapped.arrayOffset();
    }

    @Override
    public boolean getBoolean(int index) {
        return this.wrapped.getBoolean(index);
    }

    @Override
    public byte getByte(int index) {
        return this.wrapped.getByte(index);
    }

    @Override
    public ProtonBuffer getBytes(int index, byte[] destination) {
        this.wrapped.getBytes(index, destination);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ByteBuffer destination) {
        this.wrapped.getBytes(index, destination);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer destination) {
        int length = destination.getWritableBytes();
        this.getBytes(index, destination, destination.getWriteIndex(), length);
        destination.setWriteIndex(destination.getWriteIndex() + length);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer destination, int length) {
        this.getBytes(index, destination, destination.getWriteIndex(), length);
        destination.setWriteIndex(destination.getWriteIndex() + length);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer destination, int offset, int length) {
        if (destination.hasArray()) {
            this.wrapped.getBytes(index, destination.getArray(), destination.getArrayOffset() + offset, length);
        } else if (this.hasArray()) {
            destination.setBytes(offset, this.getArray(), this.getArrayOffset() + index, length);
        } else if (destination instanceof ProtonNettyByteBuffer) {
            ProtonNettyByteBuffer wrapper = (ProtonNettyByteBuffer)destination;
            this.wrapped.getBytes(index, wrapper.unwrap(), offset, length);
        } else {
            this.checkDestinationIndex(index, length, offset, destination.capacity());
            for (int i = 0; i < length; ++i) {
                destination.setByte(offset + i, this.wrapped.getByte(index + i));
            }
        }
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, byte[] destination, int offset, int length) {
        this.wrapped.getBytes(index, destination, offset, length);
        return this;
    }

    @Override
    public char getChar(int index) {
        return this.wrapped.getChar(index);
    }

    @Override
    public double getDouble(int index) {
        return this.wrapped.getDouble(index);
    }

    @Override
    public float getFloat(int index) {
        return this.wrapped.getFloat(index);
    }

    @Override
    public int getInt(int index) {
        return this.wrapped.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.wrapped.getLong(index);
    }

    @Override
    public int getReadIndex() {
        return this.wrapped.readerIndex();
    }

    @Override
    public int getReadableBytes() {
        return this.wrapped.readableBytes();
    }

    @Override
    public short getShort(int index) {
        return this.wrapped.getShort(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        return this.wrapped.getUnsignedByte(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return this.wrapped.getUnsignedInt(index);
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.wrapped.getUnsignedShort(index);
    }

    @Override
    public int getWritableBytes() {
        return this.wrapped.writableBytes();
    }

    @Override
    public int getMaxWritableBytes() {
        return this.wrapped.maxWritableBytes();
    }

    @Override
    public int getWriteIndex() {
        return this.wrapped.writerIndex();
    }

    @Override
    public boolean hasArray() {
        return this.wrapped.hasArray();
    }

    @Override
    public boolean isReadable() {
        return this.wrapped.isReadable();
    }

    @Override
    public boolean isReadable(int minReadableBytes) {
        return this.wrapped.isReadable(minReadableBytes);
    }

    @Override
    public boolean isWritable() {
        return this.wrapped.isWritable();
    }

    @Override
    public boolean isWritable(int minWritableBytes) {
        return this.wrapped.isWritable(minWritableBytes);
    }

    @Override
    public ProtonBuffer markReadIndex() {
        this.wrapped.markReaderIndex();
        return this;
    }

    @Override
    public ProtonBuffer markWriteIndex() {
        this.wrapped.markWriterIndex();
        return this;
    }

    @Override
    public int maxCapacity() {
        return this.wrapped.maxCapacity();
    }

    @Override
    public boolean readBoolean() {
        return this.wrapped.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.wrapped.readByte();
    }

    @Override
    public ProtonBuffer readBytes(byte[] destination) {
        this.wrapped.readBytes(destination);
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ByteBuffer destination) {
        this.wrapped.readBytes(destination);
        return this;
    }

    @Override
    public ProtonBuffer readBytes(byte[] destination, int length) {
        this.wrapped.readBytes(destination, 0, length);
        return this;
    }

    @Override
    public ProtonBuffer readBytes(byte[] destination, int offset, int length) {
        this.wrapped.readBytes(destination, offset, length);
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ProtonBuffer destination) {
        this.readBytes(destination, destination.getWritableBytes());
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ProtonBuffer destination, int length) {
        if (length > destination.getWritableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds target Writable Bytes:(%d), target is: %s", length, destination.getWritableBytes(), destination));
        }
        this.readBytes(destination, destination.getWriteIndex(), length);
        destination.setWriteIndex(destination.getWriteIndex() + length);
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ProtonBuffer destination, int offset, int length) {
        this.checkReadableBytes(length);
        this.getBytes(this.wrapped.readerIndex(), destination, offset, length);
        this.wrapped.skipBytes(length);
        return this;
    }

    @Override
    public double readDouble() {
        return this.wrapped.readDouble();
    }

    @Override
    public float readFloat() {
        return this.wrapped.readFloat();
    }

    @Override
    public int readInt() {
        return this.wrapped.readInt();
    }

    @Override
    public long readLong() {
        return this.wrapped.readLong();
    }

    @Override
    public short readShort() {
        return this.wrapped.readShort();
    }

    @Override
    public ProtonBuffer resetReadIndex() {
        this.wrapped.resetReaderIndex();
        return this;
    }

    @Override
    public ProtonBuffer resetWriteIndex() {
        this.wrapped.resetWriterIndex();
        return this;
    }

    @Override
    public ProtonBuffer setBoolean(int index, boolean value) {
        this.wrapped.setBoolean(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setByte(int index, int value) {
        this.wrapped.setByte(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, byte[] value) {
        this.wrapped.setBytes(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ByteBuffer value) {
        this.wrapped.setBytes(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer value) {
        return this.setBytes(index, value, value.getReadableBytes());
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer value, int length) {
        this.checkIndex(index, length);
        if (value == null) {
            throw new NullPointerException("src");
        }
        if (length > value.getReadableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds source buffer Readable Bytes(%d), source is: %s", length, value.getReadableBytes(), value));
        }
        this.setBytes(index, value, value.getReadIndex(), length);
        value.setReadIndex(value.getReadIndex() + length);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer value, int offset, int length) {
        if (value instanceof ProtonNettyByteBuffer) {
            this.wrapped.setBytes(index, (ByteBuf)value.unwrap(), offset, length);
        } else if (value.hasArray()) {
            this.wrapped.setBytes(index, value.getArray(), value.getArrayOffset() + offset, length);
        } else if (this.hasArray()) {
            value.getBytes(offset, this.getArray(), this.getArrayOffset() + index, length);
        } else {
            this.checkSourceIndex(index, length, offset, value.capacity());
            for (int i = 0; i < length; ++i) {
                this.wrapped.setByte(index + i, (int)value.getByte(offset + i));
            }
        }
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, byte[] value, int offset, int length) {
        this.wrapped.setBytes(index, value, offset, length);
        return this;
    }

    @Override
    public ProtonBuffer setChar(int index, int value) {
        this.wrapped.setChar(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setDouble(int index, double value) {
        this.wrapped.setDouble(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setFloat(int index, float value) {
        this.wrapped.setFloat(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setIndex(int readIndex, int writeIndex) {
        this.wrapped.setIndex(readIndex, writeIndex);
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        this.wrapped.setInt(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        this.wrapped.setLong(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setReadIndex(int index) {
        this.wrapped.readerIndex(index);
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, int value) {
        this.wrapped.setShort(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setWriteIndex(int index) {
        this.wrapped.writerIndex(index);
        return this;
    }

    @Override
    public ProtonBuffer skipBytes(int skippedBytes) {
        this.wrapped.skipBytes(skippedBytes);
        return this;
    }

    @Override
    public ProtonBuffer slice() {
        return new ProtonNettyByteBuffer(this.wrapped.slice());
    }

    @Override
    public ProtonBuffer slice(int index, int length) {
        return new ProtonNettyByteBuffer(this.wrapped.slice(index, length));
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.wrapped.nioBuffer();
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        return this.wrapped.nioBuffer(index, length);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    @Override
    public String toString(Charset charset) {
        return this.wrapped.toString(charset);
    }

    @Override
    public ProtonBuffer writeBoolean(boolean value) {
        this.wrapped.writeBoolean(value);
        return this;
    }

    @Override
    public ProtonBuffer writeByte(int value) {
        this.wrapped.writeByte(value);
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ByteBuffer value) {
        this.wrapped.writeBytes(value);
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(byte[] value) {
        this.wrapped.writeBytes(value);
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(byte[] value, int length) {
        this.wrapped.writeBytes(value, 0, length);
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(byte[] array, int offset, int length) {
        this.wrapped.writeBytes(array, offset, length);
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ProtonBuffer value) {
        return this.writeBytes(value, value.getReadableBytes());
    }

    @Override
    public ProtonBuffer writeBytes(ProtonBuffer value, int length) {
        if (length > value.getReadableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds source Readable Bytes(%d), source is: %s", length, value.getReadableBytes(), value));
        }
        this.writeBytes(value, value.getReadIndex(), length);
        value.skipBytes(length);
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ProtonBuffer value, int offset, int length) {
        this.ensureWritable(length);
        this.setBytes(this.wrapped.writerIndex(), value, offset, length);
        this.wrapped.writerIndex(this.wrapped.writerIndex() + length);
        return this;
    }

    @Override
    public ProtonBuffer writeDouble(double value) {
        this.wrapped.writeDouble(value);
        return this;
    }

    @Override
    public ProtonBuffer writeFloat(float value) {
        this.wrapped.writeFloat(value);
        return this;
    }

    @Override
    public ProtonBuffer writeInt(int value) {
        this.wrapped.writeInt(value);
        return this;
    }

    @Override
    public ProtonBuffer writeLong(long value) {
        this.wrapped.writeLong(value);
        return this;
    }

    @Override
    public ProtonBuffer writeShort(short value) {
        this.wrapped.writeShort((int)value);
        return this;
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProtonBuffer)) {
            return false;
        }
        ProtonBuffer that = (ProtonBuffer)other;
        if (this.getReadableBytes() != that.getReadableBytes()) {
            return false;
        }
        int index = this.getReadIndex();
        int i = this.getReadableBytes() - 1;
        int j = that.getReadableBytes() - 1;
        while (i >= index) {
            if (this.getByte(i) != that.getByte(j)) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private final void checkReadableBytes(int minimumReadableBytes) {
        if (minimumReadableBytes < 0) {
            throw new IllegalArgumentException("minimumReadableBytes: " + minimumReadableBytes + " (expected: >= 0)");
        }
        this.internalCheckReadableBytes(minimumReadableBytes);
    }

    private void internalCheckReadableBytes(int minimumReadableBytes) {
        if (this.wrapped.readerIndex() > this.wrapped.writerIndex() - minimumReadableBytes) {
            throw new IndexOutOfBoundsException(String.format("readIndex(%d) + length(%d) exceeds writeIndex(%d): %s", this.wrapped.readerIndex(), minimumReadableBytes, this.wrapped.writerIndex(), this));
        }
    }

    private static boolean isOutOfBounds(int index, int length, int capacity) {
        return (index | length | index + length | capacity - (index + length)) < 0;
    }

    private final void checkIndex(int index, int fieldLength) {
        if (ProtonNettyByteBuffer.isOutOfBounds(index, fieldLength, this.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
        }
    }

    private final void checkSourceIndex(int index, int length, int srcIndex, int srcCapacity) {
        this.checkIndex(index, length);
        if (ProtonNettyByteBuffer.isOutOfBounds(srcIndex, length, srcCapacity)) {
            throw new IndexOutOfBoundsException(String.format("srcIndex: %d, length: %d (expected: range(0, %d))", srcIndex, length, srcCapacity));
        }
    }

    private final void checkDestinationIndex(int index, int length, int dstIndex, int dstCapacity) {
        this.checkIndex(index, length);
        if (ProtonNettyByteBuffer.isOutOfBounds(dstIndex, length, dstCapacity)) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length, dstCapacity));
        }
    }
}

