/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.buffer.ProtonAbstractBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.buffer.ProtonDuplicatedBuffer;

public final class ProtonCompositeBuffer
extends ProtonAbstractBuffer {
    public static final int DEFAULT_MAXIMUM_CAPACITY = Integer.MAX_VALUE;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(EMPTY_BYTE_ARRAY);
    private int capacity;
    private int totalChunks;
    private Chunk lastAccessedChunk;
    private final Chunk head = new Chunk(null, 0, 0, -1, -1);
    private final Chunk tail;

    public ProtonCompositeBuffer() {
        this(Integer.MAX_VALUE);
    }

    public ProtonCompositeBuffer(int maximumCapacity) {
        super(maximumCapacity);
        this.head.next = this.tail = new Chunk(null, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.tail.prev = this.head;
        this.lastAccessedChunk = this.head;
    }

    public ProtonCompositeBuffer append(byte[] array) {
        Objects.requireNonNull(array, "Cannot append null array to composite buffer.");
        return this.append(ProtonByteBufferAllocator.DEFAULT.wrap(array));
    }

    public ProtonCompositeBuffer append(byte[] array, int offset, int length) {
        Objects.requireNonNull(array, "Cannot append null array to composite buffer.");
        return this.append(ProtonByteBufferAllocator.DEFAULT.wrap(array, offset, length));
    }

    public ProtonCompositeBuffer append(ProtonBuffer buffer) {
        if (!buffer.isReadable()) {
            return this;
        }
        if (buffer.getReadableBytes() + this.capacity() > this.maxCapacity()) {
            throw new IndexOutOfBoundsException(String.format("capacity(%d) + readableBytes(%d) exceeds maxCapacity(%d): %s", this.capacity(), buffer.getReadableBytes(), this.maxCapacity(), this));
        }
        int newWriteIndex = this.writeIndex == this.capacity ? this.writeIndex + buffer.getReadableBytes() : this.writeIndex;
        this.appendBuffer(buffer).setWriteIndex(newWriteIndex);
        return this;
    }

    public int numberOfBuffers() {
        return this.totalChunks;
    }

    public ProtonCompositeBuffer foreachBuffer(Consumer<ProtonBuffer> consumer) {
        Chunk current = this.head.next;
        while (current != this.tail) {
            consumer.accept(current.buffer.duplicate());
            current = current.next;
        }
        return this;
    }

    public ProtonCompositeBuffer foreachInternalBuffer(Consumer<ProtonBuffer> consumer) {
        Chunk current = this.head.next;
        while (current != this.tail) {
            consumer.accept(current.buffer);
            current = current.next;
        }
        return this;
    }

    public ProtonCompositeBuffer reclaimRead() {
        int readIndex = this.readIndex;
        if (readIndex == 0) {
            return this;
        }
        int writeIndex = this.writeIndex;
        if (readIndex == writeIndex && writeIndex == this.capacity()) {
            this.capacity = 0;
            this.totalChunks = 0;
            this.lastAccessedChunk = this.head;
            this.head.next = this.tail;
            this.tail.prev = this.head;
            this.setIndex(0, 0);
            this.adjustIndexMarks(readIndex);
        } else {
            int removedSize = 0;
            while (this.head.next != this.tail && this.head.next.endIndex < readIndex) {
                --this.totalChunks;
                removedSize += this.head.next.length;
                this.head.next = this.head.next.next;
                this.head.next.prev = this.head;
            }
            if (removedSize == 0) {
                return this;
            }
            if (this.lastAccessedChunk != null && this.lastAccessedChunk.endIndex < readIndex) {
                this.lastAccessedChunk = this.head;
            }
            Chunk current = this.head.next;
            while (current != this.tail) {
                current.startIndex -= removedSize;
                current.endIndex -= removedSize;
                current = current.next;
            }
            this.capacity -= removedSize;
            this.setIndex(this.getReadIndex() - removedSize, this.getWriteIndex() - removedSize);
            this.adjustIndexMarks(removedSize);
        }
        return this;
    }

    @Override
    public boolean hasArray() {
        switch (this.totalChunks) {
            case 0: {
                return true;
            }
            case 1: {
                return this.head.next.buffer.hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] getArray() {
        switch (this.totalChunks) {
            case 0: {
                return EMPTY_BYTE_ARRAY;
            }
            case 1: {
                return this.head.next.buffer.getArray();
            }
        }
        throw new UnsupportedOperationException("Buffer does not have a backing array.");
    }

    @Override
    public int getArrayOffset() {
        switch (this.totalChunks) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.head.next.buffer.getArrayOffset();
            }
        }
        throw new UnsupportedOperationException("Buffer does not have a backing array.");
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ProtonBuffer capacity(int newCapacity) {
        this.checkNewCapacity(newCapacity);
        if (newCapacity > this.capacity) {
            int amountNeeded = newCapacity - this.capacity;
            this.appendBuffer(ProtonByteBufferAllocator.DEFAULT.allocate(amountNeeded, amountNeeded).setWriteIndex(amountNeeded));
        } else if (newCapacity < this.capacity) {
            int reductionTarget = this.capacity - newCapacity;
            Chunk current = this.tail.prev;
            while (current != this.head) {
                if (current.length > reductionTarget) {
                    Chunk replacement;
                    ProtonBuffer sliced = current.buffer.slice(current.buffer.getReadIndex(), reductionTarget);
                    current.next.prev = replacement = new Chunk(sliced, 0, reductionTarget, current.startIndex, current.startIndex + reductionTarget);
                    current.prev.next = replacement;
                    replacement.next = current.next;
                    replacement.prev = current.prev;
                    break;
                }
                reductionTarget -= current.length;
                current.next.prev = current.prev;
                current.prev.next = current.next;
                --this.totalChunks;
                current = current.prev;
            }
            this.capacity = newCapacity;
            if (this.writeIndex > this.capacity) {
                this.writeIndex = this.capacity;
            }
            if (this.readIndex > this.capacity) {
                this.readIndex = this.capacity;
            }
        }
        return this;
    }

    @Override
    public ProtonBuffer duplicate() {
        return new ProtonDuplicatedBuffer(this);
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index, 1);
        Chunk targetChunk = this.findChunkWithIndex(index);
        return targetChunk.readByte(index);
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        short result = 0;
        this.lastAccessedChunk = this.findChunkWithIndex(index);
        for (int i = 1; i >= 0; --i) {
            result = (short)(result | (this.lastAccessedChunk.readByte(index++) & 0xFF) << i * 8);
            if (this.lastAccessedChunk.endIndex >= index) continue;
            this.lastAccessedChunk = this.lastAccessedChunk.next;
        }
        return result;
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        this.lastAccessedChunk = this.findChunkWithIndex(index);
        int result = 0;
        for (int i = 3; i >= 0; --i) {
            result |= (this.lastAccessedChunk.readByte(index++) & 0xFF) << i * 8;
            if (this.lastAccessedChunk.endIndex >= index) continue;
            this.lastAccessedChunk = this.lastAccessedChunk.next;
        }
        return result;
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        this.lastAccessedChunk = this.findChunkWithIndex(index);
        long result = 0L;
        for (int i = 7; i >= 0; --i) {
            result |= (long)(this.lastAccessedChunk.readByte(index++) & 0xFF) << i * 8;
            if (this.lastAccessedChunk.endIndex >= index) continue;
            this.lastAccessedChunk = this.lastAccessedChunk.next;
        }
        return result;
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer destination, int destinationIndex, int length) {
        this.checkDestinationIndex(index, length, destinationIndex, destination.capacity());
        while (length > 0) {
            this.lastAccessedChunk = this.findChunkWithIndex(index);
            int readBytes = this.lastAccessedChunk.getBytes(index, destination, destinationIndex, length);
            index += readBytes;
            length -= readBytes;
            destinationIndex += readBytes;
        }
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, byte[] destination, int offset, int length) {
        this.checkDestinationIndex(index, length, offset, destination.length);
        while (length > 0) {
            this.lastAccessedChunk = this.findChunkWithIndex(index);
            int readBytes = this.lastAccessedChunk.getBytes(index, destination, offset, length);
            index += readBytes;
            length -= readBytes;
            offset += readBytes;
        }
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ByteBuffer destination) {
        this.checkIndex(index, destination.remaining());
        while (destination.hasRemaining()) {
            this.lastAccessedChunk = this.findChunkWithIndex(index);
            int readBytes = this.lastAccessedChunk.getBytes(index, destination);
            index += readBytes;
        }
        return this;
    }

    @Override
    public ProtonBuffer setByte(int index, int value) {
        this.checkIndex(index, 1);
        this.lastAccessedChunk = this.findChunkWithIndex(index);
        this.lastAccessedChunk.writeByte(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, int value) {
        this.checkIndex(index, 2);
        this.lastAccessedChunk = this.findChunkWithIndex(index);
        this.lastAccessedChunk.writeByte(index++, (byte)(value >>> 8));
        if (this.lastAccessedChunk.endIndex < index) {
            this.lastAccessedChunk = this.lastAccessedChunk.next;
        }
        this.lastAccessedChunk.writeByte(index++, (byte)(value & 0xFF));
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        this.checkIndex(index, 4);
        this.lastAccessedChunk = this.findChunkWithIndex(index);
        for (int i = 3; i >= 0; --i) {
            this.lastAccessedChunk.writeByte(index++, (byte)(value >>> i * 8));
            if (this.lastAccessedChunk.endIndex >= index) continue;
            this.lastAccessedChunk = this.lastAccessedChunk.next;
        }
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        this.checkIndex(index, 8);
        this.lastAccessedChunk = this.findChunkWithIndex(index);
        for (int i = 7; i >= 0; --i) {
            this.lastAccessedChunk.writeByte(index++, (byte)(value >>> i * 8));
            if (this.lastAccessedChunk.endIndex >= index) continue;
            this.lastAccessedChunk = this.lastAccessedChunk.next;
        }
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer source, int sourceIndex, int length) {
        this.checkSourceIndex(index, length, sourceIndex, source.capacity());
        while (length > 0) {
            this.lastAccessedChunk = this.findChunkWithIndex(index);
            int writtenBytes = this.lastAccessedChunk.setBytes(index, source, sourceIndex, length);
            index += writtenBytes;
            length -= writtenBytes;
            sourceIndex += writtenBytes;
        }
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, byte[] source, int sourceIndex, int length) {
        this.checkSourceIndex(index, length, sourceIndex, source.length);
        while (length > 0) {
            this.lastAccessedChunk = this.findChunkWithIndex(index);
            int writtenBytes = this.lastAccessedChunk.setBytes(index, source, sourceIndex, length);
            index += writtenBytes;
            length -= writtenBytes;
            sourceIndex += writtenBytes;
        }
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ByteBuffer source) {
        this.checkSourceIndex(index, source.remaining() - source.position(), source.position(), source.remaining());
        while (source.hasRemaining()) {
            this.lastAccessedChunk = this.findChunkWithIndex(index);
            int writtenBytes = this.lastAccessedChunk.setBytes(index, source);
            index += writtenBytes;
        }
        return this;
    }

    @Override
    public ProtonBuffer copy(int index, int length) {
        this.checkIndex(index, length);
        ProtonByteBuffer copy = ProtonByteBufferAllocator.DEFAULT.allocate(length);
        this.getBytes(index, copy);
        copy.setWriteIndex(length);
        return copy;
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        switch (this.totalChunks) {
            case 0: {
                return EMPTY_BYTE_BUFFER;
            }
            case 1: {
                return this.head.next.toByteBuffer(index, length);
            }
        }
        return this.internalToByteBuffer(index, length);
    }

    private ByteBuffer internalToByteBuffer(int index, int length) {
        this.checkIndex(index, length);
        Chunk targetChunk = this.findChunkWithIndex(index);
        if (targetChunk.isInRange(index, length)) {
            return targetChunk.toByteBuffer(index, length);
        }
        byte[] copy = new byte[length];
        int offset = 0;
        while (length > 0) {
            int readBytes = targetChunk.getBytes(index, copy, offset, length);
            length -= readBytes;
            offset += readBytes;
            targetChunk = this.findChunkWithIndex(index += readBytes);
        }
        return ByteBuffer.wrap(copy);
    }

    private Chunk findChunkWithIndex(int index) {
        block2: {
            block3: {
                if (index >= this.lastAccessedChunk.startIndex) break block3;
                while (this.lastAccessedChunk.prev != this.head) {
                    this.lastAccessedChunk = this.lastAccessedChunk.prev;
                    if (!this.lastAccessedChunk.isInRange(index)) continue;
                    break block2;
                }
                break block2;
            }
            if (index <= this.lastAccessedChunk.endIndex) break block2;
            while (this.lastAccessedChunk.next != this.tail) {
                this.lastAccessedChunk = this.lastAccessedChunk.next;
                if (!this.lastAccessedChunk.isInRange(index)) continue;
                break;
            }
        }
        return this.lastAccessedChunk;
    }

    private ProtonCompositeBuffer appendBuffer(ProtonBuffer buffer) {
        int window = buffer.getReadableBytes();
        this.capacity += window;
        ++this.totalChunks;
        Chunk newChunk = new Chunk(buffer, buffer.getReadIndex(), window, this.tail.prev.endIndex + 1, this.tail.prev.endIndex + window);
        newChunk.prev = this.tail.prev;
        newChunk.next = this.tail;
        this.tail.prev.next = newChunk;
        this.tail.prev = newChunk;
        if (this.lastAccessedChunk == this.head || this.lastAccessedChunk == this.tail) {
            this.lastAccessedChunk = newChunk;
        }
        return this;
    }

    private void checkBufferIndex(int index) {
        if (index < 0 || index > this.totalChunks) {
            throw new IndexOutOfBoundsException(String.format("The buffer index: %d (expected: >= 0 && <= numberOfBuffers(%d))", index, this.totalChunks));
        }
    }

    private static class Chunk {
        private final ProtonBuffer buffer;
        private final int offset;
        private final int length;
        private int startIndex;
        private int endIndex;
        private Chunk next;
        private Chunk prev;

        public Chunk(ProtonBuffer buffer, int offset, int length, int startIndex, int endIndex) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getBytes(int index, ByteBuffer destination) {
            int readable = Math.min(this.length - (index - this.startIndex), destination.remaining());
            int oldLimit = destination.limit();
            destination.limit(destination.position() + readable);
            try {
                this.buffer.getBytes(this.offset(index), destination);
            }
            finally {
                destination.limit(oldLimit);
            }
            return readable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int setBytes(int index, ByteBuffer source) {
            int writeable = Math.min(this.length - (index - this.startIndex), source.remaining());
            int oldLimit = source.limit();
            source.limit(source.position() + writeable);
            try {
                this.buffer.setBytes(this.offset(index), source);
            }
            finally {
                source.limit(oldLimit);
            }
            return writeable;
        }

        public int getBytes(int index, byte[] destination, int offset, int desiredLength) {
            int readable = Math.min(this.length - (index - this.startIndex), desiredLength);
            this.buffer.getBytes(this.offset(index), destination, offset, readable);
            return readable;
        }

        public int setBytes(int index, byte[] source, int offset, int desiredLength) {
            int writeable = Math.min(this.length - (index - this.startIndex), desiredLength);
            this.buffer.setBytes(this.offset(index), source, offset, writeable);
            return writeable;
        }

        public int getBytes(int index, ProtonBuffer destination, int destinationIndex, int desiredLength) {
            int readable = Math.min(this.length - (index - this.startIndex), desiredLength);
            this.buffer.getBytes(this.offset(index), destination, destinationIndex, readable);
            return readable;
        }

        public int setBytes(int index, ProtonBuffer source, int sourceIndex, int desiredLength) {
            int writeable = Math.min(this.length - (index - this.startIndex), desiredLength);
            this.buffer.setBytes(this.offset(index), source, sourceIndex, writeable);
            return writeable;
        }

        public byte readByte(int index) {
            return this.buffer.getByte(this.offset(index));
        }

        public void writeByte(int index, int value) {
            this.buffer.setByte(this.offset(index), value);
        }

        public boolean isInRange(int index) {
            return index >= this.startIndex && index <= this.endIndex;
        }

        public boolean isInRange(int index, int length) {
            return index >= this.startIndex && index + (length - 1) <= this.endIndex;
        }

        public ByteBuffer toByteBuffer(int index, int length) {
            return this.buffer.toByteBuffer(this.offset(index), length);
        }

        public String toString() {
            return String.format("Chunk: { len=%d, sidx=%d, eidx=%d }", this.length, this.startIndex, this.endIndex);
        }

        private int offset(int index) {
            return index - this.startIndex + this.offset;
        }
    }
}

