/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

public abstract class ProtonByteUtils {
    public static byte[] toByteArray(byte value) {
        return ProtonByteUtils.writeByte(value, new byte[1], 0);
    }

    public static byte[] toByteArray(short value) {
        return ProtonByteUtils.writeShort(value, new byte[2], 0);
    }

    public static byte[] toByteArray(int value) {
        return ProtonByteUtils.writeInt(value, new byte[4], 0);
    }

    public static byte[] toByteArray(long value) {
        return ProtonByteUtils.writeLong(value, new byte[8], 0);
    }

    public static byte[] writeByte(byte value, byte[] destination, int offset) {
        destination[offset] = value;
        return destination;
    }

    public static byte[] writeShort(short value, byte[] destination, int offset) {
        destination[offset++] = (byte)(value >>> 8);
        destination[offset++] = (byte)(value >>> 0);
        return destination;
    }

    public static byte[] writeInt(int value, byte[] destination, int offset) {
        destination[offset++] = (byte)(value >>> 24);
        destination[offset++] = (byte)(value >>> 16);
        destination[offset++] = (byte)(value >>> 8);
        destination[offset++] = (byte)(value >>> 0);
        return destination;
    }

    public static byte[] writeLong(long value, byte[] destination, int offset) {
        destination[offset++] = (byte)(value >>> 56);
        destination[offset++] = (byte)(value >>> 48);
        destination[offset++] = (byte)(value >>> 40);
        destination[offset++] = (byte)(value >>> 32);
        destination[offset++] = (byte)(value >>> 24);
        destination[offset++] = (byte)(value >>> 16);
        destination[offset++] = (byte)(value >>> 8);
        destination[offset++] = (byte)(value >>> 0);
        return destination;
    }

    public static byte readByte(byte[] array, int offset) {
        return array[offset];
    }

    public static short readShort(byte[] array, int offset) {
        return (short)((array[offset++] & 0xFF) << 8 | (array[offset++] & 0xFF) << 0);
    }

    public static int readInt(byte[] array, int offset) {
        return (array[offset++] & 0xFF) << 24 | (array[offset++] & 0xFF) << 16 | (array[offset++] & 0xFF) << 8 | (array[offset++] & 0xFF) << 0;
    }

    public static long readLong(byte[] array, int offset) {
        return (long)(array[offset++] & 0xFF) << 56 | (long)(array[offset++] & 0xFF) << 48 | (long)(array[offset++] & 0xFF) << 40 | (long)(array[offset++] & 0xFF) << 32 | (long)(array[offset++] & 0xFF) << 24 | (long)(array[offset++] & 0xFF) << 16 | (long)(array[offset++] & 0xFF) << 8 | (long)(array[offset++] & 0xFF) << 0;
    }
}

