/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.buffer.ProtonByteBuffer;

public final class ProtonByteBufferAllocator
implements ProtonBufferAllocator {
    public static final ProtonByteBufferAllocator DEFAULT = new ProtonByteBufferAllocator();

    @Override
    public ProtonByteBuffer allocate() {
        return new ProtonByteBuffer();
    }

    @Override
    public ProtonByteBuffer allocate(int initialCapacity) {
        return new ProtonByteBuffer(initialCapacity);
    }

    @Override
    public ProtonByteBuffer allocate(int initialCapacity, int maximumCapacity) {
        return new ProtonByteBuffer(initialCapacity, maximumCapacity);
    }

    @Override
    public ProtonBuffer outputBuffer(int initialCapacity) {
        return this.allocate(initialCapacity);
    }

    @Override
    public ProtonBuffer outputBuffer(int initialCapacity, int maximumCapacity) {
        return this.allocate(initialCapacity, maximumCapacity);
    }

    @Override
    public ProtonBuffer wrap(byte[] array) {
        return new ProtonByteBuffer(array, array.length).slice();
    }

    @Override
    public ProtonBuffer wrap(byte[] array, int offset, int length) {
        return new ProtonByteBuffer(array, array.length).slice(offset, length);
    }

    @Override
    public ProtonBuffer wrap(ByteBuffer buffer) {
        if (buffer.isReadOnly() || buffer.isDirect()) {
            throw new UnsupportedOperationException("Cannot wrap direct or read-only buffers");
        }
        if (buffer.hasArray()) {
            return this.wrap(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
        throw new UnsupportedOperationException("Cannot wrap buffer that are not array backed");
    }
}

