/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;

public class ProtonBufferInputStream
extends InputStream
implements DataInput {
    private final ProtonBuffer buffer;
    private final int initialReadIndex;
    private boolean closed;
    private StringBuilder readBuffer;

    public ProtonBufferInputStream(ProtonBuffer buffer) {
        Objects.requireNonNull(buffer, "The given ProtonBuffer to wrap cannot be null");
        this.buffer = buffer;
        this.initialReadIndex = buffer.getReadIndex();
    }

    public int getBytesRead() {
        return this.buffer.getReadIndex() - this.initialReadIndex;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public int available() throws IOException {
        return this.buffer.getReadableBytes();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buffer.markReadIndex();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buffer.resetReadIndex();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.buffer.getReadableBytes() == 0) {
            return -1;
        }
        int result = this.buffer.readByte() & 0xFF;
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        len = Math.min(available, len);
        this.buffer.readBytes(b, off, len);
        return len;
    }

    @Override
    public long skip(long skipAmount) throws IOException {
        this.checkClosed();
        if (skipAmount > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)skipAmount);
    }

    @Override
    public int skipBytes(int skipAmount) throws IOException {
        this.checkClosed();
        int nBytes = Math.min(this.available(), skipAmount);
        this.buffer.skipBytes(nBytes);
        return nBytes;
    }

    @Override
    public void readFully(byte[] target) throws IOException {
        this.checkClosed();
        this.checkAvailable(target.length);
        this.buffer.readBytes(target);
    }

    @Override
    public void readFully(byte[] target, int offset, int length) throws IOException {
        this.checkClosed();
        this.checkAvailable(length);
        this.buffer.readBytes(target, offset, length);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkClosed();
        this.checkAvailable(1);
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.checkClosed();
        this.checkAvailable(1);
        return this.buffer.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkClosed();
        this.checkAvailable(1);
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.checkClosed();
        this.checkAvailable(2);
        return this.buffer.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.checkClosed();
        this.checkAvailable(2);
        return this.buffer.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        this.checkClosed();
        this.checkAvailable(2);
        return (char)this.buffer.readShort();
    }

    @Override
    public int readInt() throws IOException {
        this.checkClosed();
        this.checkAvailable(4);
        return this.buffer.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.checkClosed();
        this.checkAvailable(8);
        return this.buffer.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.checkClosed();
        this.checkAvailable(4);
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.checkClosed();
        this.checkAvailable(8);
        return this.buffer.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        String result;
        this.checkClosed();
        int available = this.available();
        if (available == 0) {
            return null;
        }
        block4: while (true) {
            int c = this.buffer.readByte() & 0xFF;
            --available;
            switch (c) {
                case 10: {
                    break block4;
                }
                case 13: {
                    if (available <= 0 || (char)this.buffer.getUnsignedByte(this.buffer.getReadIndex()) != '\n') break block4;
                    this.buffer.skipBytes(1);
                    --available;
                    break block4;
                }
                default: {
                    if (this.readBuffer == null) {
                        this.readBuffer = new StringBuilder();
                    }
                    this.readBuffer.append((char)c);
                    if (available > 0) continue block4;
                }
            }
            break;
        }
        String string = result = this.readBuffer != null && this.readBuffer.length() > 0 ? this.readBuffer.toString() : "";
        if (this.readBuffer != null) {
            this.readBuffer.setLength(0);
        }
        return result;
    }

    @Override
    public String readUTF() throws IOException {
        this.checkClosed();
        return DataInputStream.readUTF(this);
    }

    private void checkAvailable(int required) throws IOException {
        if (required < 0) {
            throw new IndexOutOfBoundsException("fieldSize cannot be a negative number");
        }
        if (required > this.available()) {
            throw new EOFException("The required number of bytes is too high! Length is " + required + ", but maximum readable is " + this.available());
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("The ProtonBuffer InputStream has been closed");
        }
    }
}

