/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonDuplicatedBuffer;
import org.apache.qpid.protonj2.buffer.ProtonSlicedBuffer;

public abstract class ProtonAbstractBuffer
implements ProtonBuffer {
    protected int readIndex;
    protected int writeIndex;
    protected int markedReadIndex;
    protected int markedWriteIndex;
    private int maximumCapacity;

    protected ProtonAbstractBuffer(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("Maximum capacity should be non-negative but was: " + maximumCapacity);
        }
        this.maximumCapacity = maximumCapacity;
    }

    @Override
    public int maxCapacity() {
        return this.maximumCapacity;
    }

    @Override
    public int getReadableBytes() {
        return this.writeIndex - this.readIndex;
    }

    @Override
    public int getWritableBytes() {
        return this.capacity() - this.writeIndex;
    }

    @Override
    public int getMaxWritableBytes() {
        return this.maxCapacity() - this.writeIndex;
    }

    @Override
    public int getReadIndex() {
        return this.readIndex;
    }

    @Override
    public ProtonBuffer setReadIndex(int value) {
        if (value < 0 || value > this.writeIndex) {
            throw new IndexOutOfBoundsException(String.format("readIndex: %d (expected: 0 <= readIndex <= writeIndex(%d))", value, this.writeIndex));
        }
        this.readIndex = value;
        return this;
    }

    @Override
    public int getWriteIndex() {
        return this.writeIndex;
    }

    @Override
    public ProtonBuffer setWriteIndex(int value) {
        if (value < this.readIndex || value > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("writeIndex: %d (expected: readIndex(%d) <= writeIndex <= capacity(%d))", value, this.readIndex, this.capacity()));
        }
        this.writeIndex = value;
        return this;
    }

    @Override
    public ProtonBuffer setIndex(int readIndex, int writeIndex) {
        if (readIndex < 0 || readIndex > writeIndex || writeIndex > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("readIndex: %d, writeIndex: %d (expected: 0 <= readeIndex <= writeIndex <= capacity(%d))", readIndex, writeIndex, this.capacity()));
        }
        this.readIndex = readIndex;
        this.writeIndex = writeIndex;
        return this;
    }

    @Override
    public ProtonBuffer markReadIndex() {
        this.markedReadIndex = this.readIndex;
        return this;
    }

    @Override
    public ProtonBuffer resetReadIndex() {
        this.setReadIndex(this.markedReadIndex);
        return this;
    }

    @Override
    public ProtonBuffer markWriteIndex() {
        this.markedWriteIndex = this.writeIndex;
        return this;
    }

    @Override
    public ProtonBuffer resetWriteIndex() {
        this.setWriteIndex(this.markedWriteIndex);
        return this;
    }

    @Override
    public boolean isReadable() {
        return this.writeIndex > this.readIndex;
    }

    @Override
    public boolean isReadable(int numBytes) {
        return this.writeIndex - this.readIndex >= numBytes;
    }

    @Override
    public boolean isWritable() {
        return this.capacity() > this.writeIndex;
    }

    @Override
    public boolean isWritable(int numBytes) {
        return this.capacity() - this.writeIndex >= numBytes;
    }

    @Override
    public ProtonBuffer clear() {
        this.readIndex = 0;
        this.writeIndex = 0;
        return this;
    }

    @Override
    public ProtonBuffer skipBytes(int length) {
        this.checkReadableBytes(length);
        this.readIndex += length;
        return this;
    }

    @Override
    public ProtonBuffer slice() {
        return this.slice(this.readIndex, this.getReadableBytes());
    }

    @Override
    public ProtonBuffer slice(int index, int length) {
        this.checkIndex(index, length);
        return new ProtonSlicedBuffer(this, index, length);
    }

    @Override
    public ProtonBuffer duplicate() {
        return new ProtonDuplicatedBuffer(this);
    }

    @Override
    public ProtonBuffer copy() {
        return this.copy(this.readIndex, this.getReadableBytes());
    }

    @Override
    public abstract ProtonBuffer copy(int var1, int var2);

    @Override
    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(this.readIndex, this.getReadableBytes());
    }

    @Override
    public abstract ByteBuffer toByteBuffer(int var1, int var2);

    @Override
    public ProtonBuffer ensureWritable(int minWritableBytes) {
        if (minWritableBytes < 0) {
            throw new IllegalArgumentException(String.format("minWritableBytes: %d (expected: >= 0)", minWritableBytes));
        }
        this.internalEnsureWritable(minWritableBytes);
        return this;
    }

    @Override
    public byte readByte() {
        this.internalCheckReadableBytes(1);
        return this.getByte(this.readIndex++);
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public short readShort() {
        this.internalCheckReadableBytes(2);
        short result = this.getShort(this.readIndex);
        this.readIndex += 2;
        return result;
    }

    @Override
    public int readInt() {
        this.internalCheckReadableBytes(4);
        int result = this.getInt(this.readIndex);
        this.readIndex += 4;
        return result;
    }

    @Override
    public long readLong() {
        this.internalCheckReadableBytes(8);
        long result = this.getLong(this.readIndex);
        this.readIndex += 8;
        return result;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public ProtonBuffer readBytes(byte[] target) {
        this.readBytes(target, 0, target.length);
        return this;
    }

    @Override
    public ProtonBuffer readBytes(byte[] target, int length) {
        this.readBytes(target, 0, length);
        return this;
    }

    @Override
    public ProtonBuffer readBytes(byte[] target, int offset, int length) {
        this.checkReadableBytes(length);
        this.getBytes(this.readIndex, target, offset, length);
        this.readIndex += length;
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ProtonBuffer target) {
        this.readBytes(target, target.getWritableBytes());
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ProtonBuffer target, int length) {
        if (length > target.getWritableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds target Writable Bytes:(%d), target is: %s", length, target.getWritableBytes(), target));
        }
        this.readBytes(target, target.getWriteIndex(), length);
        target.setWriteIndex(target.getWriteIndex() + length);
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ProtonBuffer target, int offset, int length) {
        this.checkReadableBytes(length);
        this.getBytes(this.readIndex, target, offset, length);
        this.readIndex += length;
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ByteBuffer dst) {
        int length = dst.remaining();
        this.checkReadableBytes(length);
        this.getBytes(this.readIndex, dst);
        this.readIndex += length;
        return this;
    }

    @Override
    public ProtonBuffer writeByte(int value) {
        this.internalEnsureWritable(1);
        return this.setByte(this.writeIndex++, value);
    }

    @Override
    public ProtonBuffer writeBoolean(boolean value) {
        this.writeByte(value ? 1 : 0);
        return this;
    }

    @Override
    public ProtonBuffer writeShort(short value) {
        this.internalEnsureWritable(2);
        this.setShort(this.writeIndex, value);
        this.writeIndex += 2;
        return this;
    }

    @Override
    public ProtonBuffer writeInt(int value) {
        this.internalEnsureWritable(4);
        this.setInt(this.writeIndex, value);
        this.writeIndex += 4;
        return this;
    }

    @Override
    public ProtonBuffer writeLong(long value) {
        this.internalEnsureWritable(8);
        this.setLong(this.writeIndex, value);
        this.writeIndex += 8;
        return this;
    }

    @Override
    public ProtonBuffer writeFloat(float value) {
        this.writeInt(Float.floatToRawIntBits(value));
        return this;
    }

    @Override
    public ProtonBuffer writeDouble(double value) {
        this.writeLong(Double.doubleToRawLongBits(value));
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(byte[] source, int length) {
        this.writeBytes(source, 0, length);
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(byte[] source, int offset, int length) {
        this.ensureWritable(length);
        this.setBytes(this.writeIndex, source, offset, length);
        this.writeIndex += length;
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ProtonBuffer source) {
        this.writeBytes(source, source.getReadableBytes());
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ProtonBuffer source, int length) {
        if (length > source.getReadableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds source Readable Bytes(%d), source is: %s", length, source.getReadableBytes(), source));
        }
        this.writeBytes(source, source.getReadIndex(), length);
        source.setReadIndex(source.getReadIndex() + length);
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ProtonBuffer source, int offset, int length) {
        this.ensureWritable(length);
        this.setBytes(this.writeIndex, source, offset, length);
        this.writeIndex += length;
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ByteBuffer source) {
        int length = source.remaining();
        this.ensureWritable(length);
        this.setBytes(this.writeIndex, source);
        this.writeIndex += length;
        return this;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.getByte(index) != 0;
    }

    @Override
    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public ProtonBuffer getBytes(int index, byte[] target) {
        this.getBytes(index, target, 0, target.length);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer target) {
        this.getBytes(index, target, target.getWritableBytes());
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer target, int length) {
        this.getBytes(index, target, target.getWriteIndex(), length);
        target.setWriteIndex(target.getWriteIndex() + length);
        return this;
    }

    @Override
    public ProtonBuffer setBoolean(int index, boolean value) {
        this.setByte(index, value ? 1 : 0);
        return this;
    }

    @Override
    public ProtonBuffer setChar(int index, int value) {
        this.setShort(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setFloat(int index, float value) {
        this.setInt(index, Float.floatToRawIntBits(value));
        return this;
    }

    @Override
    public ProtonBuffer setDouble(int index, double value) {
        this.setLong(index, Double.doubleToRawLongBits(value));
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, byte[] src) {
        this.setBytes(index, src, 0, src.length);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer source) {
        this.setBytes(index, source, source.getReadableBytes());
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer source, int length) {
        this.checkIndex(index, length);
        if (source == null) {
            throw new NullPointerException("src");
        }
        if (length > source.getReadableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds source buffer Readable Bytes(%d), source is: %s", length, source.getReadableBytes(), source));
        }
        this.setBytes(index, source, source.getReadIndex(), length);
        source.setReadIndex(source.getReadIndex() + length);
        return this;
    }

    public int hashCode() {
        int i;
        int readable = this.getReadableBytes();
        int readableInts = readable >>> 2;
        int remainingBytes = readable & 3;
        int hash = 1;
        int position = this.getReadIndex();
        for (i = readableInts; i > 0; --i) {
            hash = 31 * hash + this.getInt(position);
            position += 4;
        }
        for (i = remainingBytes; i > 0; --i) {
            hash = 31 * hash + this.getByte(position++);
        }
        if (hash == 0) {
            hash = 1;
        }
        return hash;
    }

    public boolean equals(Object other) {
        int i;
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProtonBuffer)) {
            return false;
        }
        ProtonBuffer that = (ProtonBuffer)other;
        if (this.getReadableBytes() != that.getReadableBytes()) {
            return false;
        }
        int readable = this.getReadableBytes();
        int longCount = readable >>> 3;
        int byteCount = readable & 7;
        int positionSelf = this.getReadIndex();
        int positionOther = that.getReadIndex();
        for (i = longCount; i > 0; --i) {
            if (this.getLong(positionSelf) != that.getLong(positionOther)) {
                return false;
            }
            positionSelf += 8;
            positionOther += 8;
        }
        for (i = byteCount; i > 0; --i) {
            if (this.getByte(positionSelf) != that.getByte(positionOther)) {
                return false;
            }
            ++positionSelf;
            ++positionOther;
        }
        return true;
    }

    @Override
    public int compareTo(ProtonBuffer other) {
        int length = this.getReadIndex() + Math.min(this.getReadableBytes(), other.getReadableBytes());
        int i = this.getReadIndex();
        int j = other.getReadIndex();
        while (i < length) {
            int cmp = Integer.compare(this.getByte(i) & 0xFF, other.getByte(j) & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return this.getReadableBytes() - other.getReadableBytes();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ read:" + this.getReadIndex() + ", write: " + this.getWriteIndex() + ", capacity: " + this.capacity() + "}";
    }

    @Override
    public String toString(Charset charset) {
        String result;
        if (this.hasArray()) {
            result = new String(this.getArray(), this.getArrayOffset() + this.getReadIndex(), this.getReadableBytes(), charset);
        } else {
            byte[] copy = new byte[this.getReadableBytes()];
            this.getBytes(this.getReadIndex(), copy);
            result = new String(copy, 0, copy.length, charset);
        }
        return result;
    }

    protected final void checkNewCapacity(int newCapacity) {
        if (newCapacity < 0 || newCapacity > this.maxCapacity()) {
            throw new IllegalArgumentException("newCapacity: " + newCapacity + " (expected: 0-" + this.maxCapacity() + ")");
        }
    }

    protected static boolean isOutOfBounds(int index, int length, int capacity) {
        return (index | length | index + length | capacity - (index + length)) < 0;
    }

    protected final void checkIndex(int index, int fieldLength) {
        if (ProtonAbstractBuffer.isOutOfBounds(index, fieldLength, this.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
        }
    }

    protected final void checkSourceIndex(int index, int length, int srcIndex, int srcCapacity) {
        this.checkIndex(index, length);
        if (ProtonAbstractBuffer.isOutOfBounds(srcIndex, length, srcCapacity)) {
            throw new IndexOutOfBoundsException(String.format("srcIndex: %d, length: %d (expected: range(0, %d))", srcIndex, length, srcCapacity));
        }
    }

    protected final void checkDestinationIndex(int index, int length, int dstIndex, int dstCapacity) {
        this.checkIndex(index, length);
        if (ProtonAbstractBuffer.isOutOfBounds(dstIndex, length, dstCapacity)) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length, dstCapacity));
        }
    }

    protected final void checkReadableBytes(int minimumReadableBytes) {
        if (minimumReadableBytes < 0) {
            throw new IllegalArgumentException("minimumReadableBytes: " + minimumReadableBytes + " (expected: >= 0)");
        }
        this.internalCheckReadableBytes(minimumReadableBytes);
    }

    protected final void adjustIndexMarks(int decrement) {
        int markedReaderIndex = this.markedReadIndex;
        if (markedReaderIndex <= decrement) {
            this.markedReadIndex = 0;
            int markedWriterIndex = this.markedWriteIndex;
            this.markedWriteIndex = markedWriterIndex <= decrement ? 0 : markedWriterIndex - decrement;
        } else {
            this.markedReadIndex = markedReaderIndex - decrement;
            this.markedWriteIndex -= decrement;
        }
    }

    private void internalCheckReadableBytes(int minimumReadableBytes) {
        if (this.readIndex > this.writeIndex - minimumReadableBytes) {
            throw new IndexOutOfBoundsException(String.format("readIndex(%d) + length(%d) exceeds writeIndex(%d): %s", this.readIndex, minimumReadableBytes, this.writeIndex, this));
        }
    }

    private void internalEnsureWritable(int minWritableBytes) {
        if (minWritableBytes <= this.getWritableBytes()) {
            return;
        }
        if (minWritableBytes > this.maxCapacity() - this.writeIndex) {
            throw new IndexOutOfBoundsException(String.format("writeIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", this.writeIndex, minWritableBytes, this.maxCapacity(), this));
        }
        int newCapacity = this.calculateNewCapacity(this.writeIndex + minWritableBytes, this.maxCapacity());
        this.capacity(newCapacity);
    }

    private int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
        int newCapacity;
        if (minNewCapacity < 0) {
            throw new IllegalArgumentException("minNewCapacity: " + minNewCapacity + " (expected: 0+)");
        }
        if (minNewCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("minNewCapacity: %d (expected: not greater than maxCapacity(%d)", minNewCapacity, maxCapacity));
        }
        for (newCapacity = 64; newCapacity < minNewCapacity; newCapacity <<= 1) {
        }
        return Math.min(newCapacity, maxCapacity);
    }
}

