/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.transport;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.protonj2.client.TransportOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpollSupport {
    private static final Logger LOG = LoggerFactory.getLogger(EpollSupport.class);
    public static final String NAME = "EPOLL";

    public static boolean isAvailable(TransportOptions transportOptions) {
        try {
            return transportOptions.allowNativeIO() && Epoll.isAvailable();
        }
        catch (NoClassDefFoundError ncdfe) {
            LOG.debug("Unable to check for Epoll support due to missing class definition", (Throwable)ncdfe);
            return false;
        }
    }

    public static EventLoopGroup createGroup(int nThreads, ThreadFactory ioThreadFactory) {
        return new EpollEventLoopGroup(nThreads, ioThreadFactory);
    }

    public static Class<? extends Channel> getChannelClass() {
        return EpollSocketChannel.class;
    }
}

