/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.protonj2.client.DeliveryState;
import org.apache.qpid.protonj2.client.exceptions.ClientDeliveryStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientDeliveryState;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientLinkType;
import org.apache.qpid.protonj2.client.impl.ClientSenderLinkType;
import org.apache.qpid.protonj2.engine.OutgoingDelivery;

public abstract class ClientTrackable<SenderType extends ClientSenderLinkType<?>, TrackerType> {
    protected final SenderType sender;
    protected final OutgoingDelivery delivery;
    private final ClientFuture<TrackerType> remoteSettlementFuture;
    private volatile boolean remotelySettled;
    private volatile DeliveryState remoteDeliveryState;

    ClientTrackable(SenderType sender, OutgoingDelivery delivery) {
        this.sender = sender;
        this.delivery = delivery;
        this.delivery.deliveryStateUpdatedHandler(this::processDeliveryUpdated);
        this.remoteSettlementFuture = ((ClientLinkType)sender).session().getFutureFactory().createFuture();
    }

    protected abstract TrackerType self();

    OutgoingDelivery delivery() {
        return this.delivery;
    }

    public synchronized DeliveryState state() {
        return ClientDeliveryState.fromProtonType(this.delivery.getState());
    }

    public DeliveryState remoteState() {
        return this.remoteDeliveryState;
    }

    public boolean remoteSettled() {
        return this.remotelySettled;
    }

    public TrackerType disposition(DeliveryState state, boolean settle) throws ClientException {
        try {
            ((ClientSenderLinkType)this.sender).disposition(this.delivery, ClientDeliveryState.asProtonType(state), settle);
        }
        finally {
            if (settle) {
                this.remoteSettlementFuture.complete(this.self());
            }
        }
        return this.self();
    }

    public TrackerType settle() throws ClientException {
        try {
            ((ClientSenderLinkType)this.sender).disposition(this.delivery, null, true);
        }
        finally {
            this.remoteSettlementFuture.complete(this.self());
        }
        return this.self();
    }

    public synchronized boolean settled() {
        return this.delivery.isSettled();
    }

    public ClientFuture<TrackerType> settlementFuture() {
        if (this.delivery.isSettled()) {
            this.remoteSettlementFuture.complete(this.self());
        }
        return this.remoteSettlementFuture;
    }

    public TrackerType awaitSettlement() throws ClientException {
        try {
            if (this.settled()) {
                return this.self();
            }
            return this.settlementFuture().get();
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ClientException("Wait for settlement was interrupted", e);
        }
    }

    public TrackerType awaitSettlement(long timeout, TimeUnit unit) throws ClientException {
        try {
            if (this.settled()) {
                return this.self();
            }
            return this.settlementFuture().get(timeout, unit);
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ClientException("Wait for settlement was interrupted", ie);
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (TimeoutException te) {
            throw new ClientOperationTimedOutException("Timed out waiting for remote settlement", te);
        }
    }

    public TrackerType awaitAccepted() throws ClientException {
        try {
            if (this.settled() && !this.remoteSettled()) {
                return this.self();
            }
            this.settlementFuture().get();
            if (this.remoteState() != null && this.remoteState().isAccepted()) {
                return this.self();
            }
            throw new ClientDeliveryStateException("Remote did not accept the sent message", this.remoteState());
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ClientException("Wait for Accepted outcome was interrupted", ie);
        }
    }

    public TrackerType awaitAccepted(long timeout, TimeUnit unit) throws ClientException {
        try {
            if (this.settled() && !this.remoteSettled()) {
                return this.self();
            }
            this.settlementFuture().get(timeout, unit);
            if (this.remoteState() != null && this.remoteState().isAccepted()) {
                return this.self();
            }
            throw new ClientDeliveryStateException("Remote did not accept the sent message", this.remoteState());
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ClientException("Wait for Accepted outcome was interrupted", ie);
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (TimeoutException te) {
            throw new ClientOperationTimedOutException("Timed out waiting for remote Accepted outcome", te);
        }
    }

    private void processDeliveryUpdated(OutgoingDelivery delivery) {
        this.remotelySettled = delivery.isRemotelySettled();
        this.remoteDeliveryState = ClientDeliveryState.fromProtonType(delivery.getRemoteState());
        if (delivery.isRemotelySettled()) {
            this.remoteSettlementFuture.complete(this.self());
        }
        if (((ClientSenderLinkType)this.sender).options.autoSettle() && delivery.isRemotelySettled()) {
            delivery.settle();
        }
    }
}

