/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.protonj2.client.Link;
import org.apache.qpid.protonj2.client.LinkOptions;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientLinkType;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.engine.Receiver;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientReceiverLinkType<ReceiverType extends Link<ReceiverType>>
extends ClientLinkType<ReceiverType, Receiver> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ClientFuture<ReceiverType> drainingFuture;
    protected ScheduledFuture<?> drainingTimeout;
    protected Receiver protonReceiver;

    protected ClientReceiverLinkType(ClientSession session, String linkId, LinkOptions<?> options, Receiver protonReceiver) {
        super(session, linkId, options);
        this.protonReceiver = protonReceiver;
        this.protonReceiver.setLinkedResource(this.self());
    }

    @Override
    protected Receiver protonLink() {
        return this.protonReceiver;
    }

    void disposition(IncomingDelivery delivery, DeliveryState state, boolean settle) throws ClientException {
        this.checkClosedOrFailed();
        this.executor.execute(() -> {
            this.session.getTransactionContext().disposition(delivery, state, settle);
            this.replenishCreditIfNeeded();
        });
    }

    protected abstract void replenishCreditIfNeeded();

    protected abstract void handleDeliveryRead(IncomingDelivery var1);

    protected void handleDeliveryAborted(IncomingDelivery delivery) {
        LOG.trace("Delivery data was aborted: {}", (Object)delivery);
        delivery.settle();
        this.replenishCreditIfNeeded();
    }

    protected void handleDeliveryStateRemotelyUpdated(IncomingDelivery delivery) {
        LOG.trace("Delivery remote state was updated: {}", (Object)delivery);
    }

    protected void handleReceiverCreditUpdated(Receiver receiver) {
        LOG.trace("Receiver credit update by remote: {}", (Object)receiver);
        if (this.drainingFuture != null && receiver.getCredit() == 0) {
            this.drainingFuture.complete(this.self());
            if (this.drainingTimeout != null) {
                this.drainingTimeout.cancel(false);
                this.drainingTimeout = null;
            }
        }
    }

    @Override
    protected void linkSpecificLocalOpenHandler() {
        this.protonLink().deliveryStateUpdatedHandler(this::handleDeliveryStateRemotelyUpdated).deliveryReadHandler(this::handleDeliveryRead).deliveryAbortedHandler(this::handleDeliveryAborted).creditStateUpdateHandler(this::handleReceiverCreditUpdated);
    }

    @Override
    protected void linkSpecificRemoteOpenHandler() {
        this.replenishCreditIfNeeded();
    }

    @Override
    protected void linkSpecificLocalCloseHandler() {
    }

    @Override
    protected void linkSpecificRemoteCloseHandler() {
    }

    @Override
    protected void linkSpecificCleanupHandler(ClientException failureCause) {
        if (this.drainingTimeout != null) {
            this.drainingFuture.failed(failureCause != null ? failureCause : new ClientResourceRemotelyClosedException("The Receiver has been closed"));
            this.drainingTimeout.cancel(false);
            this.drainingTimeout = null;
        }
    }
}

