/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.futures;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientSynchronization;

public class ProgressiveClientFuture<V>
extends ClientFuture<V> {
    private static final int SPIN_COUNT = 10;
    private static final int YIELD_COUNT = 100;
    private static final int TINY_PARK_COUNT = 1000;
    private static final int TINY_PARK_NANOS = 1;
    private static final int SMALL_PARK_COUNT = 101000;
    private static final int SMALL_PARK_NANOS = 10000;

    public ProgressiveClientFuture() {
        this(null);
    }

    public ProgressiveClientFuture(ClientSynchronization<V> synchronization) {
        super(synchronization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long amount, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isNotComplete() && amount > 0L) {
            long timeout = unit.toNanos(amount);
            long maxParkNanos = timeout / 8L;
            maxParkNanos = maxParkNanos > 0L ? maxParkNanos : timeout;
            long tinyParkNanos = Math.min(maxParkNanos, 1L);
            long smallParkNanos = Math.min(maxParkNanos, 10000L);
            long startTime = System.nanoTime();
            int idleCount = 0;
            while (this.isNotComplete()) {
                long elapsed = System.nanoTime() - startTime;
                long diff = elapsed - timeout;
                if (diff >= 0L) {
                    throw new TimeoutException("Timed out waiting for completion");
                }
                if (idleCount < 10) {
                    ++idleCount;
                    continue;
                }
                if (idleCount < 100) {
                    Thread.yield();
                    ++idleCount;
                    continue;
                }
                if (idleCount < 1000) {
                    LockSupport.parkNanos(tinyParkNanos);
                    ++idleCount;
                    continue;
                }
                if (idleCount < 101000) {
                    LockSupport.parkNanos(smallParkNanos);
                    ++idleCount;
                    continue;
                }
                ProgressiveClientFuture progressiveClientFuture = this;
                synchronized (progressiveClientFuture) {
                    if (this.isComplete()) {
                        break;
                    }
                    if (this.getState() < 1) {
                        ++this.waiting;
                        try {
                            this.wait(-diff / 1000000L, (int)(-diff % 1000000L));
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            throw e;
                        }
                        finally {
                            --this.waiting;
                        }
                    }
                }
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (this.isNotComplete()) {
            int idleCount = 0;
            while (this.isNotComplete()) {
                if (idleCount < 10) {
                    ++idleCount;
                    continue;
                }
                if (idleCount < 100) {
                    Thread.yield();
                    ++idleCount;
                    continue;
                }
                if (idleCount < 1000) {
                    LockSupport.parkNanos(1L);
                    ++idleCount;
                    continue;
                }
                if (idleCount < 101000) {
                    LockSupport.parkNanos(10000L);
                    ++idleCount;
                    continue;
                }
                ProgressiveClientFuture progressiveClientFuture = this;
                synchronized (progressiveClientFuture) {
                    if (this.isComplete()) {
                        break;
                    }
                    if (this.getState() < 1) {
                        ++this.waiting;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            throw e;
                        }
                        finally {
                            --this.waiting;
                        }
                    }
                }
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.getResult();
    }
}

