/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.client.ConnectionOptions;
import org.apache.qpid.protonj2.client.NextReceiverPolicy;

public class SessionOptions {
    public static final int DEFAULT_SESSION_INCOMING_CAPACITY = 0x6400000;
    public static final int DEFAULT_SESSION_OUTGOING_CAPACITY = 0x6400000;
    private long sendTimeout = -1L;
    private long drainTimeout = 60000L;
    private long requestTimeout = -1L;
    private long openTimeout = 15000L;
    private long closeTimeout = 60000L;
    private int incomingCapacity = 0x6400000;
    private int outgoingCapacity = 0x6400000;
    private String[] offeredCapabilities;
    private String[] desiredCapabilities;
    private Map<String, Object> properties;
    private NextReceiverPolicy nextReceiverPolicy = ConnectionOptions.DEFAULT_NEXT_RECEIVER_POLICY;

    public SessionOptions() {
    }

    public SessionOptions(SessionOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public SessionOptions clone() {
        return this.copyInto(new SessionOptions());
    }

    protected SessionOptions copyInto(SessionOptions other) {
        other.closeTimeout(this.closeTimeout);
        other.openTimeout(this.openTimeout);
        other.sendTimeout(this.sendTimeout);
        other.drainTimeout(this.drainTimeout);
        other.requestTimeout(this.requestTimeout);
        other.incomingCapacity(this.incomingCapacity);
        other.outgoingCapacity(this.outgoingCapacity);
        other.defaultNextReceiverPolicy(this.nextReceiverPolicy);
        if (this.offeredCapabilities != null) {
            other.offeredCapabilities(Arrays.copyOf(this.offeredCapabilities, this.offeredCapabilities.length));
        }
        if (this.desiredCapabilities != null) {
            other.desiredCapabilities(Arrays.copyOf(this.desiredCapabilities, this.desiredCapabilities.length));
        }
        if (this.properties != null) {
            other.properties(new HashMap<String, Object>(this.properties));
        }
        return this;
    }

    public long closeTimeout() {
        return this.closeTimeout;
    }

    public SessionOptions closeTimeout(long closeTimeout) {
        return this.closeTimeout(closeTimeout, TimeUnit.MILLISECONDS);
    }

    public SessionOptions closeTimeout(long timeout, TimeUnit units) {
        this.closeTimeout = units.toMillis(timeout);
        return this;
    }

    public long openTimeout() {
        return this.openTimeout;
    }

    public SessionOptions openTimeout(long openTimeout) {
        return this.openTimeout(openTimeout, TimeUnit.MILLISECONDS);
    }

    public SessionOptions openTimeout(long timeout, TimeUnit units) {
        this.openTimeout = units.toMillis(timeout);
        return this;
    }

    public long sendTimeout() {
        return this.sendTimeout;
    }

    public SessionOptions sendTimeout(long sendTimeout) {
        return this.sendTimeout(sendTimeout, TimeUnit.MILLISECONDS);
    }

    public SessionOptions sendTimeout(long timeout, TimeUnit units) {
        this.sendTimeout = units.toMillis(timeout);
        return this;
    }

    public long requestTimeout() {
        return this.requestTimeout;
    }

    public SessionOptions requestTimeout(long requestTimeout) {
        return this.requestTimeout(requestTimeout, TimeUnit.MILLISECONDS);
    }

    public SessionOptions requestTimeout(long timeout, TimeUnit units) {
        this.requestTimeout = units.toMillis(timeout);
        return this;
    }

    public long drainTimeout() {
        return this.drainTimeout;
    }

    public SessionOptions drainTimeout(long drainTimeout) {
        return this.drainTimeout(drainTimeout, TimeUnit.MILLISECONDS);
    }

    public SessionOptions drainTimeout(long timeout, TimeUnit units) {
        this.drainTimeout = units.toMillis(timeout);
        return this;
    }

    public String[] offeredCapabilities() {
        return this.offeredCapabilities;
    }

    public SessionOptions offeredCapabilities(String ... offeredCapabilities) {
        this.offeredCapabilities = offeredCapabilities;
        return this;
    }

    public String[] desiredCapabilities() {
        return this.desiredCapabilities;
    }

    public SessionOptions desiredCapabilities(String ... desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public SessionOptions properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public int incomingCapacity() {
        return this.incomingCapacity;
    }

    public SessionOptions incomingCapacity(int incomingCapacity) {
        this.incomingCapacity = incomingCapacity;
        return this;
    }

    public int outgoingCapacity() {
        return this.outgoingCapacity;
    }

    public SessionOptions outgoingCapacity(int outgoingCapacity) {
        this.outgoingCapacity = outgoingCapacity;
        return this;
    }

    public NextReceiverPolicy defaultNextReceiverPolicy() {
        return this.nextReceiverPolicy;
    }

    public SessionOptions defaultNextReceiverPolicy(NextReceiverPolicy policy) {
        this.nextReceiverPolicy = policy;
        return this;
    }
}

