/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.protonj2.client.ReconnectLocation;

public class ReconnectOptions {
    public static final boolean DEFAULT_RECONNECT_ENABLED = false;
    public static final int INFINITE = -1;
    public static final int DEFAULT_WARN_AFTER_RECONNECT_ATTEMPTS = 10;
    public static final int DEFAULT_RECONNECT_DELAY = 10;
    public static final int DEFAULT_MAX_RECONNECT_DELAY = 30000;
    public static final boolean DEFAULT_USE_RECONNECT_BACKOFF = true;
    public static final double DEFAULT_RECONNECT_BACKOFF_MULTIPLIER = 2.0;
    private final List<ReconnectLocation> reconnectHosts = new ArrayList<ReconnectLocation>();
    private boolean reconnectEnabled = false;
    private int warnAfterReconnectAttempts = 10;
    private int maxInitialConnectionAttempts = -1;
    private int maxReconnectAttempts = -1;
    private int reconnectDelay = 10;
    private int maxReconnectDelay = 10;
    private boolean useReconnectBackOff = true;
    private double reconnectBackOffMultiplier = 2.0;

    public ReconnectOptions() {
    }

    public ReconnectOptions(ReconnectOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    protected ReconnectOptions copyInto(ReconnectOptions other) {
        other.reconnectEnabled(this.reconnectEnabled());
        other.warnAfterReconnectAttempts(this.warnAfterReconnectAttempts);
        other.maxInitialConnectionAttempts(this.maxInitialConnectionAttempts);
        other.maxReconnectAttempts(this.maxReconnectAttempts);
        other.reconnectDelay(this.reconnectDelay);
        other.maxReconnectDelay(this.maxReconnectDelay);
        other.useReconnectBackOff(this.useReconnectBackOff);
        other.reconnectBackOffMultiplier(this.reconnectBackOffMultiplier);
        other.reconnectHosts.addAll(this.reconnectHosts);
        return this;
    }

    public boolean reconnectEnabled() {
        return this.reconnectEnabled;
    }

    public ReconnectOptions reconnectEnabled(boolean reconnectEnabled) {
        this.reconnectEnabled = reconnectEnabled;
        return this;
    }

    public ReconnectOptions addReconnectLocation(String host, int port) {
        this.reconnectHosts.add(new ReconnectLocation(host, port));
        return this;
    }

    public List<ReconnectLocation> reconnectLocations() {
        return Collections.unmodifiableList(this.reconnectHosts);
    }

    public int warnAfterReconnectAttempts() {
        return this.warnAfterReconnectAttempts;
    }

    public ReconnectOptions warnAfterReconnectAttempts(int warnAfterReconnectAttempts) {
        this.warnAfterReconnectAttempts = warnAfterReconnectAttempts;
        return this;
    }

    public int maxInitialConnectionAttempts() {
        return this.maxInitialConnectionAttempts;
    }

    public ReconnectOptions maxInitialConnectionAttempts(int maxInitialConnectionAttempts) {
        this.maxInitialConnectionAttempts = maxInitialConnectionAttempts;
        return this;
    }

    public int maxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public ReconnectOptions maxReconnectAttempts(int maxReconnectionAttempts) {
        this.maxReconnectAttempts = maxReconnectionAttempts;
        return this;
    }

    public int reconnectDelay() {
        return this.reconnectDelay;
    }

    public ReconnectOptions reconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
        return this;
    }

    public int maxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public ReconnectOptions maxReconnectDelay(int maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
        return this;
    }

    public boolean useReconnectBackOff() {
        return this.useReconnectBackOff;
    }

    public ReconnectOptions useReconnectBackOff(boolean useReconnectBackOff) {
        this.useReconnectBackOff = useReconnectBackOff;
        return this;
    }

    public double reconnectBackOffMultiplier() {
        return this.reconnectBackOffMultiplier;
    }

    public ReconnectOptions reconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
        this.reconnectBackOffMultiplier = reconnectBackOffMultiplier;
        return this;
    }
}

