/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.qpid.protonj2.client.impl.ClientDelivery;
import org.apache.qpid.protonj2.client.util.DeliveryQueue;

public final class FifoDeliveryQueue
implements DeliveryQueue {
    private static final AtomicIntegerFieldUpdater<FifoDeliveryQueue> STATE_FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(FifoDeliveryQueue.class, "state");
    private static final int CLOSED = 0;
    private static final int STOPPED = 1;
    private static final int RUNNING = 2;
    private volatile int state = 1;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Deque<ClientDelivery> queue;

    public FifoDeliveryQueue(int queueDepth) {
        this.queue = new ArrayDeque<ClientDelivery>(Math.max(1, queueDepth));
    }

    @Override
    public void enqueueFirst(ClientDelivery envelope) {
        this.lock.lock();
        try {
            this.queue.addFirst(envelope);
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void enqueue(ClientDelivery envelope) {
        this.lock.lock();
        try {
            this.queue.addLast(envelope);
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientDelivery dequeue(long timeout) throws InterruptedException {
        this.lock.lock();
        try {
            while (timeout != 0L && this.isRunning() && this.queue.isEmpty()) {
                if (timeout == -1L) {
                    this.condition.await();
                    continue;
                }
                long start = System.currentTimeMillis();
                this.condition.await(timeout, TimeUnit.MILLISECONDS);
                timeout = Math.max(timeout + start - System.currentTimeMillis(), 0L);
            }
            if (!this.isRunning()) {
                ClientDelivery clientDelivery = null;
                return clientDelivery;
            }
            ClientDelivery clientDelivery = this.queue.pollFirst();
            return clientDelivery;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ClientDelivery dequeueNoWait() {
        this.lock.lock();
        try {
            if (!this.isRunning()) {
                ClientDelivery clientDelivery = null;
                return clientDelivery;
            }
            ClientDelivery clientDelivery = this.queue.pollFirst();
            return clientDelivery;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void start() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 1, 2)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void stop() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 2, 1)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() {
        if (STATE_FIELD_UPDATER.getAndSet(this, 0) > 0) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.state == 2;
    }

    @Override
    public boolean isClosed() {
        return this.state == 0;
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.queue.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.queue.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = this.queue.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

