/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.transport;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.qpid.protonj2.client.SslOptions;
import org.apache.qpid.protonj2.client.transport.X509AliasKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SslSupport.class);

    public static boolean isOpenSSLPossible(SslOptions options) {
        boolean result = false;
        if (options.allowNativeSSL()) {
            if (!OpenSsl.isAvailable()) {
                LOG.debug("OpenSSL could not be enabled because a suitable implementation could not be found.", OpenSsl.unavailabilityCause());
            } else if (options.sslContextOverride() != null) {
                LOG.debug("OpenSSL could not be enabled due to user SSLContext being supplied.");
            } else if (!OpenSsl.supportsKeyManagerFactory()) {
                LOG.debug("OpenSSL could not be enabled because the version provided does not allow a KeyManagerFactory to be used.");
            } else if (options.keyAlias() != null) {
                LOG.debug("OpenSSL could not be enabled because a keyAlias is set and that feature is not supported for OpenSSL.");
            } else {
                LOG.debug("OpenSSL Enabled: Version {} of OpenSSL will be used", (Object)OpenSsl.versionString());
                result = true;
            }
        }
        return result;
    }

    public static SslHandler createSslHandler(ByteBufAllocator allocator, String host, int port, SslOptions options) throws Exception {
        SSLEngine sslEngine;
        if (SslSupport.isOpenSSLPossible(options)) {
            SslContext sslContext = SslSupport.createOpenSslContext(options);
            sslEngine = SslSupport.createOpenSslEngine(allocator, host, port, sslContext, options);
        } else {
            SSLContext sslContext = options.sslContextOverride();
            if (sslContext == null) {
                sslContext = SslSupport.createJdkSslContext(options);
            }
            sslEngine = SslSupport.createJdkSslEngine(host, port, sslContext, options);
        }
        return new SslHandler(sslEngine);
    }

    public static SSLContext createJdkSslContext(SslOptions options) throws Exception {
        try {
            String contextProtocol = options.contextProtocol();
            LOG.trace("Getting SSLContext instance using protocol: {}", (Object)contextProtocol);
            SSLContext context = SSLContext.getInstance(contextProtocol);
            KeyManager[] keyMgrs = SslSupport.loadKeyManagers(options);
            TrustManager[] trustManagers = SslSupport.loadTrustManagers(options);
            context.init(keyMgrs, trustManagers, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            LOG.error("Failed to create SSLContext: {}", (Object)e, (Object)e);
            throw e;
        }
    }

    public static SSLEngine createJdkSslEngine(String host, int port, SSLContext context, SslOptions options) throws Exception {
        SSLEngine engine = null;
        engine = host == null || host.isEmpty() ? context.createSSLEngine() : context.createSSLEngine(host, port);
        engine.setEnabledProtocols(SslSupport.buildEnabledProtocols(engine, options));
        engine.setEnabledCipherSuites(SslSupport.buildEnabledCipherSuites(engine, options));
        engine.setUseClientMode(true);
        if (options.verifyHost()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return engine;
    }

    public static SslContext createOpenSslContext(SslOptions options) throws Exception {
        try {
            String contextProtocol = options.contextProtocol();
            LOG.trace("Getting SslContext instance using protocol: {}", (Object)contextProtocol);
            KeyManagerFactory keyManagerFactory = SslSupport.loadKeyManagerFactory(options, SslProvider.OPENSSL);
            TrustManagerFactory trustManagerFactory = SslSupport.loadTrustManagerFactory(options);
            SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL);
            if (options.contextProtocol().equals("TLS")) {
                builder.protocols(new String[]{"TLSv1.2"});
            } else {
                builder.protocols(new String[]{options.contextProtocol()});
            }
            builder.keyManager(keyManagerFactory);
            builder.trustManager(trustManagerFactory);
            return builder.build();
        }
        catch (Exception e) {
            LOG.error("Failed to create SslContext: {}", (Object)e, (Object)e);
            throw e;
        }
    }

    public static SSLEngine createOpenSslEngine(ByteBufAllocator allocator, String host, int port, SslContext context, SslOptions options) throws Exception {
        SSLEngine engine = null;
        if (allocator == null) {
            throw new IllegalArgumentException("OpenSSL engine requires a valid ByteBufAllocator to operate");
        }
        engine = host == null || host.isEmpty() ? context.newEngine(allocator) : context.newEngine(allocator, host, port);
        engine.setEnabledProtocols(SslSupport.buildEnabledProtocols(engine, options));
        engine.setEnabledCipherSuites(SslSupport.buildEnabledCipherSuites(engine, options));
        engine.setUseClientMode(true);
        if (options.verifyHost()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return engine;
    }

    private static String[] buildEnabledProtocols(SSLEngine engine, SslOptions options) {
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        if (options.enabledProtocols() != null) {
            List<String> configuredProtocols = Arrays.asList(options.enabledProtocols());
            LOG.trace("Configured protocols from transport options: {}", configuredProtocols);
            enabledProtocols.addAll(configuredProtocols);
        } else {
            List<String> engineProtocols = Arrays.asList(engine.getEnabledProtocols());
            LOG.trace("Default protocols from the SSLEngine: {}", engineProtocols);
            enabledProtocols.addAll(engineProtocols);
        }
        String[] disabledProtocols = options.disabledProtocols();
        if (disabledProtocols != null) {
            List<String> disabled = Arrays.asList(disabledProtocols);
            LOG.trace("Disabled protocols: {}", disabled);
            enabledProtocols.removeAll(disabled);
        }
        LOG.trace("Enabled protocols: {}", enabledProtocols);
        return enabledProtocols.toArray(new String[0]);
    }

    private static String[] buildEnabledCipherSuites(SSLEngine engine, SslOptions options) {
        ArrayList<String> enabledCipherSuites = new ArrayList<String>();
        if (options.enabledCipherSuites() != null) {
            List<String> configuredCipherSuites = Arrays.asList(options.enabledCipherSuites());
            LOG.trace("Configured cipher suites from transport options: {}", configuredCipherSuites);
            enabledCipherSuites.addAll(configuredCipherSuites);
        } else {
            List<String> engineCipherSuites = Arrays.asList(engine.getEnabledCipherSuites());
            LOG.trace("Default cipher suites from the SSLEngine: {}", engineCipherSuites);
            enabledCipherSuites.addAll(engineCipherSuites);
        }
        String[] disabledCipherSuites = options.disabledCipherSuites();
        if (disabledCipherSuites != null) {
            List<String> disabled = Arrays.asList(disabledCipherSuites);
            LOG.trace("Disabled cipher suites: {}", disabled);
            enabledCipherSuites.removeAll(disabled);
        }
        LOG.trace("Enabled cipher suites: {}", enabledCipherSuites);
        return enabledCipherSuites.toArray(new String[0]);
    }

    private static TrustManager[] loadTrustManagers(SslOptions options) throws Exception {
        TrustManagerFactory factory = SslSupport.loadTrustManagerFactory(options);
        if (factory != null) {
            return factory.getTrustManagers();
        }
        return null;
    }

    private static TrustManagerFactory loadTrustManagerFactory(SslOptions options) throws Exception {
        if (options.trustAll()) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        if (options.trustStoreLocation() == null) {
            return null;
        }
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.trustStoreLocation();
        String storePassword = options.trustStorePassword();
        String storeType = options.trustStoreType();
        LOG.trace("Attempt to load TrustStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore trustStore = SslSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(trustStore);
        return fact;
    }

    private static KeyManager[] loadKeyManagers(SslOptions options) throws Exception {
        if (options.keyStoreLocation() == null) {
            return null;
        }
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.keyStoreLocation();
        String storePassword = options.keyStorePassword();
        String storeType = options.keyStoreType();
        String alias = options.keyAlias();
        LOG.trace("Attempt to load KeyStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore keyStore = SslSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(keyStore, storePassword != null ? storePassword.toCharArray() : null);
        if (alias == null) {
            return fact.getKeyManagers();
        }
        SslSupport.validateAlias(keyStore, alias);
        return SslSupport.wrapKeyManagers(alias, fact.getKeyManagers());
    }

    private static KeyManagerFactory loadKeyManagerFactory(SslOptions options, SslProvider provider) throws Exception {
        if (options.keyStoreLocation() == null) {
            return null;
        }
        KeyManagerFactory factory = provider.equals((Object)SslProvider.JDK) ? KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()) : new OpenSslX509KeyManagerFactory();
        String storeLocation = options.keyStoreLocation();
        String storePassword = options.keyStorePassword();
        String storeType = options.keyStoreType();
        LOG.trace("Attempt to load KeyStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore keyStore = SslSupport.loadStore(storeLocation, storePassword, storeType);
        factory.init(keyStore, storePassword != null ? storePassword.toCharArray() : null);
        return factory;
    }

    private static KeyManager[] wrapKeyManagers(String alias, KeyManager[] origKeyManagers) {
        KeyManager[] keyManagers = new KeyManager[origKeyManagers.length];
        for (int i = 0; i < origKeyManagers.length; ++i) {
            KeyManager km = origKeyManagers[i];
            if (km instanceof X509ExtendedKeyManager) {
                km = new X509AliasKeyManager(alias, (X509ExtendedKeyManager)km);
            }
            keyManagers[i] = km;
        }
        return keyManagers;
    }

    private static void validateAlias(KeyStore store, String alias) throws IllegalArgumentException, KeyStoreException {
        if (!store.containsAlias(alias)) {
            throw new IllegalArgumentException("The alias '" + alias + "' doesn't exist in the key store");
        }
        if (!store.isKeyEntry(alias)) {
            throw new IllegalArgumentException("The alias '" + alias + "' in the keystore doesn't represent a key entry");
        }
    }

    private static KeyStore loadStore(String storePath, String password, String storeType) throws Exception {
        KeyStore store = KeyStore.getInstance(storeType);
        try (FileInputStream in = new FileInputStream(new File(storePath));){
            store.load(in, password != null ? password.toCharArray() : null);
        }
        return store;
    }
}

