/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.client.AdvancedMessage;
import org.apache.qpid.protonj2.client.ErrorCondition;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.Sender;
import org.apache.qpid.protonj2.client.SenderOptions;
import org.apache.qpid.protonj2.client.Source;
import org.apache.qpid.protonj2.client.Target;
import org.apache.qpid.protonj2.client.Tracker;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientUnsupportedOperationException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientSynchronization;
import org.apache.qpid.protonj2.client.impl.ClientConnection;
import org.apache.qpid.protonj2.client.impl.ClientConversionSupport;
import org.apache.qpid.protonj2.client.impl.ClientErrorCondition;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientInstance;
import org.apache.qpid.protonj2.client.impl.ClientMessageSupport;
import org.apache.qpid.protonj2.client.impl.ClientNoOpTracker;
import org.apache.qpid.protonj2.client.impl.ClientOutgoingEnvelope;
import org.apache.qpid.protonj2.client.impl.ClientRemoteSource;
import org.apache.qpid.protonj2.client.impl.ClientRemoteTarget;
import org.apache.qpid.protonj2.client.impl.ClientSenderBuilder;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.impl.ClientStreamSession;
import org.apache.qpid.protonj2.client.impl.ClientTracker;
import org.apache.qpid.protonj2.engine.Connection;
import org.apache.qpid.protonj2.engine.Engine;
import org.apache.qpid.protonj2.engine.LinkState;
import org.apache.qpid.protonj2.engine.OutgoingDelivery;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.apache.qpid.protonj2.types.transport.SenderSettleMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientSender
implements Sender {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSender.class);
    protected static final AtomicIntegerFieldUpdater<ClientSender> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClientSender.class, "closed");
    protected final ClientFuture<Sender> openFuture;
    protected final ClientFuture<Sender> closeFuture;
    protected volatile int closed;
    protected ClientException failureCause;
    protected final Deque<ClientOutgoingEnvelope> blocked = new ArrayDeque<ClientOutgoingEnvelope>();
    protected final SenderOptions options;
    protected final ClientSession session;
    protected final ScheduledExecutorService executor;
    protected final String senderId;
    protected final boolean sendsSettled;
    protected org.apache.qpid.protonj2.engine.Sender protonSender;
    protected Consumer<Sender> senderRemotelyClosedHandler;
    protected volatile Source remoteSource;
    protected volatile Target remoteTarget;

    ClientSender(ClientSession session, SenderOptions options, String senderId, org.apache.qpid.protonj2.engine.Sender protonSender) {
        this.options = new SenderOptions(options);
        this.session = session;
        this.senderId = senderId;
        this.executor = session.getScheduler();
        this.openFuture = session.getFutureFactory().createFuture();
        this.closeFuture = session.getFutureFactory().createFuture();
        this.protonSender = (org.apache.qpid.protonj2.engine.Sender)protonSender.setLinkedResource((Object)this);
        this.sendsSettled = protonSender.getSenderSettleMode() == SenderSettleMode.SETTLED;
    }

    @Override
    public String address() throws ClientException {
        org.apache.qpid.protonj2.types.messaging.Target target;
        if (this.isDynamic()) {
            this.waitForOpenToComplete();
            target = (org.apache.qpid.protonj2.types.messaging.Target)this.protonSender.getRemoteTarget();
        } else {
            target = (org.apache.qpid.protonj2.types.messaging.Target)this.protonSender.getTarget();
        }
        if (target != null) {
            return target.getAddress();
        }
        return null;
    }

    @Override
    public Source source() throws ClientException {
        this.waitForOpenToComplete();
        return this.remoteSource;
    }

    @Override
    public Target target() throws ClientException {
        this.waitForOpenToComplete();
        return this.remoteTarget;
    }

    @Override
    public ClientInstance client() {
        return this.session.client();
    }

    @Override
    public ClientConnection connection() {
        return this.session.connection();
    }

    @Override
    public ClientSession session() {
        return this.session;
    }

    public ClientFuture<Sender> openFuture() {
        return this.openFuture;
    }

    @Override
    public void close() {
        try {
            this.doCloseOrDetach(true, null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void close(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        try {
            this.doCloseOrDetach(true, error).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void detach() {
        try {
            this.doCloseOrDetach(false, null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void detach(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        try {
            this.doCloseOrDetach(false, error).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    public ClientFuture<Sender> closeAsync() {
        return this.doCloseOrDetach(true, null);
    }

    public ClientFuture<Sender> closeAsync(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        return this.doCloseOrDetach(true, error);
    }

    public ClientFuture<Sender> detachAsync() {
        return this.doCloseOrDetach(false, null);
    }

    public ClientFuture<Sender> detachAsync(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        return this.doCloseOrDetach(false, error);
    }

    private ClientFuture<Sender> doCloseOrDetach(boolean close, ErrorCondition error) {
        if (CLOSED_UPDATER.compareAndSet(this, 0, 1) && !this.closeFuture.isDone()) {
            this.executor.execute(() -> {
                if (this.protonSender.isLocallyOpen()) {
                    try {
                        this.protonSender.setCondition(ClientErrorCondition.asProtonErrorCondition(error));
                        if (close) {
                            this.protonSender.close();
                        } else {
                            this.protonSender.detach();
                        }
                    }
                    catch (Throwable ignore) {
                        this.closeFuture.complete(this);
                    }
                }
            });
        }
        return this.closeFuture;
    }

    @Override
    public Map<String, Object> properties() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringKeyedMap(this.protonSender.getRemoteProperties());
    }

    @Override
    public String[] offeredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonSender.getRemoteOfferedCapabilities());
    }

    @Override
    public String[] desiredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonSender.getRemoteDesiredCapabilities());
    }

    @Override
    public Tracker send(Message<?> message) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), null, true);
    }

    @Override
    public Tracker send(Message<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), deliveryAnnotations, true);
    }

    @Override
    public Tracker trySend(Message<?> message) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), null, false);
    }

    @Override
    public Tracker trySend(Message<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), deliveryAnnotations, false);
    }

    SenderOptions options() {
        return this.options;
    }

    Sender remotelyClosedHandler(Consumer<Sender> handler) {
        this.senderRemotelyClosedHandler = handler;
        return this;
    }

    void disposition(OutgoingDelivery delivery, DeliveryState state, boolean settled) throws ClientException {
        this.checkClosedOrFailed();
        this.executor.execute(() -> delivery.disposition(state, settled));
    }

    void abort(OutgoingDelivery delivery, ClientTracker tracker) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture<Tracker> request = this.session().getFutureFactory().createFuture(new ClientSynchronization<Tracker>(){

            @Override
            public void onPendingSuccess(Tracker result) {
                ClientSender.this.handleCreditStateUpdated(ClientSender.this.getProtonSender());
            }

            @Override
            public void onPendingFailure(Throwable cause) {
                ClientSender.this.handleCreditStateUpdated(ClientSender.this.getProtonSender());
            }
        });
        this.executor.execute(() -> {
            if (delivery.getTransferCount() == 0) {
                delivery.abort();
                request.complete(tracker);
            } else {
                ClientOutgoingEnvelope envelope = new ClientOutgoingEnvelope(this, delivery, delivery.getMessageFormat(), null, false, request).abort();
                try {
                    if (this.protonSender.isSendable() && (this.protonSender.current() == null || this.protonSender.current() == delivery)) {
                        envelope.sendPayload(delivery.getState(), delivery.isSettled());
                    } else if (this.protonSender.current() == delivery) {
                        this.addToHeadOfBlockedQueue(envelope);
                    } else {
                        this.addToTailOfBlockedQueue(envelope);
                    }
                }
                catch (Exception error) {
                    request.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
            }
        });
        this.session.request(this, request);
    }

    void complete(OutgoingDelivery delivery, ClientTracker tracker) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture<Tracker> request = this.session().getFutureFactory().createFuture(new ClientSynchronization<Tracker>(){

            @Override
            public void onPendingSuccess(Tracker result) {
                ClientSender.this.handleCreditStateUpdated(ClientSender.this.getProtonSender());
            }

            @Override
            public void onPendingFailure(Throwable cause) {
                ClientSender.this.handleCreditStateUpdated(ClientSender.this.getProtonSender());
            }
        });
        this.executor.execute(() -> {
            ClientOutgoingEnvelope envelope = new ClientOutgoingEnvelope(this, delivery, delivery.getMessageFormat(), null, true, request);
            try {
                if (this.protonSender.isSendable() && (this.protonSender.current() == null || this.protonSender.current() == delivery)) {
                    envelope.sendPayload(delivery.getState(), delivery.isSettled());
                } else if (this.protonSender.current() == delivery) {
                    this.addToHeadOfBlockedQueue(envelope);
                } else {
                    this.addToTailOfBlockedQueue(envelope);
                }
            }
            catch (Exception error) {
                request.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        this.session.request(this, request);
    }

    ClientSender open() {
        ((org.apache.qpid.protonj2.engine.Sender)((org.apache.qpid.protonj2.engine.Sender)((org.apache.qpid.protonj2.engine.Sender)((org.apache.qpid.protonj2.engine.Sender)((org.apache.qpid.protonj2.engine.Sender)((org.apache.qpid.protonj2.engine.Sender)((org.apache.qpid.protonj2.engine.Sender)((org.apache.qpid.protonj2.engine.Sender)((org.apache.qpid.protonj2.engine.Sender)this.protonSender.localOpenHandler(this::handleLocalOpen)).localCloseHandler(this::handleLocalCloseOrDetach)).localDetachHandler(this::handleLocalCloseOrDetach)).openHandler(this::handleRemoteOpen)).closeHandler(this::handleRemoteCloseOrDetach)).detachHandler(this::handleRemoteCloseOrDetach)).parentEndpointClosedHandler(this::handleParentEndpointClosed)).creditStateUpdateHandler(this::handleCreditStateUpdated)).engineShutdownHandler(this::handleEngineShutdown)).open();
        return this;
    }

    void setFailureCause(ClientException failureCause) {
        this.failureCause = failureCause;
    }

    org.apache.qpid.protonj2.engine.Sender getProtonSender() {
        return this.protonSender;
    }

    ClientException getFailureCause() {
        if (this.failureCause == null) {
            return this.session.getFailureCause();
        }
        return this.failureCause;
    }

    String getId() {
        return this.senderId;
    }

    boolean isClosed() {
        return this.closed > 0;
    }

    boolean isAnonymous() {
        return ((org.apache.qpid.protonj2.types.messaging.Target)this.protonSender.getTarget()).getAddress() == null;
    }

    boolean isDynamic() {
        return this.protonSender.getTarget() != null && ((org.apache.qpid.protonj2.types.messaging.Target)this.protonSender.getTarget()).isDynamic();
    }

    boolean isSendingSettled() {
        return this.sendsSettled;
    }

    private void handleLocalOpen(org.apache.qpid.protonj2.engine.Sender sender) {
        if (this.options.openTimeout() > 0L) {
            this.executor.schedule(() -> {
                if (!this.openFuture.isDone()) {
                    this.immediateLinkShutdown(new ClientOperationTimedOutException("Sender open timed out waiting for remote to respond"));
                }
            }, this.options.openTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    private void handleLocalCloseOrDetach(org.apache.qpid.protonj2.engine.Sender sender) {
        if (!sender.getEngine().isShutdown() && this.failureCause == null && sender.isRemotelyOpen()) {
            long timeout = this.options.closeTimeout();
            if (timeout > 0L) {
                this.session.scheduleRequestTimeout(this.closeFuture, timeout, () -> new ClientOperationTimedOutException("Sender close timed out waiting for remote to respond"));
            }
        } else {
            this.immediateLinkShutdown(this.failureCause);
        }
    }

    private void handleParentEndpointClosed(org.apache.qpid.protonj2.engine.Sender sender) {
        if (sender.getEngine().isRunning()) {
            ClientException failureCause = sender.getConnection().getRemoteCondition() != null ? ClientExceptionSupport.convertToConnectionClosedException(sender.getConnection().getRemoteCondition()) : (sender.getSession().getRemoteCondition() != null ? ClientExceptionSupport.convertToSessionClosedException(sender.getSession().getRemoteCondition()) : (sender.getEngine().failureCause() != null ? ClientExceptionSupport.convertToConnectionClosedException(sender.getEngine().failureCause()) : (!this.isClosed() ? new ClientResourceRemotelyClosedException("Remote closed without a specific error condition") : null)));
            this.immediateLinkShutdown(failureCause);
        }
    }

    private void handleRemoteOpen(org.apache.qpid.protonj2.engine.Sender sender) {
        if (sender.getRemoteTarget() != null) {
            this.remoteSource = new ClientRemoteSource(sender.getRemoteSource());
            if (sender.getRemoteTarget() != null) {
                this.remoteTarget = new ClientRemoteTarget((org.apache.qpid.protonj2.types.messaging.Target)sender.getRemoteTarget());
            }
            this.openFuture.complete(this);
            LOG.trace("Sender opened successfully");
        } else {
            LOG.debug("Sender opened but remote signalled close is pending: ", (Object)sender);
        }
    }

    private void handleRemoteCloseOrDetach(org.apache.qpid.protonj2.engine.Sender sender) {
        if (sender.isLocallyOpen()) {
            try {
                this.senderRemotelyClosedHandler.accept(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.immediateLinkShutdown(ClientExceptionSupport.convertToLinkClosedException(sender.getRemoteCondition(), "Sender remotely closed without explanation from the remote"));
        } else {
            this.immediateLinkShutdown(this.failureCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreditStateUpdated(org.apache.qpid.protonj2.engine.Sender sender) {
        if (!this.blocked.isEmpty()) {
            ClientOutgoingEnvelope held;
            while (sender.isSendable() && !this.blocked.isEmpty() && (held = this.blocked.peek()).delivery() == this.protonSender.current()) {
                LOG.trace("Dispatching previously held send");
                try {
                    this.session.getTransactionContext().send(held, null, this.isSendingSettled());
                }
                catch (Exception error) {
                    held.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
                finally {
                    this.blocked.poll();
                }
            }
        }
        if (sender.isDraining() && sender.current() == null && this.blocked.isEmpty()) {
            sender.drained();
        }
    }

    private void handleEngineShutdown(Engine engine) {
        if (!this.isDynamic() && !this.session.getConnection().getEngine().isShutdown()) {
            this.protonSender.localCloseHandler(null);
            this.protonSender.localDetachHandler(null);
            this.protonSender.close();
            if (this.protonSender.hasUnsettled()) {
                this.failPendingUnsettledAndBlockedSends(new ClientConnectionRemotelyClosedException("Connection failed and send result is unknown"));
            }
            this.protonSender = ClientSenderBuilder.recreateSender(this.session, this.protonSender, this.options);
            this.protonSender.setLinkedResource((Object)this);
            this.open();
        } else {
            Connection connection = engine.connection();
            ClientConnectionRemotelyClosedException failureCause = connection.getRemoteCondition() != null ? ClientExceptionSupport.convertToConnectionClosedException(connection.getRemoteCondition()) : (engine.failureCause() != null ? ClientExceptionSupport.convertToConnectionClosedException(engine.failureCause()) : (!this.isClosed() ? new ClientConnectionRemotelyClosedException("Remote closed without a specific error condition") : null));
            this.immediateLinkShutdown(failureCause);
        }
    }

    void handleAnonymousRelayNotSupported() {
        if (this.isAnonymous() && this.protonSender.getState() == LinkState.IDLE) {
            this.immediateLinkShutdown(new ClientUnsupportedOperationException("Anonymous relay support not available from this connection"));
        }
    }

    private void waitForOpenToComplete() throws ClientException {
        if (!this.openFuture.isComplete() || this.openFuture.isFailed()) {
            try {
                this.openFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.interrupted();
                if (this.failureCause != null) {
                    throw this.failureCause;
                }
                throw ClientExceptionSupport.createNonFatalOrPassthrough(e.getCause());
            }
        }
    }

    protected final void addToTailOfBlockedQueue(ClientOutgoingEnvelope send) {
        if (this.options.sendTimeout() > 0L && send.sendTimeout() == null) {
            send.sendTimeout(this.executor.schedule(() -> send.failed(send.createSendTimedOutException()), this.options.sendTimeout(), TimeUnit.MILLISECONDS));
        }
        this.blocked.addLast(send);
    }

    protected final void addToHeadOfBlockedQueue(ClientOutgoingEnvelope send) {
        if (this.options.sendTimeout() > 0L && send.sendTimeout() == null) {
            send.sendTimeout(this.executor.schedule(() -> send.failed(send.createSendTimedOutException()), this.options.sendTimeout(), TimeUnit.MILLISECONDS));
        }
        this.blocked.addFirst(send);
    }

    protected Tracker sendMessage(AdvancedMessage<?> message, Map<String, Object> deliveryAnnotations, boolean waitForCredit) throws ClientException {
        ClientFuture operation = this.session.getFutureFactory().createFuture();
        ProtonBuffer buffer = message.encode(deliveryAnnotations);
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(operation)) {
                try {
                    ClientOutgoingEnvelope envelope = new ClientOutgoingEnvelope(this, message.messageFormat(), buffer, operation);
                    if (this.protonSender.isSendable() && this.protonSender.current() == null) {
                        this.session.getTransactionContext().send(envelope, null, this.protonSender.getSenderSettleMode() == SenderSettleMode.SETTLED);
                    } else if (waitForCredit) {
                        this.addToTailOfBlockedQueue(envelope);
                    } else {
                        operation.complete(null);
                    }
                }
                catch (Exception error) {
                    operation.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
            }
        });
        return (Tracker)this.session.request(this, operation);
    }

    protected Tracker createTracker(OutgoingDelivery delivery) {
        return new ClientTracker(this, delivery);
    }

    protected Tracker createNoOpTracker() {
        return new ClientNoOpTracker(this);
    }

    protected boolean notClosedOrFailed(ClientFuture<?> request) {
        return this.notClosedOrFailed(request, this.protonSender);
    }

    protected boolean notClosedOrFailed(ClientFuture<?> request, org.apache.qpid.protonj2.engine.Sender sender) {
        if (this.isClosed()) {
            request.failed(new ClientIllegalStateException("The Sender was explicitly closed", this.failureCause));
            return false;
        }
        if (this.failureCause != null) {
            request.failed(this.failureCause);
            return false;
        }
        if (sender.isLocallyClosedOrDetached()) {
            if (sender.getConnection().getRemoteCondition() != null) {
                request.failed(ClientExceptionSupport.convertToConnectionClosedException(sender.getConnection().getRemoteCondition()));
            } else if (sender.getSession().getRemoteCondition() != null) {
                request.failed(ClientExceptionSupport.convertToSessionClosedException(sender.getSession().getRemoteCondition()));
            } else if (sender.getEngine().failureCause() != null) {
                request.failed(ClientExceptionSupport.convertToConnectionClosedException(sender.getEngine().failureCause()));
            } else {
                request.failed(new ClientIllegalStateException("Sender closed without a specific error condition"));
            }
            return false;
        }
        return true;
    }

    protected void checkClosedOrFailed() throws ClientException {
        if (this.isClosed()) {
            throw new ClientIllegalStateException("The Sender was explicitly closed", this.failureCause);
        }
        if (this.failureCause != null) {
            throw this.failureCause;
        }
    }

    private void immediateLinkShutdown(ClientException failureCause) {
        if (this.failureCause == null) {
            this.failureCause = failureCause;
        }
        try {
            if (this.protonSender.isRemotelyDetached()) {
                this.protonSender.detach();
            } else {
                this.protonSender.close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (this.session instanceof ClientStreamSession) {
                this.session.closeAsync();
            }
        }
        if (failureCause != null) {
            this.failPendingUnsettledAndBlockedSends(failureCause);
        } else {
            this.failPendingUnsettledAndBlockedSends(new ClientResourceRemotelyClosedException("The sender link has closed"));
        }
        if (failureCause != null) {
            this.openFuture.failed(failureCause);
        } else {
            this.openFuture.complete(this);
        }
        this.closeFuture.complete(this);
    }

    private void failPendingUnsettledAndBlockedSends(ClientException cause) {
        this.protonSender.unsettled().forEach(delivery -> {
            try {
                ClientTracker tracker = (ClientTracker)delivery.getLinkedResource();
                ((ClientFuture)tracker.settlementFuture()).failed(cause);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.blocked.removeIf(held -> {
            held.failed(cause);
            return true;
        });
    }
}

