/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.qpid.protonj2.client.Delivery;
import org.apache.qpid.protonj2.client.DeliveryState;
import org.apache.qpid.protonj2.client.ErrorCondition;
import org.apache.qpid.protonj2.client.Receiver;
import org.apache.qpid.protonj2.client.ReceiverOptions;
import org.apache.qpid.protonj2.client.Source;
import org.apache.qpid.protonj2.client.Target;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientConnection;
import org.apache.qpid.protonj2.client.impl.ClientConversionSupport;
import org.apache.qpid.protonj2.client.impl.ClientDelivery;
import org.apache.qpid.protonj2.client.impl.ClientErrorCondition;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientInstance;
import org.apache.qpid.protonj2.client.impl.ClientReceiverBuilder;
import org.apache.qpid.protonj2.client.impl.ClientRemoteSource;
import org.apache.qpid.protonj2.client.impl.ClientRemoteTarget;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.util.FifoDeliveryQueue;
import org.apache.qpid.protonj2.engine.Connection;
import org.apache.qpid.protonj2.engine.Engine;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.types.messaging.Accepted;
import org.apache.qpid.protonj2.types.messaging.Released;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientReceiver
implements Receiver {
    private static final Logger LOG = LoggerFactory.getLogger(ClientReceiver.class);
    private static final AtomicIntegerFieldUpdater<ClientReceiver> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClientReceiver.class, "closed");
    private final ClientFuture<Receiver> openFuture;
    private final ClientFuture<Receiver> closeFuture;
    private ClientFuture<Receiver> drainingFuture;
    private ScheduledFuture<?> drainingTimeout;
    private final ReceiverOptions options;
    private final ClientSession session;
    private final ScheduledExecutorService executor;
    private final String receiverId;
    private final FifoDeliveryQueue messageQueue;
    private volatile int closed;
    private ClientException failureCause;
    private org.apache.qpid.protonj2.engine.Receiver protonReceiver;
    private volatile Source remoteSource;
    private volatile Target remoteTarget;

    ClientReceiver(ClientSession session, ReceiverOptions options, String receiverId, org.apache.qpid.protonj2.engine.Receiver receiver) {
        this.options = options;
        this.session = session;
        this.receiverId = receiverId;
        this.executor = session.getScheduler();
        this.openFuture = session.getFutureFactory().createFuture();
        this.closeFuture = session.getFutureFactory().createFuture();
        this.protonReceiver = (org.apache.qpid.protonj2.engine.Receiver)receiver.setLinkedResource((Object)this);
        if (options.creditWindow() > 0) {
            this.protonReceiver.addCredit(options.creditWindow());
        }
        this.messageQueue = new FifoDeliveryQueue(options.creditWindow());
        this.messageQueue.start();
    }

    @Override
    public String address() throws ClientException {
        if (this.isDynamic()) {
            this.waitForOpenToComplete();
            return this.protonReceiver.getRemoteSource().getAddress();
        }
        return this.protonReceiver.getSource() != null ? this.protonReceiver.getSource().getAddress() : null;
    }

    @Override
    public Source source() throws ClientException {
        this.waitForOpenToComplete();
        return this.remoteSource;
    }

    @Override
    public Target target() throws ClientException {
        this.waitForOpenToComplete();
        return this.remoteTarget;
    }

    @Override
    public ClientInstance client() {
        return this.session.client();
    }

    @Override
    public ClientConnection connection() {
        return this.session.connection();
    }

    @Override
    public ClientSession session() {
        return this.session;
    }

    @Override
    public Future<Receiver> openFuture() {
        return this.openFuture;
    }

    @Override
    public Delivery receive() throws ClientException {
        return this.receive(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Delivery receive(long timeout, TimeUnit units) throws ClientException {
        this.checkClosedOrFailed();
        try {
            ClientDelivery delivery = this.messageQueue.dequeue(units.toMillis(timeout));
            if (delivery != null) {
                if (this.options.autoAccept()) {
                    this.asyncApplyDisposition(delivery.protonDelivery(), (org.apache.qpid.protonj2.types.transport.DeliveryState)Accepted.getInstance(), this.options.autoSettle());
                } else {
                    this.asyncReplenishCreditIfNeeded();
                }
                return delivery;
            }
            this.checkClosedOrFailed();
            return null;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ClientException("Receive wait interrupted", e);
        }
    }

    @Override
    public Delivery tryReceive() throws ClientException {
        this.checkClosedOrFailed();
        ClientDelivery delivery = this.messageQueue.dequeueNoWait();
        if (delivery != null) {
            if (this.options.autoAccept()) {
                delivery.disposition(DeliveryState.accepted(), this.options.autoSettle());
            } else {
                this.asyncReplenishCreditIfNeeded();
            }
        } else {
            this.checkClosedOrFailed();
        }
        return delivery;
    }

    @Override
    public void close() {
        try {
            this.doCloseOrDetach(true, null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void close(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        try {
            this.doCloseOrDetach(true, error).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void detach() {
        try {
            this.doCloseOrDetach(false, null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void detach(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        try {
            this.doCloseOrDetach(false, error).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    public ClientFuture<Receiver> closeAsync() {
        return this.doCloseOrDetach(true, null);
    }

    public ClientFuture<Receiver> closeAsync(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        return this.doCloseOrDetach(true, error);
    }

    public ClientFuture<Receiver> detachAsync() {
        return this.doCloseOrDetach(false, null);
    }

    public ClientFuture<Receiver> detachAsync(ErrorCondition error) {
        Objects.requireNonNull(error, "The provided Error Condition cannot be null");
        return this.doCloseOrDetach(false, error);
    }

    private ClientFuture<Receiver> doCloseOrDetach(boolean close, ErrorCondition error) {
        if (CLOSED_UPDATER.compareAndSet(this, 0, 1) && !this.closeFuture.isDone()) {
            this.executor.execute(() -> {
                if (this.protonReceiver.isLocallyOpen()) {
                    try {
                        this.protonReceiver.setCondition(ClientErrorCondition.asProtonErrorCondition(error));
                        if (close) {
                            this.protonReceiver.close();
                        } else {
                            this.protonReceiver.detach();
                        }
                    }
                    catch (Throwable ignore) {
                        this.closeFuture.complete(this);
                    }
                }
            });
        }
        return this.closeFuture;
    }

    @Override
    public long queuedDeliveries() {
        return this.messageQueue.size();
    }

    @Override
    public Receiver addCredit(int credits) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture creditAdded = this.session.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(creditAdded)) {
                if (this.options.creditWindow() != 0) {
                    creditAdded.failed(new ClientIllegalStateException("Cannot add credit when a credit window has been configured"));
                } else if (this.protonReceiver.isDraining()) {
                    creditAdded.failed(new ClientIllegalStateException("Cannot add credit while a drain is pending"));
                } else {
                    try {
                        this.protonReceiver.addCredit(credits);
                        creditAdded.complete(this);
                    }
                    catch (Exception ex) {
                        creditAdded.failed(ClientExceptionSupport.createNonFatalOrPassthrough(ex));
                    }
                }
            }
        });
        return (Receiver)this.session.request(this, creditAdded);
    }

    @Override
    public Future<Receiver> drain() throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture<Receiver> drainComplete = this.session.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(drainComplete)) {
                if (this.protonReceiver.isDraining()) {
                    drainComplete.failed(new ClientIllegalStateException("Receiver is already draining"));
                    return;
                }
                try {
                    if (this.protonReceiver.drain()) {
                        this.drainingFuture = drainComplete;
                        this.drainingTimeout = this.session.scheduleRequestTimeout(this.drainingFuture, this.options.drainTimeout(), () -> new ClientOperationTimedOutException("Timed out waiting for remote to respond to drain request"));
                    } else {
                        drainComplete.complete(this);
                    }
                }
                catch (Exception ex) {
                    drainComplete.failed(ClientExceptionSupport.createNonFatalOrPassthrough(ex));
                }
            }
        });
        return drainComplete;
    }

    @Override
    public Map<String, Object> properties() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringKeyedMap(this.protonReceiver.getRemoteProperties());
    }

    @Override
    public String[] offeredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonReceiver.getRemoteOfferedCapabilities());
    }

    @Override
    public String[] desiredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonReceiver.getRemoteDesiredCapabilities());
    }

    void disposition(IncomingDelivery delivery, org.apache.qpid.protonj2.types.transport.DeliveryState state, boolean settle) throws ClientException {
        this.checkClosedOrFailed();
        this.asyncApplyDisposition(delivery, state, settle);
    }

    ClientReceiver open() {
        ((org.apache.qpid.protonj2.engine.Receiver)((org.apache.qpid.protonj2.engine.Receiver)((org.apache.qpid.protonj2.engine.Receiver)((org.apache.qpid.protonj2.engine.Receiver)((org.apache.qpid.protonj2.engine.Receiver)((org.apache.qpid.protonj2.engine.Receiver)((org.apache.qpid.protonj2.engine.Receiver)((org.apache.qpid.protonj2.engine.Receiver)((org.apache.qpid.protonj2.engine.Receiver)this.protonReceiver.localOpenHandler(this::handleLocalOpen)).localCloseHandler(this::handleLocalCloseOrDetach)).localDetachHandler(this::handleLocalCloseOrDetach)).openHandler(this::handleRemoteOpen)).closeHandler(this::handleRemoteCloseOrDetach)).detachHandler(this::handleRemoteCloseOrDetach)).parentEndpointClosedHandler(this::handleParentEndpointClosed)).deliveryStateUpdatedHandler(this::handleDeliveryStateRemotelyUpdated).deliveryReadHandler(this::handleDeliveryReceived).deliveryAbortedHandler(this::handleDeliveryAborted).creditStateUpdateHandler(this::handleReceiverCreditUpdated)).engineShutdownHandler(this::handleEngineShutdown)).open();
        return this;
    }

    void setFailureCause(ClientException failureCause) {
        this.failureCause = failureCause;
    }

    ClientException getFailureCause() {
        if (this.failureCause == null) {
            return this.session.getFailureCause();
        }
        return this.failureCause;
    }

    String getId() {
        return this.receiverId;
    }

    boolean isClosed() {
        return this.closed > 0;
    }

    boolean isDynamic() {
        return this.protonReceiver.getSource() != null && this.protonReceiver.getSource().isDynamic();
    }

    private void handleLocalOpen(org.apache.qpid.protonj2.engine.Receiver receiver) {
        if (this.options.openTimeout() > 0L) {
            this.executor.schedule(() -> {
                if (!this.openFuture.isDone()) {
                    this.immediateLinkShutdown(new ClientOperationTimedOutException("Receiver open timed out waiting for remote to respond"));
                }
            }, this.options.openTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    private void handleLocalCloseOrDetach(org.apache.qpid.protonj2.engine.Receiver receiver) {
        this.messageQueue.stop();
        if (!receiver.getEngine().isShutdown() && this.failureCause == null && receiver.isRemotelyOpen()) {
            long timeout = this.options.closeTimeout();
            if (timeout > 0L) {
                this.session.scheduleRequestTimeout(this.closeFuture, timeout, () -> new ClientOperationTimedOutException("receiver close timed out waiting for remote to respond"));
            }
        } else {
            this.immediateLinkShutdown(this.failureCause);
        }
    }

    private void handleRemoteOpen(org.apache.qpid.protonj2.engine.Receiver receiver) {
        if (receiver.getRemoteSource() != null) {
            this.remoteSource = new ClientRemoteSource(receiver.getRemoteSource());
            if (receiver.getRemoteTarget() != null) {
                this.remoteTarget = new ClientRemoteTarget((org.apache.qpid.protonj2.types.messaging.Target)receiver.getRemoteTarget());
            }
            this.replenishCreditIfNeeded();
            this.openFuture.complete(this);
            LOG.trace("Receiver opened successfully: {}", (Object)this.receiverId);
        } else {
            LOG.debug("Receiver opened but remote signalled close is pending: {}", (Object)this.receiverId);
        }
    }

    private void handleRemoteCloseOrDetach(org.apache.qpid.protonj2.engine.Receiver receiver) {
        if (receiver.isLocallyOpen()) {
            this.immediateLinkShutdown(ClientExceptionSupport.convertToLinkClosedException(receiver.getRemoteCondition(), "Receiver remotely closed without explanation from the remote"));
        } else {
            this.immediateLinkShutdown(this.failureCause);
        }
    }

    private void handleParentEndpointClosed(org.apache.qpid.protonj2.engine.Receiver receiver) {
        if (receiver.getEngine().isRunning()) {
            ClientException failureCause = receiver.getConnection().getRemoteCondition() != null ? ClientExceptionSupport.convertToConnectionClosedException(receiver.getConnection().getRemoteCondition()) : (receiver.getSession().getRemoteCondition() != null ? ClientExceptionSupport.convertToSessionClosedException(receiver.getSession().getRemoteCondition()) : (receiver.getEngine().failureCause() != null ? ClientExceptionSupport.convertToConnectionClosedException(receiver.getEngine().failureCause()) : (!this.isClosed() ? new ClientResourceRemotelyClosedException("Remote closed without a specific error condition") : null)));
            this.immediateLinkShutdown(failureCause);
        }
    }

    private void handleEngineShutdown(Engine engine) {
        if (!this.isDynamic() && !this.session.getConnection().getEngine().isShutdown()) {
            int previousCredit = this.protonReceiver.getCredit() + this.messageQueue.size();
            this.messageQueue.clear();
            if (this.drainingFuture != null) {
                this.drainingFuture.complete(this);
                if (this.drainingTimeout != null) {
                    this.drainingTimeout.cancel(false);
                    this.drainingTimeout = null;
                }
            }
            this.protonReceiver.localCloseHandler(null);
            this.protonReceiver.localDetachHandler(null);
            this.protonReceiver.close();
            this.protonReceiver = ClientReceiverBuilder.recreateReceiver(this.session, this.protonReceiver, this.options);
            this.protonReceiver.setLinkedResource((Object)this);
            this.protonReceiver.addCredit(previousCredit);
            this.open();
        } else {
            Connection connection = engine.connection();
            ClientConnectionRemotelyClosedException failureCause = connection.getRemoteCondition() != null ? ClientExceptionSupport.convertToConnectionClosedException(connection.getRemoteCondition()) : (engine.failureCause() != null ? ClientExceptionSupport.convertToConnectionClosedException(engine.failureCause()) : (!this.isClosed() ? new ClientConnectionRemotelyClosedException("Remote closed without a specific error condition") : null));
            this.immediateLinkShutdown(failureCause);
        }
    }

    private void handleDeliveryReceived(IncomingDelivery delivery) {
        LOG.trace("Delivery data was received: {}", (Object)delivery);
        if (delivery.getDefaultDeliveryState() == null) {
            delivery.setDefaultDeliveryState((org.apache.qpid.protonj2.types.transport.DeliveryState)Released.getInstance());
        }
        if (!delivery.isPartial()) {
            LOG.trace("{} has incoming Message(s).", (Object)this);
            this.messageQueue.enqueue(new ClientDelivery(this, delivery));
        } else {
            delivery.claimAvailableBytes();
        }
    }

    private void handleDeliveryAborted(IncomingDelivery delivery) {
        LOG.trace("Delivery data was aborted: {}", (Object)delivery);
        delivery.settle();
        this.replenishCreditIfNeeded();
    }

    private void handleDeliveryStateRemotelyUpdated(IncomingDelivery delivery) {
        LOG.trace("Delivery remote state was updated: {}", (Object)delivery);
    }

    private void handleReceiverCreditUpdated(org.apache.qpid.protonj2.engine.Receiver receiver) {
        LOG.trace("Receiver credit update by remote: {}", (Object)receiver);
        if (this.drainingFuture != null && receiver.getCredit() == 0) {
            this.drainingFuture.complete(this);
            if (this.drainingTimeout != null) {
                this.drainingTimeout.cancel(false);
                this.drainingTimeout = null;
            }
        }
    }

    private void asyncApplyDisposition(IncomingDelivery delivery, org.apache.qpid.protonj2.types.transport.DeliveryState state, boolean settle) {
        this.executor.execute(() -> {
            this.session.getTransactionContext().disposition(delivery, state, settle);
            this.replenishCreditIfNeeded();
        });
    }

    private void replenishCreditIfNeeded() {
        int potentialPrefetch;
        int currentCredit;
        int creditWindow = this.options.creditWindow();
        if (creditWindow > 0 && (double)(currentCredit = this.protonReceiver.getCredit()) <= (double)creditWindow * 0.5 && (double)(potentialPrefetch = currentCredit + this.messageQueue.size()) <= (double)creditWindow * 0.7) {
            int additionalCredit = creditWindow - potentialPrefetch;
            LOG.trace("Consumer granting additional credit: {}", (Object)additionalCredit);
            try {
                this.protonReceiver.addCredit(additionalCredit);
            }
            catch (Exception ex) {
                LOG.debug("Error caught during credit top-up", (Throwable)ex);
            }
        }
    }

    private void asyncReplenishCreditIfNeeded() {
        int creditWindow = this.options.creditWindow();
        if (creditWindow > 0) {
            this.executor.execute(() -> this.replenishCreditIfNeeded());
        }
    }

    private void waitForOpenToComplete() throws ClientException {
        if (!this.openFuture.isComplete() || this.openFuture.isFailed()) {
            try {
                this.openFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.interrupted();
                if (this.failureCause != null) {
                    throw this.failureCause;
                }
                throw ClientExceptionSupport.createNonFatalOrPassthrough(e.getCause());
            }
        }
    }

    private boolean notClosedOrFailed(ClientFuture<?> request) {
        if (this.isClosed()) {
            request.failed(new ClientIllegalStateException("The Receiver was explicitly closed", this.failureCause));
            return false;
        }
        if (this.failureCause != null) {
            request.failed(this.failureCause);
            return false;
        }
        return true;
    }

    private void checkClosedOrFailed() throws ClientException {
        if (this.isClosed()) {
            throw new ClientIllegalStateException("The Receiver was explicitly closed", this.failureCause);
        }
        if (this.failureCause != null) {
            throw this.failureCause;
        }
    }

    private void immediateLinkShutdown(ClientException failureCause) {
        if (this.failureCause == null) {
            this.failureCause = failureCause;
        }
        try {
            if (this.protonReceiver.isRemotelyDetached()) {
                this.protonReceiver.detach();
            } else {
                this.protonReceiver.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (failureCause != null) {
            this.openFuture.failed(failureCause);
            if (this.drainingFuture != null) {
                this.drainingFuture.failed(failureCause);
            }
        } else {
            this.openFuture.complete(this);
            if (this.drainingFuture != null) {
                this.drainingFuture.failed(new ClientResourceRemotelyClosedException("The Receiver has been closed"));
            }
        }
        if (this.drainingTimeout != null) {
            this.drainingTimeout.cancel(false);
            this.drainingTimeout = null;
        }
        this.closeFuture.complete(this);
    }
}

