/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.security.sasl.SaslException;
import org.apache.qpid.protonj2.client.ErrorCondition;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionRedirectedException;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionSecurityException;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionSecuritySaslException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIOException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientLinkRedirectedException;
import org.apache.qpid.protonj2.client.exceptions.ClientLinkRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientSessionRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientTransactionRolledBackException;
import org.apache.qpid.protonj2.client.impl.ClientErrorCondition;
import org.apache.qpid.protonj2.client.impl.ClientRedirect;
import org.apache.qpid.protonj2.engine.sasl.SaslSystemException;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.transactions.TransactionErrors;
import org.apache.qpid.protonj2.types.transport.AmqpError;
import org.apache.qpid.protonj2.types.transport.ConnectionError;
import org.apache.qpid.protonj2.types.transport.LinkError;

class ClientExceptionSupport {
    ClientExceptionSupport() {
    }

    public static ClientIOException createOrPassthroughFatal(Throwable cause) {
        if (cause instanceof ClientIOException) {
            return (ClientIOException)cause;
        }
        if (cause.getCause() instanceof ClientIOException) {
            return (ClientIOException)cause.getCause();
        }
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        return new ClientIOException(message, cause);
    }

    public static ClientException createNonFatalOrPassthrough(Throwable cause) {
        if (cause instanceof ClientException) {
            return (ClientException)cause;
        }
        if (cause.getCause() instanceof ClientException) {
            return (ClientException)cause.getCause();
        }
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        if (cause instanceof TimeoutException) {
            return new ClientOperationTimedOutException(message, cause);
        }
        if (cause instanceof IllegalStateException) {
            return new ClientIllegalStateException(message, cause);
        }
        return new ClientException(message, cause);
    }

    public static ClientConnectionRemotelyClosedException convertToConnectionClosedException(org.apache.qpid.protonj2.types.transport.ErrorCondition errorCondition) {
        ClientConnectionRemotelyClosedException remoteError;
        if (errorCondition != null && errorCondition.getCondition() != null) {
            Symbol error = errorCondition.getCondition();
            String message = ClientExceptionSupport.extractErrorMessage(errorCondition);
            remoteError = error.equals((Object)AmqpError.UNAUTHORIZED_ACCESS) ? new ClientConnectionSecurityException(message, new ClientErrorCondition(errorCondition)) : (error.equals((Object)ConnectionError.REDIRECT) ? ClientExceptionSupport.createConnectionRedirectException(error, message, errorCondition) : new ClientConnectionRemotelyClosedException(message, new ClientErrorCondition(errorCondition)));
        } else {
            remoteError = new ClientConnectionRemotelyClosedException("Unknown error from remote peer");
        }
        return remoteError;
    }

    public static ClientConnectionRemotelyClosedException convertToConnectionClosedException(Throwable cause) {
        ClientConnectionRemotelyClosedException remoteError = null;
        remoteError = cause instanceof ClientConnectionRemotelyClosedException ? (ClientConnectionRemotelyClosedException)cause : (cause instanceof SaslSystemException ? new ClientConnectionSecuritySaslException(cause.getMessage(), !((SaslSystemException)cause).isPermanent(), cause) : (cause instanceof SaslException ? new ClientConnectionSecuritySaslException(cause.getMessage(), cause) : new ClientConnectionRemotelyClosedException(cause.getMessage(), cause)));
        return remoteError;
    }

    public static ClientSessionRemotelyClosedException convertToSessionClosedException(org.apache.qpid.protonj2.types.transport.ErrorCondition errorCondition) {
        ClientSessionRemotelyClosedException remoteError;
        if (errorCondition != null && errorCondition.getCondition() != null) {
            String message = ClientExceptionSupport.extractErrorMessage(errorCondition);
            if (message == null) {
                message = "Session remotely closed without explanation";
            }
            remoteError = new ClientSessionRemotelyClosedException(message, new ClientErrorCondition(errorCondition));
        } else {
            remoteError = new ClientSessionRemotelyClosedException("Session remotely closed without explanation");
        }
        return remoteError;
    }

    public static ClientLinkRemotelyClosedException convertToLinkClosedException(org.apache.qpid.protonj2.types.transport.ErrorCondition errorCondition, String defaultMessage) {
        ClientLinkRemotelyClosedException remoteError;
        if (errorCondition != null && errorCondition.getCondition() != null) {
            String message = ClientExceptionSupport.extractErrorMessage(errorCondition);
            Symbol error = errorCondition.getCondition();
            if (message == null) {
                message = defaultMessage;
            }
            remoteError = error.equals((Object)LinkError.REDIRECT) ? ClientExceptionSupport.createLinkRedirectException(error, message, errorCondition) : new ClientLinkRemotelyClosedException(message, new ClientErrorCondition(errorCondition));
        } else {
            remoteError = new ClientLinkRemotelyClosedException(defaultMessage);
        }
        return remoteError;
    }

    public static ClientException convertToNonFatalException(org.apache.qpid.protonj2.types.transport.ErrorCondition errorCondition) {
        ClientException remoteError;
        if (errorCondition != null && errorCondition.getCondition() != null) {
            Symbol error = errorCondition.getCondition();
            String message = ClientExceptionSupport.extractErrorMessage(errorCondition);
            remoteError = error.equals((Object)AmqpError.RESOURCE_LIMIT_EXCEEDED) ? new ClientResourceRemotelyClosedException(message, new ClientErrorCondition(errorCondition)) : (error.equals((Object)AmqpError.NOT_FOUND) ? new ClientResourceRemotelyClosedException(message, new ClientErrorCondition(errorCondition)) : (error.equals((Object)LinkError.DETACH_FORCED) ? new ClientResourceRemotelyClosedException(message, new ClientErrorCondition(errorCondition)) : (error.equals((Object)LinkError.REDIRECT) ? ClientExceptionSupport.createLinkRedirectException(error, message, errorCondition) : (error.equals((Object)AmqpError.RESOURCE_DELETED) ? new ClientResourceRemotelyClosedException(message, new ClientErrorCondition(errorCondition)) : (error.equals((Object)TransactionErrors.TRANSACTION_ROLLBACK) ? new ClientTransactionRolledBackException(message) : new ClientException(message))))));
        } else {
            remoteError = new ClientException("Unknown error from remote peer");
        }
        return remoteError;
    }

    public static String extractErrorMessage(org.apache.qpid.protonj2.types.transport.ErrorCondition errorCondition) {
        Object message = "Received error from remote peer without description";
        if (errorCondition != null) {
            Symbol condition;
            if (errorCondition.getDescription() != null && !errorCondition.getDescription().isEmpty()) {
                message = errorCondition.getDescription();
            }
            if ((condition = errorCondition.getCondition()) != null) {
                message = (String)message + " [condition = " + condition + "]";
            }
        }
        return message;
    }

    public static ClientConnectionRemotelyClosedException createConnectionRedirectException(Symbol error, String message, org.apache.qpid.protonj2.types.transport.ErrorCondition condition) {
        ClientConnectionRemotelyClosedException result;
        Map info = condition.getInfo();
        if (info == null) {
            result = new ClientConnectionRemotelyClosedException(message + " : Redirection information not set.", new ClientErrorCondition(condition));
        } else {
            ClientRedirect redirect = new ClientRedirect(info);
            try {
                result = new ClientConnectionRedirectedException(message, redirect.validate(), (ErrorCondition)new ClientErrorCondition(condition));
            }
            catch (Exception ex) {
                result = new ClientConnectionRemotelyClosedException(message + " : " + ex.getMessage(), new ClientErrorCondition(condition));
            }
        }
        return result;
    }

    public static ClientLinkRemotelyClosedException createLinkRedirectException(Symbol error, String message, org.apache.qpid.protonj2.types.transport.ErrorCondition condition) {
        ClientLinkRemotelyClosedException result;
        Map info = condition.getInfo();
        if (info == null) {
            result = new ClientLinkRemotelyClosedException(message + " : Redirection information not set.", new ClientErrorCondition(condition));
        } else {
            ClientRedirect redirect = new ClientRedirect(info);
            try {
                result = new ClientLinkRedirectedException(message, redirect.validate(), (ErrorCondition)new ClientErrorCondition(condition));
            }
            catch (Exception ex) {
                result = new ClientLinkRemotelyClosedException(message + " : " + ex.getMessage(), new ClientErrorCondition(condition));
            }
        }
        return result;
    }
}

