/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.client.DeliveryMode;
import org.apache.qpid.protonj2.client.SourceOptions;
import org.apache.qpid.protonj2.client.TargetOptions;

public class ReceiverOptions {
    private long drainTimeout = 60000L;
    private long requestTimeout = -1L;
    private long openTimeout = 15000L;
    private long closeTimeout = 60000L;
    private boolean autoAccept = true;
    private boolean autoSettle = true;
    private DeliveryMode deliveryMode = DeliveryMode.AT_LEAST_ONCE;
    private int creditWindow = 10;
    private String linkName;
    private final SourceOptions source = new SourceOptions();
    private final TargetOptions target = new TargetOptions();
    private String[] offeredCapabilities;
    private String[] desiredCapabilities;
    private Map<String, Object> properties;

    public ReceiverOptions() {
    }

    public ReceiverOptions(ReceiverOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public ReceiverOptions autoAccept(boolean autoAccept) {
        this.autoAccept = autoAccept;
        return this;
    }

    public boolean autoAccept() {
        return this.autoAccept;
    }

    public ReceiverOptions autoSettle(boolean autoSettle) {
        this.autoSettle = autoSettle;
        return this;
    }

    public boolean autoSettle() {
        return this.autoSettle;
    }

    public ReceiverOptions deliveryMode(DeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    public DeliveryMode deliveryMode() {
        return this.deliveryMode;
    }

    public ReceiverOptions linkName(String linkName) {
        this.linkName = linkName;
        return this;
    }

    public String linkName() {
        return this.linkName;
    }

    public int creditWindow() {
        return this.creditWindow;
    }

    public ReceiverOptions creditWindow(int creditWindow) {
        this.creditWindow = creditWindow;
        return this;
    }

    public long closeTimeout() {
        return this.closeTimeout;
    }

    public ReceiverOptions closeTimeout(long closeTimeout) {
        return this.closeTimeout(closeTimeout, TimeUnit.MILLISECONDS);
    }

    public ReceiverOptions closeTimeout(long timeout, TimeUnit units) {
        this.closeTimeout = units.toMillis(timeout);
        return this;
    }

    public long openTimeout() {
        return this.openTimeout;
    }

    public ReceiverOptions openTimeout(long openTimeout) {
        return this.openTimeout(openTimeout, TimeUnit.MILLISECONDS);
    }

    public ReceiverOptions openTimeout(long timeout, TimeUnit units) {
        this.openTimeout = units.toMillis(timeout);
        return this;
    }

    public long drainTimeout() {
        return this.drainTimeout;
    }

    public ReceiverOptions drainTimeout(long drainTimeout) {
        return this.drainTimeout(drainTimeout, TimeUnit.MILLISECONDS);
    }

    public ReceiverOptions drainTimeout(long timeout, TimeUnit units) {
        this.drainTimeout = units.toMillis(timeout);
        return this;
    }

    public long requestTimeout() {
        return this.requestTimeout;
    }

    public ReceiverOptions requestTimeout(long requestTimeout) {
        return this.requestTimeout(requestTimeout, TimeUnit.MILLISECONDS);
    }

    public ReceiverOptions requestTimeout(long timeout, TimeUnit units) {
        this.requestTimeout = units.toMillis(timeout);
        return this;
    }

    public String[] offeredCapabilities() {
        return this.offeredCapabilities;
    }

    public ReceiverOptions offeredCapabilities(String ... offeredCapabilities) {
        this.offeredCapabilities = offeredCapabilities;
        return this;
    }

    public String[] desiredCapabilities() {
        return this.desiredCapabilities;
    }

    public ReceiverOptions desiredCapabilities(String ... desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public ReceiverOptions properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public SourceOptions sourceOptions() {
        return this.source;
    }

    public TargetOptions targetOptions() {
        return this.target;
    }

    public ReceiverOptions clone() {
        return this.copyInto(new ReceiverOptions());
    }

    protected ReceiverOptions copyInto(ReceiverOptions other) {
        other.creditWindow(this.creditWindow);
        other.linkName(this.linkName);
        other.closeTimeout(this.closeTimeout);
        other.openTimeout(this.openTimeout);
        other.drainTimeout(this.drainTimeout);
        other.requestTimeout(this.requestTimeout);
        if (this.offeredCapabilities != null) {
            other.offeredCapabilities(Arrays.copyOf(this.offeredCapabilities, this.offeredCapabilities.length));
        }
        if (this.desiredCapabilities != null) {
            other.desiredCapabilities(Arrays.copyOf(this.desiredCapabilities, this.desiredCapabilities.length));
        }
        if (this.properties != null) {
            other.properties(new HashMap<String, Object>(this.properties));
        }
        this.source.copyInto(other.sourceOptions());
        this.target.copyInto(other.targetOptions());
        return this;
    }
}

