/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.sasl.client;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.engine.sasl.client.AbstractMechanism;
import org.apache.qpid.protonj2.engine.sasl.client.SaslCredentialsProvider;
import org.apache.qpid.protonj2.types.Symbol;

public class CramMD5Mechanism
extends AbstractMechanism {
    public static final Symbol CRAM_MD5 = Symbol.valueOf("CRAM-MD5");
    private static final String ASCII = "ASCII";
    private static final String HMACMD5 = "HMACMD5";
    private boolean sentResponse;

    @Override
    public Symbol getName() {
        return CRAM_MD5;
    }

    @Override
    public boolean isApplicable(SaslCredentialsProvider credentials) {
        return credentials.username() != null && !credentials.username().isEmpty() && credentials.password() != null && !credentials.password().isEmpty();
    }

    @Override
    public ProtonBuffer getInitialResponse(SaslCredentialsProvider credentials) {
        return null;
    }

    @Override
    public ProtonBuffer getChallengeResponse(SaslCredentialsProvider credentials, ProtonBuffer challenge) throws SaslException {
        if (!this.sentResponse && challenge != null && challenge.getReadableBytes() != 0) {
            try {
                SecretKeySpec key = new SecretKeySpec(credentials.password().getBytes(ASCII), HMACMD5);
                Mac mac = Mac.getInstance(HMACMD5);
                mac.init(key);
                byte[] challengeBytes = new byte[challenge.getReadableBytes()];
                challenge.readBytes(challengeBytes);
                byte[] bytes = mac.doFinal(challengeBytes);
                StringBuffer hash = new StringBuffer(credentials.username());
                hash.append(' ');
                for (int i = 0; i < bytes.length; ++i) {
                    String hex = Integer.toHexString(0xFF & bytes[i]);
                    if (hex.length() == 1) {
                        hash.append('0');
                    }
                    hash.append(hex);
                }
                this.sentResponse = true;
                return ProtonByteBufferAllocator.DEFAULT.wrap(hash.toString().getBytes(ASCII));
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("Unable to utilise required encoding", e);
            }
            catch (InvalidKeyException e) {
                throw new SaslException("Unable to utilise key", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Unable to utilise required algorithm", e);
            }
        }
        return EMPTY;
    }

    @Override
    public void verifyCompletion() throws SaslException {
        super.verifyCompletion();
        if (!this.sentResponse) {
            throw new SaslException("SASL exchange was not fully completed.");
        }
    }
}

