/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncodeException;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedTypeEncoder;

public abstract class AbstractDescribedListTypeEncoder<V>
extends AbstractDescribedTypeEncoder<V> {
    public byte getListEncoding(V value) {
        return -48;
    }

    public abstract void writeElement(V var1, int var2, ProtonBuffer var3, EncoderState var4);

    public abstract int getElementCount(V var1);

    public int getMinElementCount() {
        return 0;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, V value) {
        buffer.writeByte(0);
        state.getEncoder().writeUnsignedLong(buffer, state, this.getDescriptorCode().byteValue());
        int count = this.getElementCount(value);
        byte encodingCode = this.getListEncoding(value);
        if (count < this.getMinElementCount()) {
            throw new EncodeException("Incomplete Type cannot be encoded");
        }
        buffer.writeByte(encodingCode);
        switch (encodingCode) {
            case -64: {
                this.writeSmallType(buffer, state, value, count);
                break;
            }
            case -48: {
                this.writeLargeType(buffer, state, value, count);
            }
        }
    }

    private void writeSmallType(ProtonBuffer buffer, EncoderState state, V value, int elementCount) {
        int startIndex = buffer.getWriteIndex();
        buffer.writeByte(0);
        buffer.writeByte((byte)elementCount);
        for (int i = 0; i < elementCount; ++i) {
            this.writeElement(value, i, buffer, state);
        }
        int writeSize = buffer.getWriteIndex() - startIndex - 1;
        buffer.setByte(startIndex, writeSize);
    }

    private void writeLargeType(ProtonBuffer buffer, EncoderState state, V value, int elementCount) {
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            this.writeElement(value, i, buffer, state);
        }
        int writeSize = buffer.getWriteIndex() - startIndex - 4;
        buffer.setInt(startIndex, writeSize);
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-16);
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        buffer.writeByte(0);
        state.getEncoder().writeUnsignedLong(buffer, state, this.getDescriptorCode());
        this.writeRawArray(buffer, state, values);
        int writeSize = buffer.getWriteIndex() - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size too large: " + writeSize);
        }
        buffer.setInt(startIndex, writeSize);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-48);
        for (int i = 0; i < values.length; ++i) {
            Object listType = values[i];
            int count = this.getElementCount(listType);
            int elementStartIndex = buffer.getWriteIndex();
            buffer.writeInt(0);
            buffer.writeInt(count);
            for (int j = 0; j < count; ++j) {
                this.writeElement(listType, j, buffer, state);
            }
            int listWriteSize = buffer.getWriteIndex() - elementStartIndex - 4;
            buffer.setInt(elementStartIndex, listWriteSize);
        }
    }
}

