/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.transport;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Source;
import org.apache.qpid.protonj2.types.messaging.Terminus;
import org.apache.qpid.protonj2.types.transport.Attach;
import org.apache.qpid.protonj2.types.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.types.transport.Role;
import org.apache.qpid.protonj2.types.transport.SenderSettleMode;

public final class AttachTypeDecoder
extends AbstractDescribedTypeDecoder<Attach> {
    private static final int MIN_ATTACH_LIST_ENTRIES = 3;
    private static final int MAX_ATTACH_LIST_ENTRIES = 14;

    @Override
    public Class<Attach> getTypeClass() {
        return Attach.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Attach.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Attach.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Attach readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readAttach(buffer, state, (ListTypeDecoder)AttachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Attach[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Attach[] result = new Attach[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readAttach(buffer, state, (ListTypeDecoder)AttachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        AttachTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private Attach readAttach(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Attach attach = new Attach();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 3) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 14) {
            throw new DecodeException("To many entries in Attach list encoding: " + count);
        }
        block16: for (int index = 0; index < count; ++index) {
            boolean nullValue;
            boolean bl = nullValue = buffer.getByte(buffer.getReadIndex()) == 64;
            if (nullValue) {
                if (index < 3) {
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                buffer.readByte();
                continue;
            }
            switch (index) {
                case 0: {
                    attach.setName(state.getDecoder().readString(buffer, state));
                    continue block16;
                }
                case 1: {
                    attach.setHandle(state.getDecoder().readUnsignedInteger(buffer, state, 0L));
                    continue block16;
                }
                case 2: {
                    Boolean role = state.getDecoder().readBoolean(buffer, state);
                    attach.setRole(Boolean.TRUE.equals(role) ? Role.RECEIVER : Role.SENDER);
                    continue block16;
                }
                case 3: {
                    byte sndSettleMode = state.getDecoder().readUnsignedByte(buffer, state, (byte)2);
                    attach.setSenderSettleMode(SenderSettleMode.valueOf(sndSettleMode));
                    continue block16;
                }
                case 4: {
                    byte rcvSettleMode = state.getDecoder().readUnsignedByte(buffer, state, (byte)0);
                    attach.setReceiverSettleMode(ReceiverSettleMode.valueOf(rcvSettleMode));
                    continue block16;
                }
                case 5: {
                    attach.setSource(state.getDecoder().readObject(buffer, state, Source.class));
                    continue block16;
                }
                case 6: {
                    attach.setTarget(state.getDecoder().readObject(buffer, state, Terminus.class));
                    continue block16;
                }
                case 7: {
                    attach.setUnsettled(state.getDecoder().readMap(buffer, state));
                    continue block16;
                }
                case 8: {
                    attach.setIncompleteUnsettled(state.getDecoder().readBoolean(buffer, state, true));
                    continue block16;
                }
                case 9: {
                    attach.setInitialDeliveryCount(state.getDecoder().readUnsignedInteger(buffer, state, 0L));
                    continue block16;
                }
                case 10: {
                    attach.setMaxMessageSize(state.getDecoder().readUnsignedLong(buffer, state));
                    continue block16;
                }
                case 11: {
                    attach.setOfferedCapabilities(state.getDecoder().readMultiple(buffer, state, Symbol.class));
                    continue block16;
                }
                case 12: {
                    attach.setDesiredCapabilities(state.getDecoder().readMultiple(buffer, state, Symbol.class));
                    continue block16;
                }
                case 13: {
                    attach.setProperties(state.getDecoder().readMap(buffer, state));
                }
            }
        }
        return attach;
    }

    @Override
    public Attach readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readAttach(stream, state, (ListTypeDecoder)AttachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Attach[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Attach[] result = new Attach[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readAttach(stream, state, (ListTypeDecoder)AttachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        AttachTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private Attach readAttach(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Attach attach = new Attach();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 3) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 14) {
            throw new DecodeException("To many entries in Attach list encoding: " + count);
        }
        block16: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                boolean nullValue;
                stream.mark(1);
                boolean bl = nullValue = ProtonStreamUtils.readByte(stream) == 64;
                if (nullValue) {
                    if (index >= 3) continue;
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    attach.setName(state.getDecoder().readString(stream, state));
                    continue block16;
                }
                case 1: {
                    attach.setHandle(state.getDecoder().readUnsignedInteger(stream, state, 0L));
                    continue block16;
                }
                case 2: {
                    Boolean role = state.getDecoder().readBoolean(stream, state);
                    attach.setRole(Boolean.TRUE.equals(role) ? Role.RECEIVER : Role.SENDER);
                    continue block16;
                }
                case 3: {
                    byte sndSettleMode = state.getDecoder().readUnsignedByte(stream, state, (byte)2);
                    attach.setSenderSettleMode(SenderSettleMode.valueOf(sndSettleMode));
                    continue block16;
                }
                case 4: {
                    byte rcvSettleMode = state.getDecoder().readUnsignedByte(stream, state, (byte)0);
                    attach.setReceiverSettleMode(ReceiverSettleMode.valueOf(rcvSettleMode));
                    continue block16;
                }
                case 5: {
                    attach.setSource(state.getDecoder().readObject(stream, state, Source.class));
                    continue block16;
                }
                case 6: {
                    attach.setTarget(state.getDecoder().readObject(stream, state, Terminus.class));
                    continue block16;
                }
                case 7: {
                    attach.setUnsettled(state.getDecoder().readMap(stream, state));
                    continue block16;
                }
                case 8: {
                    attach.setIncompleteUnsettled(state.getDecoder().readBoolean(stream, state, true));
                    continue block16;
                }
                case 9: {
                    attach.setInitialDeliveryCount(state.getDecoder().readUnsignedInteger(stream, state, 0L));
                    continue block16;
                }
                case 10: {
                    attach.setMaxMessageSize(state.getDecoder().readUnsignedLong(stream, state));
                    continue block16;
                }
                case 11: {
                    attach.setOfferedCapabilities(state.getDecoder().readMultiple(stream, state, Symbol.class));
                    continue block16;
                }
                case 12: {
                    attach.setDesiredCapabilities(state.getDecoder().readMultiple(stream, state, Symbol.class));
                    continue block16;
                }
                case 13: {
                    attach.setProperties(state.getDecoder().readMap(stream, state));
                }
            }
        }
        return attach;
    }

    private String errorForMissingRequiredFields(int present) {
        switch (present) {
            case 2: {
                return "The role field cannot be omitted from the Attach";
            }
            case 1: {
                return "The handle field cannot be omitted from the Attach";
            }
        }
        return "The name field cannot be omitted from the Attach";
    }
}

