/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.security;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.security.SaslResponse;

public final class SaslResponseTypeDecoder
extends AbstractDescribedTypeDecoder<SaslResponse> {
    private static final int REQUIRED_LIST_ENTRIES = 1;

    @Override
    public UnsignedLong getDescriptorCode() {
        return SaslResponse.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return SaslResponse.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<SaslResponse> getTypeClass() {
        return SaslResponse.class;
    }

    @Override
    public SaslResponse readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readProperties(buffer, state, (ListTypeDecoder)SaslResponseTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public SaslResponse[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        SaslResponse[] result = new SaslResponse[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readProperties(buffer, state, (ListTypeDecoder)SaslResponseTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        SaslResponseTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private SaslResponse readProperties(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        SaslResponse response = new SaslResponse();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count != 1) {
            throw new DecodeException("SASL Response must contain a single response binary: " + count);
        }
        response.setResponse(state.getDecoder().readBinaryAsBuffer(buffer, state));
        return response;
    }

    @Override
    public SaslResponse readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readProperties(stream, state, (ListTypeDecoder)SaslResponseTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public SaslResponse[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        SaslResponse[] result = new SaslResponse[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readProperties(stream, state, (ListTypeDecoder)SaslResponseTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        SaslResponseTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private SaslResponse readProperties(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        SaslResponse response = new SaslResponse();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count != 1) {
            throw new DecodeException("SASL Response must contain a single response binary: " + count);
        }
        response.setResponse(state.getDecoder().readBinaryAsBuffer(stream, state));
        return response;
    }
}

