/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Rejected;
import org.apache.qpid.protonj2.types.transport.ErrorCondition;

public final class RejectedTypeDecoder
extends AbstractDescribedTypeDecoder<Rejected> {
    private static final int MIN_REJECTED_LIST_ENTRIES = 0;
    private static final int MAX_REJECTED_LIST_ENTRIES = 1;

    @Override
    public Class<Rejected> getTypeClass() {
        return Rejected.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Rejected.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Rejected.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Rejected readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        RejectedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        return this.readRejected(buffer, state, (ListTypeDecoder)RejectedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Rejected[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Rejected[] result = new Rejected[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readRejected(buffer, state, (ListTypeDecoder)RejectedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        RejectedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private Rejected readRejected(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Rejected rejected = new Rejected();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Rejected list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Rejected list encoding: " + count);
        }
        for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    rejected.setError(state.getDecoder().readObject(buffer, state, ErrorCondition.class));
                }
            }
        }
        return rejected;
    }

    @Override
    public Rejected readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readRejected(stream, state, (ListTypeDecoder)RejectedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Rejected[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Rejected[] result = new Rejected[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readRejected(stream, state, (ListTypeDecoder)RejectedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        RejectedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private Rejected readRejected(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Rejected rejected = new Rejected();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Rejected list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Rejected list encoding: " + count);
        }
        for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    rejected.setError(state.getDecoder().readObject(stream, state, ErrorCondition.class));
                }
            }
        }
        return rejected;
    }
}

