/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonAbstractBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBuffer;

public class ProtonNioByteBuffer
extends ProtonAbstractBuffer {
    private final ByteBuffer buffer;

    public ProtonNioByteBuffer(ByteBuffer buffer) {
        this(buffer, buffer.remaining());
    }

    public ProtonNioByteBuffer(ByteBuffer buffer, int writeIndex) {
        super(buffer.remaining());
        this.buffer = buffer.slice();
        this.setIndex(0, writeIndex);
    }

    @Override
    public ByteBuffer unwrap() {
        return this.buffer;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] getArray() {
        return this.buffer.array();
    }

    @Override
    public int getArrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public int capacity() {
        return this.buffer.remaining();
    }

    @Override
    public ProtonBuffer capacity(int newCapacity) {
        if (newCapacity < 0) {
            throw new IllegalArgumentException("Cannot alter a buffer's capacity to a negative value: " + newCapacity);
        }
        throw new UnsupportedOperationException("NIO Buffer wrapper cannot adjust capacity");
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.get(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer destination, int destinationIndex, int length) {
        this.checkDestinationIndex(index, length, destinationIndex, destination.capacity());
        if (this.hasArray()) {
            destination.setBytes(destinationIndex, this.getArray(), this.getArrayOffset() + index, length);
        } else if (destination.hasArray()) {
            int position = this.buffer.position();
            this.buffer.position(index);
            this.buffer.get(destination.getArray(), destination.getArrayOffset() + destinationIndex, length);
            this.buffer.position(position);
        } else {
            while (length-- > 0) {
                destination.setByte(destinationIndex++, this.buffer.get(index++));
            }
        }
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, byte[] destination, int offset, int length) {
        this.checkDestinationIndex(index, length, offset, destination.length);
        if (this.hasArray()) {
            System.arraycopy(this.getArray(), this.getArrayOffset() + index, destination, offset, length);
        } else {
            int position = this.buffer.position();
            this.buffer.position(index);
            this.buffer.get(destination, offset, length);
            this.buffer.position(position);
        }
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ByteBuffer destination) {
        this.checkIndex(index, destination.remaining());
        if (destination.hasArray()) {
            int position = this.buffer.position();
            this.buffer.position(index);
            this.buffer.get(destination.array(), destination.arrayOffset() + destination.position(), destination.remaining());
            this.buffer.position(position);
            destination.position(destination.limit());
        } else if (this.hasArray()) {
            destination.put(this.getArray(), this.getArrayOffset() + index, destination.remaining());
        } else {
            while (destination.hasRemaining()) {
                destination.put(this.getByte(index++));
            }
        }
        return this;
    }

    @Override
    public ProtonBuffer setByte(int index, int value) {
        this.buffer.put(index, (byte)value);
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, int value) {
        this.buffer.putShort(index, (short)value);
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        this.buffer.putInt(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        this.buffer.putLong(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer source, int sourceIndex, int length) {
        this.checkSourceIndex(index, length, sourceIndex, source.capacity());
        if (source.hasArray()) {
            int position = this.buffer.position();
            this.buffer.position(index);
            this.buffer.put(source.getArray(), source.getArrayOffset() + sourceIndex, length);
            this.buffer.position(position);
        } else if (this.hasArray()) {
            source.getBytes(sourceIndex, this.getArray(), this.getArrayOffset() + index, length);
        } else {
            while (length-- > 0) {
                this.buffer.put(index++, source.getByte(sourceIndex++));
            }
        }
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, byte[] source, int sourceIndex, int length) {
        this.checkSourceIndex(index, length, sourceIndex, source.length);
        int position = this.buffer.position();
        this.buffer.position(index);
        this.buffer.put(source, sourceIndex, length);
        this.buffer.position(position);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ByteBuffer source) {
        this.checkSourceIndex(index, source.remaining(), source.position(), source.capacity());
        int position = this.buffer.position();
        this.buffer.position(index);
        this.buffer.put(source);
        this.buffer.position(position);
        return this;
    }

    @Override
    public ProtonBuffer copy(int index, int length) {
        ProtonByteBuffer buffer = new ProtonByteBuffer(length);
        this.getBytes(index, buffer, length);
        return buffer;
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        this.checkIndex(index, length);
        int position = this.buffer.position();
        int limit = this.buffer.limit();
        this.buffer.position(index);
        this.buffer.limit(index + length);
        ByteBuffer result = this.buffer.slice();
        this.buffer.limit(limit);
        this.buffer.position(position);
        return result;
    }
}

