/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.engine.DeliveryTagGenerator;
import org.apache.qpid.protonj2.engine.EventHandler;
import org.apache.qpid.protonj2.engine.OutgoingDelivery;
import org.apache.qpid.protonj2.engine.Sender;
import org.apache.qpid.protonj2.engine.impl.ProtonIncomingDelivery;
import org.apache.qpid.protonj2.engine.impl.ProtonLink;
import org.apache.qpid.protonj2.engine.impl.ProtonLinkCreditState;
import org.apache.qpid.protonj2.engine.impl.ProtonOutgoingDelivery;
import org.apache.qpid.protonj2.engine.impl.ProtonSession;
import org.apache.qpid.protonj2.engine.impl.ProtonSessionOutgoingWindow;
import org.apache.qpid.protonj2.engine.util.DeliveryIdTracker;
import org.apache.qpid.protonj2.engine.util.LinkedSplayMap;
import org.apache.qpid.protonj2.engine.util.SplayMap;
import org.apache.qpid.protonj2.types.UnsignedInteger;
import org.apache.qpid.protonj2.types.transport.Attach;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.apache.qpid.protonj2.types.transport.Detach;
import org.apache.qpid.protonj2.types.transport.Disposition;
import org.apache.qpid.protonj2.types.transport.Flow;
import org.apache.qpid.protonj2.types.transport.Role;
import org.apache.qpid.protonj2.types.transport.Transfer;

public class ProtonSender
extends ProtonLink<Sender>
implements Sender {
    private final ProtonSessionOutgoingWindow sessionWindow;
    private final DeliveryIdTracker currentDeliveryId = new DeliveryIdTracker();
    private final SplayMap<ProtonOutgoingDelivery> unsettled = new LinkedSplayMap<ProtonOutgoingDelivery>();
    private EventHandler<OutgoingDelivery> deliveryUpdatedEventHandler = null;
    private EventHandler<Sender> linkCreditUpdatedHandler = null;
    private boolean sendable;
    private DeliveryTagGenerator autoTagGenerator;
    private OutgoingDelivery current;

    public ProtonSender(ProtonSession session, String name) {
        super(session, name, new ProtonLinkCreditState(0));
        this.sessionWindow = session.getOutgoingWindow();
    }

    @Override
    public Role getRole() {
        return Role.SENDER;
    }

    @Override
    protected ProtonSender self() {
        return this;
    }

    @Override
    public int getCredit() {
        return this.getCreditState().getCredit();
    }

    @Override
    public boolean isSendable() {
        return this.sendable && this.sessionWindow.isSendable();
    }

    @Override
    public boolean isDraining() {
        return this.getCreditState().isDrain();
    }

    @Override
    public Sender drained() {
        this.checkLinkOperable("Cannot report link drained.");
        ProtonLinkCreditState state = this.getCreditState();
        if (state.isDrain() && state.hasCredit()) {
            int drained = state.getCredit();
            state.clearCredit();
            state.incrementDeliveryCount(drained);
            this.session.writeFlow(this);
            state.clearDrain();
        }
        return this;
    }

    @Override
    public Sender disposition(Predicate<OutgoingDelivery> filter, DeliveryState state, boolean settle) {
        this.checkLinkOperable("Cannot apply disposition");
        Objects.requireNonNull(filter, "Supplied filter cannot be null");
        List toRemove = settle ? new ArrayList() : Collections.EMPTY_LIST;
        this.unsettled.forEach((deliveryId, delivery) -> {
            if (filter.test((OutgoingDelivery)delivery)) {
                if (state != null) {
                    delivery.localState(state);
                }
                if (settle) {
                    delivery.locallySettled();
                    toRemove.add(deliveryId);
                }
                this.sessionWindow.processDisposition(this, (ProtonOutgoingDelivery)delivery);
            }
        });
        if (!toRemove.isEmpty()) {
            toRemove.forEach(deliveryId -> this.unsettled.remove((UnsignedInteger)deliveryId));
        }
        return this;
    }

    @Override
    public Sender settle(Predicate<OutgoingDelivery> filter) {
        this.disposition(filter, null, true);
        return this;
    }

    @Override
    public OutgoingDelivery current() {
        return this.current;
    }

    @Override
    public OutgoingDelivery next() {
        this.checkLinkOperable("Cannot update next delivery");
        if (this.current != null) {
            throw new IllegalStateException("Current delivery is not complete and cannot be advanced.");
        }
        this.current = new ProtonOutgoingDelivery(this);
        if (this.autoTagGenerator != null) {
            this.current.setTag(this.autoTagGenerator.nextTag());
        }
        return this.current;
    }

    @Override
    public Collection<OutgoingDelivery> unsettled() {
        if (this.unsettled.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(new ArrayList<ProtonOutgoingDelivery>(this.unsettled.values()));
    }

    @Override
    public boolean hasUnsettled() {
        return !this.unsettled.isEmpty();
    }

    @Override
    public Sender setDeliveryTagGenerator(DeliveryTagGenerator generator) {
        this.autoTagGenerator = generator;
        return this;
    }

    @Override
    public DeliveryTagGenerator getDeliveryTagGenerator() {
        return this.autoTagGenerator;
    }

    @Override
    protected final ProtonSender handleRemoteAttach(Attach attach) {
        return this;
    }

    @Override
    protected final ProtonSender handleRemoteDetach(Detach detach) {
        return this;
    }

    @Override
    protected final ProtonSender handleRemoteDisposition(Disposition disposition, ProtonIncomingDelivery delivery) {
        throw new IllegalStateException("Sender link should never handle disposition for incoming deliveries");
    }

    @Override
    protected final ProtonSender handleRemoteDisposition(Disposition disposition, ProtonOutgoingDelivery delivery) {
        boolean updated = false;
        if (disposition.getState() != null && !disposition.getState().equals(delivery.getRemoteState())) {
            updated = true;
            delivery.remoteState(disposition.getState());
        }
        if (disposition.getSettled() && !delivery.isRemotelySettled()) {
            updated = true;
            delivery.remotelySettled();
        }
        if (updated) {
            delivery.getLink().signalDeliveryStateUpdated(delivery);
        }
        return this;
    }

    @Override
    protected final ProtonIncomingDelivery handleRemoteTransfer(Transfer transfer, ProtonBuffer payload) {
        throw new IllegalArgumentException("Sender end cannot process incoming transfers");
    }

    @Override
    protected final ProtonSender handleRemoteFlow(Flow flow) {
        ProtonLinkCreditState creditState = this.getCreditState();
        creditState.remoteFlow(flow);
        int existingDeliveryCount = creditState.getDeliveryCount();
        int remoteDeliveryCount = (int)flow.getDeliveryCount();
        int newDeliveryCountLimit = remoteDeliveryCount + (int)flow.getLinkCredit();
        long effectiveCredit = 0xFFFFFFFFL & (long)(newDeliveryCountLimit - existingDeliveryCount);
        if (effectiveCredit > 0L) {
            creditState.updateCredit((int)effectiveCredit);
        } else {
            creditState.updateCredit(0);
        }
        if (this.isLocallyOpen()) {
            this.sendable = this.getCredit() > 0 && this.sessionWindow.isSendable();
            this.signalLinkCreditStateUpdated();
        }
        return this;
    }

    ProtonSender handleSessionCreditStateUpdate(ProtonSessionOutgoingWindow protonSessionOutgoingWindow) {
        boolean previousSendable = this.sendable;
        boolean bl = this.sendable = this.getCredit() > 0 && this.sessionWindow.isSendable();
        if (previousSendable != this.sendable) {
            this.signalLinkCreditStateUpdated();
        }
        return this;
    }

    @Override
    protected final ProtonSender decorateOutgoingFlow(Flow flow) {
        flow.setLinkCredit(this.getCredit());
        flow.setHandle(this.getHandle());
        flow.setDeliveryCount(this.getCreditState().getDeliveryCount());
        flow.setDrain(this.isDraining());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ProtonOutgoingDelivery delivery, ProtonBuffer buffer, boolean complete) {
        this.checkLinkOperable("Cannot send when link has become inoperable");
        if (this.isSendable()) {
            if (this.currentDeliveryId.isEmpty()) {
                this.currentDeliveryId.set(this.sessionWindow.getAndIncrementNextDeliveryId());
                delivery.setDeliveryId(this.currentDeliveryId.longValue());
            }
            if (!delivery.isSettled()) {
                this.unsettled.put((int)delivery.getDeliveryId(), delivery);
            }
            try {
                this.sendable = this.sessionWindow.processSend(this, delivery, buffer, complete) && this.getCredit() > 0;
            }
            finally {
                if (complete && (buffer == null || !buffer.isReadable())) {
                    delivery.markComplete();
                    this.currentDeliveryId.reset();
                    this.current = null;
                    this.getCreditState().incrementDeliveryCount();
                    this.getCreditState().decrementCredit();
                    if (this.getCredit() == 0) {
                        this.sendable = false;
                        this.getCreditState().clearDrain();
                    }
                }
            }
        }
    }

    void disposition(ProtonOutgoingDelivery delivery) {
        if (!delivery.isRemotelySettled()) {
            this.checkLinkOperable("Cannot set a disposition");
        }
        try {
            this.sessionWindow.processDisposition(this, delivery);
        }
        finally {
            if (delivery.isSettled()) {
                this.unsettled.remove((int)delivery.getDeliveryId());
            }
        }
    }

    void abort(ProtonOutgoingDelivery delivery) {
        this.checkLinkOperable("Cannot abort Transfer");
        try {
            if (delivery.getTransferCount() > 0) {
                this.sessionWindow.processAbort(this, delivery);
            }
        }
        finally {
            this.unsettled.remove((int)delivery.getDeliveryId());
            this.currentDeliveryId.reset();
            this.current = null;
        }
    }

    @Override
    public Sender creditStateUpdateHandler(EventHandler<Sender> handler) {
        this.linkCreditUpdatedHandler = handler;
        return this;
    }

    Sender signalLinkCreditStateUpdated() {
        if (this.linkCreditUpdatedHandler != null) {
            this.linkCreditUpdatedHandler.handle(this);
        }
        return this;
    }

    @Override
    public Sender deliveryStateUpdatedHandler(EventHandler<OutgoingDelivery> handler) {
        this.deliveryUpdatedEventHandler = handler;
        return this;
    }

    Sender signalDeliveryStateUpdated(ProtonOutgoingDelivery delivery) {
        if (delivery.deliveryStateUpdatedHandler() != null) {
            delivery.deliveryStateUpdatedHandler().handle(delivery);
        } else if (this.deliveryUpdatedEventHandler != null) {
            this.deliveryUpdatedEventHandler.handle(delivery);
        }
        return this;
    }

    @Override
    protected void transitionedToLocallyOpened() {
        this.localAttach.setInitialDeliveryCount(this.currentDeliveryId.longValue());
        this.sendable = this.getCredit() > 0 && this.sessionWindow.isSendable();
    }

    @Override
    protected void transitionedToLocallyDetached() {
        this.sendable = false;
    }

    @Override
    protected void transitionedToLocallyClosed() {
        this.sendable = false;
    }

    @Override
    protected void transitionToRemotelyDetached() {
        this.sendable = false;
    }

    @Override
    protected void transitionToRemotelyClosed() {
        this.sendable = false;
    }

    @Override
    protected void transitionToParentLocallyClosed() {
        this.sendable = false;
    }

    @Override
    protected void transitionToParentRemotelyClosed() {
        this.sendable = false;
    }
}

