/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Accepted;
import org.apache.qpid.protonj2.types.messaging.Released;
import org.apache.qpid.protonj2.types.transport.Disposition;

public final class DispositionTypeEncoder
extends AbstractDescribedListTypeEncoder<Disposition> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Disposition.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Disposition.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Disposition> getTypeClass() {
        return Disposition.class;
    }

    @Override
    public void writeElement(Disposition disposition, int index, ProtonBuffer buffer, EncoderState state) {
        switch (index) {
            case 0: {
                if (disposition.hasRole()) {
                    buffer.writeByte(disposition.getRole().getValue() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 1: {
                if (disposition.hasFirst()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, disposition.getFirst());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 2: {
                if (disposition.hasLast()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, disposition.getLast());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 3: {
                if (disposition.hasSettled()) {
                    buffer.writeByte(disposition.getSettled() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 4: {
                if (disposition.hasState()) {
                    if (disposition.getState() == Accepted.getInstance()) {
                        buffer.writeByte(0);
                        buffer.writeByte(83);
                        buffer.writeByte(Accepted.DESCRIPTOR_CODE.byteValue());
                        buffer.writeByte(69);
                        break;
                    }
                    state.getEncoder().writeObject(buffer, state, disposition.getState());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 5: {
                if (disposition.hasBatchable()) {
                    buffer.writeByte(disposition.getBatchable() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Disposition value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Disposition value) {
        if (value.getState() == null) {
            return -64;
        }
        if (value.getState() == Accepted.getInstance() || value.getState() == Released.getInstance()) {
            return -64;
        }
        return -48;
    }

    @Override
    public int getElementCount(Disposition disposition) {
        return disposition.getElementCount();
    }

    @Override
    public int getMinElementCount() {
        return 2;
    }
}

