/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import java.util.Map;
import java.util.Set;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncodeException;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.TypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class MapTypeEncoder
extends AbstractPrimitiveTypeEncoder<Map> {
    @Override
    public Class<Map> getTypeClass() {
        return Map.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Map value) {
        buffer.writeByte(-47);
        this.writeValue(buffer, state, value);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-47);
        for (Object value : values) {
            this.writeValue(buffer, state, (Map)value);
        }
    }

    private void writeValue(ProtonBuffer buffer, EncoderState state, Map value) {
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(value.size() * 2);
        Set entries = value.entrySet();
        for (Map.Entry entry : entries) {
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            TypeEncoder<?> keyEncoder = state.getEncoder().getTypeEncoder(entryKey);
            if (keyEncoder == null) {
                throw new EncodeException("Cannot find encoder for type " + entryKey);
            }
            keyEncoder.writeType(buffer, state, entryKey);
            TypeEncoder<?> valueEncoder = state.getEncoder().getTypeEncoder(entryValue);
            if (valueEncoder == null) {
                throw new EncodeException("Cannot find encoder for type " + entryValue);
            }
            valueEncoder.writeType(buffer, state, entryValue);
        }
        int endIndex = buffer.getWriteIndex();
        buffer.setInt(startIndex, endIndex - startIndex - 4);
    }
}

