/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class CharacterTypeEncoder
extends AbstractPrimitiveTypeEncoder<Character> {
    @Override
    public Class<Character> getTypeClass() {
        return Character.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Character value) {
        buffer.writeByte(115);
        buffer.writeInt(value.charValue() & 0xFFFF);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(115);
        for (Object charValue : values) {
            buffer.writeInt(((Character)charValue).charValue() & 0xFFFF);
        }
    }

    public void writeRawArray(ProtonBuffer buffer, EncoderState state, char[] values) {
        buffer.writeByte(115);
        for (char charValue : values) {
            buffer.writeInt(charValue & 0xFFFF);
        }
    }

    public void writeArray(ProtonBuffer buffer, EncoderState state, char[] values) {
        if (values.length < 63) {
            this.writeAsArray8(buffer, state, values);
        } else {
            this.writeAsArray32(buffer, state, values);
        }
    }

    private void writeAsArray8(ProtonBuffer buffer, EncoderState state, char[] values) {
        buffer.writeByte(-32);
        int startIndex = buffer.getWriteIndex();
        buffer.writeByte(0);
        buffer.writeByte(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteIndex();
        long writeSize = endIndex - startIndex - 1;
        buffer.setByte(startIndex, (byte)writeSize);
    }

    private void writeAsArray32(ProtonBuffer buffer, EncoderState state, char[] values) {
        buffer.writeByte(-16);
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteIndex();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }
}

