/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.messaging;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Properties;

public final class PropertiesTypeEncoder
extends AbstractDescribedListTypeEncoder<Properties> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Properties.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Properties.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Properties> getTypeClass() {
        return Properties.class;
    }

    @Override
    public void writeElement(Properties properties, int index, ProtonBuffer buffer, EncoderState state) {
        switch (index) {
            case 0: {
                state.getEncoder().writeObject(buffer, state, properties.getMessageId());
                break;
            }
            case 1: {
                state.getEncoder().writeBinary(buffer, state, properties.getUserId());
                break;
            }
            case 2: {
                state.getEncoder().writeString(buffer, state, properties.getTo());
                break;
            }
            case 3: {
                state.getEncoder().writeString(buffer, state, properties.getSubject());
                break;
            }
            case 4: {
                state.getEncoder().writeString(buffer, state, properties.getReplyTo());
                break;
            }
            case 5: {
                state.getEncoder().writeObject(buffer, state, properties.getCorrelationId());
                break;
            }
            case 6: {
                state.getEncoder().writeSymbol(buffer, state, properties.getContentType());
                break;
            }
            case 7: {
                state.getEncoder().writeSymbol(buffer, state, properties.getContentEncoding());
                break;
            }
            case 8: {
                if (properties.hasAbsoluteExpiryTime()) {
                    state.getEncoder().writeTimestamp(buffer, state, properties.getAbsoluteExpiryTime());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 9: {
                if (properties.hasCreationTime()) {
                    state.getEncoder().writeTimestamp(buffer, state, properties.getCreationTime());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 10: {
                state.getEncoder().writeString(buffer, state, properties.getGroupId());
                break;
            }
            case 11: {
                if (properties.hasGroupSequence()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, properties.getGroupSequence());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 12: {
                state.getEncoder().writeString(buffer, state, properties.getReplyToGroupId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Properties value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Properties value) {
        return -48;
    }

    @Override
    public int getElementCount(Properties properties) {
        return properties.getElementCount();
    }
}

