/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.primitives;

import java.io.IOException;
import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.BinaryTypeDecoder;
import org.apache.qpid.protonj2.types.Binary;

public abstract class AbstractBinaryTypeDecoder
extends AbstractPrimitiveTypeDecoder<Binary>
implements BinaryTypeDecoder {
    @Override
    public Binary readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return new Binary(this.readValueAsBuffer(buffer, state));
    }

    public ProtonBuffer readValueAsBuffer(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int length = this.readSize(buffer);
        if (length > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Binary data size %d is specified to be greater than the amount of data available (%d)", length, buffer.getReadableBytes()));
        }
        ProtonByteBuffer payload = ProtonByteBufferAllocator.DEFAULT.allocate(length, length);
        buffer.readBytes(payload);
        return payload;
    }

    public byte[] readValueAsArray(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int length = this.readSize(buffer);
        if (length > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Binary data size %d is specified to be greater than the amount of data available (%d)", length, buffer.getReadableBytes()));
        }
        byte[] payload = new byte[length];
        buffer.readBytes(payload);
        return payload;
    }

    @Override
    public Binary readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return new Binary(this.readValueAsBuffer(stream, state));
    }

    public ProtonBuffer readValueAsBuffer(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonByteBufferAllocator.DEFAULT.wrap(this.readValueAsArray(stream, state));
    }

    public byte[] readValueAsArray(InputStream stream, StreamDecoderState state) throws DecodeException {
        int length = this.readSize(stream);
        byte[] payload = new byte[length];
        try {
            stream.read(payload);
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading Binary payload bytes", ex);
        }
        return payload;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int length = this.readSize(buffer);
        if (length > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Binary data size %d is specified to be greater than the amount of data available (%d)", length, buffer.getReadableBytes()));
        }
        buffer.skipBytes(length);
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        try {
            stream.skip(this.readSize(stream));
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading Binary payload bytes", ex);
        }
    }

    @Override
    public abstract int readSize(ProtonBuffer var1);

    @Override
    public abstract int readSize(InputStream var1);
}

