/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.client.AdvancedMessage;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.StreamSender;
import org.apache.qpid.protonj2.client.StreamSenderOptions;
import org.apache.qpid.protonj2.client.StreamTracker;
import org.apache.qpid.protonj2.client.Tracker;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientMessageSupport;
import org.apache.qpid.protonj2.client.impl.ClientNoOpStreamTracker;
import org.apache.qpid.protonj2.client.impl.ClientOutgoingEnvelope;
import org.apache.qpid.protonj2.client.impl.ClientSender;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.impl.ClientStreamSenderMessage;
import org.apache.qpid.protonj2.client.impl.ClientStreamTracker;
import org.apache.qpid.protonj2.engine.OutgoingDelivery;
import org.apache.qpid.protonj2.engine.Sender;
import org.apache.qpid.protonj2.engine.util.StringUtils;
import org.apache.qpid.protonj2.types.messaging.DeliveryAnnotations;

public final class ClientStreamSender
extends ClientSender
implements StreamSender {
    private final StreamSenderOptions options;

    ClientStreamSender(ClientSession session, StreamSenderOptions options, String senderId, Sender protonSender) {
        super(session, options, senderId, protonSender);
        this.options = new StreamSenderOptions(options);
    }

    @Override
    public StreamTracker send(Message<?> message) throws ClientException {
        this.checkClosedOrFailed();
        return (StreamTracker)this.sendMessage(ClientMessageSupport.convertMessage(message), null, true);
    }

    @Override
    public StreamTracker send(Message<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        return (StreamTracker)this.sendMessage(ClientMessageSupport.convertMessage(message), null, true);
    }

    @Override
    public StreamTracker trySend(Message<?> message) throws ClientException {
        this.checkClosedOrFailed();
        return (StreamTracker)this.sendMessage(ClientMessageSupport.convertMessage(message), null, false);
    }

    @Override
    public StreamTracker trySend(Message<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        return (StreamTracker)this.sendMessage(ClientMessageSupport.convertMessage(message), null, false);
    }

    @Override
    public ClientStreamSenderMessage beginMessage() throws ClientException {
        return this.beginMessage((Map)null);
    }

    @Override
    public ClientStreamSenderMessage beginMessage(Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture request = this.session.getFutureFactory().createFuture();
        DeliveryAnnotations annotations = deliveryAnnotations != null ? new DeliveryAnnotations(StringUtils.toSymbolKeyedMap(deliveryAnnotations)) : null;
        this.executor.execute(() -> {
            if (this.protonSender.current() != null) {
                request.failed(new ClientIllegalStateException("Cannot initiate a new streaming send until the previous one is complete"));
            } else {
                OutgoingDelivery streamDelivery = this.protonSender.next();
                ClientStreamTracker streamTracker = this.createTracker(streamDelivery);
                streamDelivery.setLinkedResource((Object)streamTracker);
                request.complete(new ClientStreamSenderMessage(this, streamTracker, annotations));
            }
        });
        return (ClientStreamSenderMessage)this.session.request(this, request);
    }

    @Override
    StreamSenderOptions options() {
        return this.options;
    }

    @Override
    ClientStreamSender open() {
        return (ClientStreamSender)super.open();
    }

    StreamTracker sendMessage(ClientStreamSenderMessage context, AdvancedMessage<?> message) throws ClientException {
        ClientFuture<Tracker> operation = this.session.getFutureFactory().createFuture();
        ProtonBuffer buffer = message.encode(null);
        ClientOutgoingEnvelope envelope = new ClientOutgoingEnvelope(this, context.getProtonDelivery(), message.messageFormat(), buffer, context.completed(), operation);
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(operation)) {
                try {
                    if (this.protonSender.isSendable()) {
                        this.session.getTransactionContext().send(envelope, null, this.isSendingSettled());
                    } else {
                        this.addToHeadOfBlockedQueue(envelope);
                    }
                }
                catch (Exception error) {
                    operation.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
            }
        });
        return (StreamTracker)this.session.request(this, operation);
    }

    @Override
    protected ClientStreamTracker createTracker(OutgoingDelivery delivery) {
        return new ClientStreamTracker(this, delivery);
    }

    @Override
    protected ClientNoOpStreamTracker createNoOpTracker() {
        return new ClientNoOpStreamTracker(this);
    }
}

