/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.client.Tracker;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientSendTimedOutException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientSender;
import org.apache.qpid.protonj2.client.impl.ClientTracker;
import org.apache.qpid.protonj2.engine.OutgoingDelivery;
import org.apache.qpid.protonj2.types.transport.DeliveryState;

public class ClientOutgoingEnvelope {
    private final ProtonBuffer payload;
    private final ClientFuture<Tracker> request;
    private final ClientSender sender;
    private final boolean complete;
    private final int messageFormat;
    private boolean aborted;
    private ScheduledFuture<?> sendTimeout;
    private OutgoingDelivery delivery;

    ClientOutgoingEnvelope(ClientSender sender, int messageFormat, ProtonBuffer payload, ClientFuture<Tracker> request) {
        this.messageFormat = messageFormat;
        this.payload = payload;
        this.request = request;
        this.sender = sender;
        this.complete = true;
    }

    ClientOutgoingEnvelope(ClientSender sender, int messageFormat, ProtonBuffer payload, boolean complete, ClientFuture<Tracker> request) {
        this.payload = payload;
        this.request = request;
        this.sender = sender;
        this.complete = complete;
        this.messageFormat = messageFormat;
    }

    public ClientOutgoingEnvelope(ClientSender sender, OutgoingDelivery delivery, int messageFormat, ProtonBuffer payload, boolean complete, ClientFuture<Tracker> request) {
        this.payload = payload;
        this.request = request;
        this.sender = sender;
        this.complete = complete;
        this.messageFormat = messageFormat;
        this.delivery = delivery;
    }

    public ScheduledFuture<?> sendTimeout() {
        return this.sendTimeout;
    }

    public void sendTimeout(ScheduledFuture<?> sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public ProtonBuffer payload() {
        return this.payload;
    }

    public OutgoingDelivery delivery() {
        return this.delivery;
    }

    public ClientOutgoingEnvelope abort() {
        this.aborted = true;
        return this;
    }

    public ClientSender sender() {
        return this.sender;
    }

    public boolean aborted() {
        return this.aborted;
    }

    public ClientOutgoingEnvelope discard() {
        if (this.sendTimeout != null) {
            this.sendTimeout.cancel(true);
            this.sendTimeout = null;
        }
        if (this.delivery != null) {
            ClientTracker tracker = (ClientTracker)this.delivery.getLinkedResource();
            if (tracker != null) {
                ((ClientFuture)tracker.settlementFuture()).complete(tracker);
            }
            this.request.complete((Tracker)this.delivery.getLinkedResource());
        } else {
            this.request.complete(this.sender.createNoOpTracker());
        }
        return this;
    }

    public ClientOutgoingEnvelope succeeded() {
        if (this.sendTimeout != null) {
            this.sendTimeout.cancel(true);
        }
        this.request.complete((Tracker)this.delivery.getLinkedResource());
        return this;
    }

    public ClientOutgoingEnvelope failed(ClientException exception) {
        if (this.sendTimeout != null) {
            this.sendTimeout.cancel(true);
        }
        this.request.failed(exception);
        return this;
    }

    public void sendPayload(DeliveryState state, boolean settled) {
        if (this.delivery == null) {
            this.delivery = this.sender.getProtonSender().next();
            this.delivery.setLinkedResource((Object)this.sender.createTracker(this.delivery));
        }
        if (this.delivery.getTransferCount() == 0) {
            this.delivery.setMessageFormat(this.messageFormat);
            this.delivery.disposition(state, settled);
        }
        if (this.aborted()) {
            this.delivery.abort();
            this.succeeded();
        } else {
            this.sender.connection().autoFlushOff();
            try {
                this.delivery.streamBytes(this.payload, this.complete);
                if (this.payload != null && this.payload.isReadable()) {
                    this.sender.addToHeadOfBlockedQueue(this);
                } else {
                    this.succeeded();
                }
                this.sender.connection().flush();
            }
            finally {
                this.sender.connection().autoFlushOn();
            }
        }
    }

    public ClientException createSendTimedOutException() {
        return new ClientSendTimedOutException("Timed out waiting for credit to send");
    }
}

