/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.protonj2.client.Session;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.exceptions.ClientTransactionDeclarationException;
import org.apache.qpid.protonj2.client.exceptions.ClientTransactionNotActiveException;
import org.apache.qpid.protonj2.client.exceptions.ClientTransactionRolledBackException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientOutgoingEnvelope;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.impl.ClientTransactionContext;
import org.apache.qpid.protonj2.engine.Engine;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.engine.Transaction;
import org.apache.qpid.protonj2.engine.TransactionController;
import org.apache.qpid.protonj2.engine.TransactionState;
import org.apache.qpid.protonj2.engine.exceptions.EngineFailedException;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.messaging.Accepted;
import org.apache.qpid.protonj2.types.messaging.Modified;
import org.apache.qpid.protonj2.types.messaging.Outcome;
import org.apache.qpid.protonj2.types.messaging.Rejected;
import org.apache.qpid.protonj2.types.messaging.Released;
import org.apache.qpid.protonj2.types.messaging.Source;
import org.apache.qpid.protonj2.types.transactions.Coordinator;
import org.apache.qpid.protonj2.types.transactions.TransactionalState;
import org.apache.qpid.protonj2.types.transactions.TxnCapability;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientLocalTransactionContext
implements ClientTransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(ClientLocalTransactionContext.class);
    private static final Symbol[] SUPPORTED_OUTCOMES = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
    private final String DECLARE_FUTURE_NAME = "Declare:Future";
    private final String DISCHARGE_FUTURE_NAME = "Discharge:Future";
    private final String START_TRANSACTION_MARKER = "Transaction:Start";
    private final AtomicInteger coordinatorCounter = new AtomicInteger();
    private final ClientSession session;
    private Transaction<TransactionController> currentTxn;
    private TransactionController txnController;
    private TransactionalState cachedSenderOutcome;
    private TransactionalState cachedReceiverOutcome;

    ClientLocalTransactionContext(ClientSession session) {
        this.session = session;
    }

    @Override
    public ClientLocalTransactionContext begin(ClientFuture<Session> beginFuture) throws ClientIllegalStateException {
        this.checkCanBeginNewTransaction();
        this.beginNewTransaction(beginFuture);
        return this;
    }

    @Override
    public ClientLocalTransactionContext commit(ClientFuture<Session> commitFuture, boolean startNew) throws ClientIllegalStateException {
        this.checkCanCommitTransaction();
        if (this.txnController.isLocallyOpen()) {
            this.currentTxn.getAttachments().set("Discharge:Future", commitFuture);
            this.currentTxn.getAttachments().set("Transaction:Start", (Object)startNew);
            if (this.session.options().requestTimeout() > 0L) {
                this.session.scheduleRequestTimeout(commitFuture, this.session.options().requestTimeout(), () -> {
                    try {
                        this.txnController.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new ClientTransactionRolledBackException("Timed out waiting for Transaction commit to complete");
                });
            }
            this.txnController.addCapacityAvailableHandler(controller -> {
                try {
                    this.txnController.discharge(this.currentTxn, false);
                }
                catch (EngineFailedException efe) {
                    commitFuture.failed(ClientExceptionSupport.createOrPassthroughFatal(efe));
                }
            });
        } else {
            this.currentTxn = null;
            commitFuture.failed(this.createRolledBackErrorFromClosedCoordinator());
        }
        return this;
    }

    @Override
    public ClientLocalTransactionContext rollback(ClientFuture<Session> rollbackFuture, boolean startNew) throws ClientIllegalStateException {
        this.checkCanRollbackTransaction();
        if (this.txnController.isLocallyOpen()) {
            this.currentTxn.getAttachments().set("Discharge:Future", rollbackFuture);
            this.currentTxn.getAttachments().set("Transaction:Start", (Object)startNew);
            if (this.session.options().requestTimeout() > 0L) {
                this.session.scheduleRequestTimeout(rollbackFuture, this.session.options().requestTimeout(), () -> {
                    try {
                        this.txnController.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new ClientOperationTimedOutException("Timed out waiting for Transaction rollback to complete");
                });
            }
            this.txnController.addCapacityAvailableHandler(controller -> {
                try {
                    this.txnController.discharge(this.currentTxn, true);
                }
                catch (EngineFailedException efe) {
                    rollbackFuture.complete(this.session);
                }
                catch (Throwable efe) {
                    rollbackFuture.failed(ClientExceptionSupport.createOrPassthroughFatal(efe));
                }
            });
        } else {
            this.currentTxn = null;
            rollbackFuture.complete(this.session);
        }
        return this;
    }

    @Override
    public boolean isInTransaction() {
        return this.currentTxn != null && this.currentTxn.getState() == TransactionState.DECLARED;
    }

    @Override
    public boolean isRollbackOnly() {
        if (this.isInTransaction()) {
            return this.txnController.isLocallyClosed();
        }
        return false;
    }

    @Override
    public ClientTransactionContext send(ClientOutgoingEnvelope envelope, DeliveryState outcome, boolean settled) {
        if (this.isInTransaction()) {
            if (this.isRollbackOnly()) {
                envelope.discard();
            } else if (outcome == null) {
                TransactionalState txnOutcome = this.cachedSenderOutcome != null ? this.cachedSenderOutcome : (this.cachedSenderOutcome = new TransactionalState().setTxnId(this.currentTxn.getTxnId()));
                envelope.sendPayload((DeliveryState)txnOutcome, settled);
            } else {
                envelope.sendPayload((DeliveryState)new TransactionalState().setTxnId(this.currentTxn.getTxnId()).setOutcome((Outcome)outcome), settled);
            }
        } else {
            envelope.sendPayload(outcome, settled);
        }
        return this;
    }

    @Override
    public ClientTransactionContext disposition(IncomingDelivery delivery, DeliveryState outcome, boolean settled) {
        if (this.isInTransaction()) {
            TransactionalState txnOutcome = outcome instanceof Accepted ? (this.cachedReceiverOutcome != null ? this.cachedReceiverOutcome : (this.cachedReceiverOutcome = new TransactionalState().setTxnId(this.currentTxn.getTxnId()).setOutcome((Outcome)Accepted.getInstance()))) : new TransactionalState().setTxnId(this.currentTxn.getTxnId()).setOutcome((Outcome)outcome);
            delivery.disposition((DeliveryState)txnOutcome, true);
        } else {
            delivery.disposition(outcome, settled);
        }
        return this;
    }

    private void beginNewTransaction(ClientFuture<Session> beginFuture) {
        TransactionController txnController = this.getOrCreateNewTxnController();
        this.currentTxn = txnController.newTransaction();
        this.currentTxn.setLinkedResource((Object)this);
        this.currentTxn.getAttachments().set("Declare:Future", beginFuture);
        this.cachedReceiverOutcome = null;
        this.cachedSenderOutcome = null;
        if (this.session.options().requestTimeout() > 0L) {
            this.session.scheduleRequestTimeout(beginFuture, this.session.options().requestTimeout(), () -> {
                try {
                    txnController.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return new ClientTransactionDeclarationException("Timed out waiting for Transaction declaration to complete");
            });
        }
        txnController.addCapacityAvailableHandler(controller -> {
            try {
                txnController.declare(this.currentTxn);
            }
            catch (EngineFailedException efe) {
                beginFuture.failed(ClientExceptionSupport.createOrPassthroughFatal(efe));
            }
        });
    }

    private TransactionController getOrCreateNewTxnController() {
        if (this.txnController == null || this.txnController.isLocallyClosed()) {
            Coordinator coordinator = new Coordinator();
            coordinator.setCapabilities(new Symbol[]{TxnCapability.LOCAL_TXN});
            Source source = new Source();
            source.setOutcomes(Arrays.copyOf(SUPPORTED_OUTCOMES, SUPPORTED_OUTCOMES.length));
            TransactionController txnController = this.session.getProtonSession().coordinator(this.nextCoordinatorId());
            ((TransactionController)((TransactionController)((TransactionController)((TransactionController)txnController.setSource(source).setCoordinator(coordinator).declaredHandler(this::handleTransactionDeclared).declareFailureHandler(this::handleTransactionDeclareFailed).dischargedHandler(this::handleTransactionDischarged).dischargeFailureHandler(this::handleTransactionDischargeFailed).openHandler(this::handleCoordinatorOpen)).closeHandler(this::handleCoordinatorClose)).localCloseHandler(this::handleCoordinatorLocalClose)).parentEndpointClosedHandler(this::handleParentEndpointClosed).engineShutdownHandler(this::handleEngineShutdown)).open();
            this.txnController = txnController;
        }
        return this.txnController;
    }

    private void checkCanBeginNewTransaction() throws ClientIllegalStateException {
        if (this.currentTxn != null) {
            switch (this.currentTxn.getState()) {
                case DISCHARGED: 
                case DISCHARGE_FAILED: 
                case DECLARE_FAILED: {
                    break;
                }
                case DECLARING: {
                    throw new ClientIllegalStateException("A transaction is already in the process of being started");
                }
                case DECLARED: {
                    throw new ClientIllegalStateException("A transaction is already active in this Session");
                }
                case DISCHARGING: {
                    throw new ClientIllegalStateException("A transaction is still being retired and a new one cannot yet be started");
                }
                default: {
                    throw new ClientIllegalStateException("Cannot begin a new transaction until the existing transaction completes");
                }
            }
        }
    }

    private void checkCanCommitTransaction() throws ClientIllegalStateException {
        if (this.currentTxn == null) {
            throw new ClientTransactionNotActiveException("Commit called with no active transaction");
        }
        switch (this.currentTxn.getState()) {
            case DISCHARGED: {
                throw new ClientTransactionNotActiveException("Commit called with no active transaction");
            }
            case DECLARING: {
                throw new ClientIllegalStateException("Commit called before transaction declare completed.");
            }
            case DISCHARGING: {
                throw new ClientIllegalStateException("Commit called before transaction discharge completed.");
            }
            case DECLARE_FAILED: {
                throw new ClientTransactionNotActiveException("Commit called on a transaction that has failed due to an error during declare.");
            }
            case DISCHARGE_FAILED: {
                throw new ClientTransactionNotActiveException("Commit called on a transaction that has failed due to an error during discharge.");
            }
            case IDLE: {
                throw new ClientTransactionNotActiveException("Commit called on a transaction that has not yet been declared");
            }
        }
    }

    private void checkCanRollbackTransaction() throws ClientIllegalStateException {
        if (this.currentTxn == null) {
            throw new ClientTransactionNotActiveException("Rollback called with no active transaction");
        }
        switch (this.currentTxn.getState()) {
            case DISCHARGED: {
                throw new ClientTransactionNotActiveException("Rollback called with no active transaction");
            }
            case DECLARING: {
                throw new ClientIllegalStateException("Rollback called before transaction declare completed.");
            }
            case DISCHARGING: {
                throw new ClientIllegalStateException("Rollback called before transaction discharge completed.");
            }
            case DECLARE_FAILED: {
                throw new ClientTransactionNotActiveException("Rollback called on a transaction that has failed due to an error during declare.");
            }
            case DISCHARGE_FAILED: {
                throw new ClientTransactionNotActiveException("Rollback called on a transaction that has failed due to an error during discharge.");
            }
            case IDLE: {
                throw new ClientTransactionNotActiveException("Rollback called on a transaction that has not yet been declared");
            }
        }
    }

    private void handleTransactionDeclared(Transaction<TransactionController> transaction) {
        ClientFuture future = (ClientFuture)transaction.getAttachments().get("Declare:Future");
        LOG.trace("Declare of transaction:{} completed", transaction);
        if (future.isComplete() || future.isCancelled()) {
            try {
                this.rollback(this.session.getFutureFactory().createFuture(), false);
            }
            catch (Exception exception) {}
        } else {
            future.complete(this.session);
        }
    }

    private void handleTransactionDeclareFailed(Transaction<TransactionController> transaction) {
        ClientFuture future = (ClientFuture)transaction.getAttachments().get("Declare:Future");
        LOG.trace("Declare of transaction:{} failed", transaction);
        ClientException cause = ClientExceptionSupport.convertToNonFatalException(transaction.getCondition());
        future.failed(new ClientTransactionDeclarationException(cause.getMessage(), cause));
    }

    private void handleTransactionDischarged(Transaction<TransactionController> transaction) {
        ClientFuture future = (ClientFuture)transaction.getAttachments().get("Discharge:Future");
        LOG.trace("Discharge of transaction:{} completed", transaction);
        future.complete(this.session);
        if (Boolean.TRUE.equals(transaction.getAttachments().get("Transaction:Start"))) {
            this.beginNewTransaction(future);
        }
    }

    private void handleTransactionDischargeFailed(Transaction<TransactionController> transaction) {
        ClientFuture future = (ClientFuture)transaction.getAttachments().get("Discharge:Future");
        LOG.trace("Discharge of transaction:{} failed", transaction);
        ClientException cause = ClientExceptionSupport.convertToNonFatalException(transaction.getCondition());
        future.failed(new ClientTransactionRolledBackException(cause.getMessage(), cause));
    }

    private void handleCoordinatorOpen(TransactionController controller) {
        if (controller.getRemoteCoordinator() != null) {
            this.txnController = controller;
        }
    }

    private void handleCoordinatorClose(TransactionController controller) {
        if (this.txnController != null) {
            this.txnController.close();
        }
    }

    private ClientTransactionRolledBackException createRolledBackErrorFromClosedCoordinator() {
        ClientException cause = ClientExceptionSupport.convertToNonFatalException(this.txnController.getRemoteCondition());
        if (!(cause instanceof ClientTransactionRolledBackException)) {
            cause = new ClientTransactionRolledBackException(cause.getMessage(), cause);
        }
        return (ClientTransactionRolledBackException)cause;
    }

    private ClientTransactionDeclarationException createDeclarationErrorFromClosedCoordinator() {
        ClientException cause = ClientExceptionSupport.convertToNonFatalException(this.txnController.getRemoteCondition());
        if (!(cause instanceof ClientTransactionDeclarationException)) {
            cause = new ClientTransactionDeclarationException(cause.getMessage(), cause);
        }
        return (ClientTransactionDeclarationException)cause;
    }

    private void handleCoordinatorLocalClose(TransactionController controller) {
        if (this.currentTxn != null) {
            ClientFuture future = null;
            switch (this.currentTxn.getState()) {
                case DECLARING: 
                case IDLE: {
                    future = (ClientFuture)this.currentTxn.getAttachments().get("Declare:Future");
                    future.failed(this.createDeclarationErrorFromClosedCoordinator());
                    this.currentTxn = null;
                    break;
                }
                case DISCHARGING: {
                    future = (ClientFuture)this.currentTxn.getAttachments().get("Discharge:Future");
                    if (this.currentTxn.getDischargeState() == Transaction.DischargeState.COMMIT) {
                        future.failed(this.createRolledBackErrorFromClosedCoordinator());
                    } else {
                        future.complete(this.session);
                    }
                    this.currentTxn = null;
                    break;
                }
            }
        }
    }

    private String nextCoordinatorId() {
        return this.session.id() + ":" + this.coordinatorCounter.incrementAndGet();
    }

    private void handleParentEndpointClosed(TransactionController txnController) {
        txnController.close();
    }

    private void handleEngineShutdown(Engine engine) {
        if (this.txnController != null) {
            this.txnController.close();
        }
    }
}

