/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.protonj2.client.Client;
import org.apache.qpid.protonj2.client.ClientOptions;
import org.apache.qpid.protonj2.client.Connection;
import org.apache.qpid.protonj2.client.ConnectionOptions;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientFutureFactory;
import org.apache.qpid.protonj2.client.impl.ClientConnection;
import org.apache.qpid.protonj2.client.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientInstance
implements Client {
    private static final Logger LOG = LoggerFactory.getLogger(ClientInstance.class);
    private static final IdGenerator CONTAINER_ID_GENERATOR = new IdGenerator();
    private static final ClientFutureFactory FUTURES = ClientFutureFactory.create("conservative");
    private final AtomicInteger CONNECTION_COUNTER = new AtomicInteger();
    private final ClientOptions options;
    private final ConnectionOptions defaultConnectionOptions = new ConnectionOptions();
    private final Map<String, ClientConnection> connections = new HashMap<String, ClientConnection>();
    private final String clientUniqueId = CONTAINER_ID_GENERATOR.generateId();
    private final ClientFuture<Client> closedFuture = FUTURES.createFuture();
    private volatile boolean closed;

    public static ClientInstance create() {
        return new ClientInstance(new ClientOptions());
    }

    public static ClientInstance create(ClientOptions options) {
        Objects.requireNonNull(options, "Client options must be non-null");
        return new ClientInstance(new ClientOptions(options));
    }

    ClientInstance(ClientOptions options) {
        this.options = options;
    }

    @Override
    public synchronized Connection connect(String host, int port) throws ClientException {
        this.checkClosed();
        return this.addConnection(new ClientConnection(this, host, port, this.defaultConnectionOptions).connect());
    }

    @Override
    public synchronized Connection connect(String host, int port, ConnectionOptions options) throws ClientException {
        this.checkClosed();
        return this.addConnection(new ClientConnection(this, host, port, new ConnectionOptions(options)).connect());
    }

    @Override
    public synchronized Connection connect(String host) throws ClientException {
        this.checkClosed();
        return this.addConnection(new ClientConnection(this, host, -1, this.defaultConnectionOptions).connect());
    }

    @Override
    public synchronized Connection connect(String host, ConnectionOptions options) throws ClientException {
        this.checkClosed();
        return this.addConnection(new ClientConnection(this, host, -1, new ConnectionOptions(options)).connect());
    }

    @Override
    public String containerId() {
        return this.options.id();
    }

    String getClientUniqueId() {
        return this.clientUniqueId;
    }

    ClientOptions options() {
        return this.options;
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public synchronized Future<Client> closeAsync() {
        if (!this.closed) {
            this.closed = true;
            if (this.connections.isEmpty()) {
                this.closedFuture.complete(this);
            } else {
                ArrayList<ClientConnection> connectionsView = new ArrayList<ClientConnection>(this.connections.values());
                connectionsView.forEach(connection -> connection.close());
                for (Connection connection2 : connectionsView) {
                    try {
                        connection2.close();
                    }
                    catch (Throwable ignored) {
                        LOG.trace("Error while closing connection, ignoring", ignored);
                    }
                }
            }
        }
        return this.closedFuture;
    }

    private void checkClosed() throws ClientIllegalStateException {
        if (this.closed) {
            throw new ClientIllegalStateException("Cannot create new connections, the Client has been closed.");
        }
    }

    String nextConnectionId() {
        return this.getClientUniqueId() + ":" + this.CONNECTION_COUNTER.incrementAndGet();
    }

    private ClientConnection addConnection(ClientConnection connection) {
        this.connections.put(connection.getId(), connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterConnection(ClientConnection connection) {
        Map<String, ClientConnection> map = this.connections;
        synchronized (map) {
            this.connections.remove(connection.getId());
            if (this.closed && this.connections.isEmpty()) {
                this.closedFuture.complete(this);
            }
        }
    }
}

