/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.io.InputStream;
import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferInputStream;
import org.apache.qpid.protonj2.client.Delivery;
import org.apache.qpid.protonj2.client.DeliveryState;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.Receiver;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.impl.ClientDeliveryState;
import org.apache.qpid.protonj2.client.impl.ClientMessageSupport;
import org.apache.qpid.protonj2.client.impl.ClientReceiver;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.engine.util.StringUtils;
import org.apache.qpid.protonj2.types.messaging.Accepted;
import org.apache.qpid.protonj2.types.messaging.DeliveryAnnotations;
import org.apache.qpid.protonj2.types.messaging.Modified;
import org.apache.qpid.protonj2.types.messaging.Rejected;
import org.apache.qpid.protonj2.types.messaging.Released;
import org.apache.qpid.protonj2.types.transport.ErrorCondition;

public final class ClientDelivery
implements Delivery {
    private final ClientReceiver receiver;
    private final IncomingDelivery delivery;
    private final ProtonBuffer payload;
    private DeliveryAnnotations deliveryAnnotations;
    private Message<?> cachedMessage;
    private InputStream rawInputStream;

    ClientDelivery(ClientReceiver receiver, IncomingDelivery delivery) {
        this.receiver = receiver;
        this.delivery = delivery;
        this.delivery.setLinkedResource((Object)this);
        this.payload = delivery.readAll();
    }

    @Override
    public <E> Message<E> message() throws ClientException {
        if (this.rawInputStream != null) {
            throw new ClientIllegalStateException("Cannot access Delivery Annotations API after requesting an InputStream");
        }
        Message<?> message = this.cachedMessage;
        if (message == null && this.payload.isReadable()) {
            message = this.cachedMessage = ClientMessageSupport.decodeMessage(this.payload, this::deliveryAnnotations);
        }
        return message;
    }

    @Override
    public InputStream rawInputStream() throws ClientException {
        if (this.cachedMessage != null) {
            throw new ClientIllegalStateException("Cannot access Delivery InputStream API after requesting an Message");
        }
        if (this.rawInputStream == null) {
            this.rawInputStream = new ProtonBufferInputStream(this.payload);
        }
        return this.rawInputStream;
    }

    @Override
    public Map<String, Object> annotations() throws ClientException {
        this.message();
        if (this.deliveryAnnotations != null && this.deliveryAnnotations.getValue() != null) {
            return StringUtils.toStringKeyedMap((Map)this.deliveryAnnotations.getValue());
        }
        return null;
    }

    @Override
    public Delivery accept() throws ClientException {
        this.receiver.disposition(this.delivery, (org.apache.qpid.protonj2.types.transport.DeliveryState)Accepted.getInstance(), true);
        return this;
    }

    @Override
    public Delivery release() throws ClientException {
        this.receiver.disposition(this.delivery, (org.apache.qpid.protonj2.types.transport.DeliveryState)Released.getInstance(), true);
        return this;
    }

    @Override
    public Delivery reject(String condition, String description) throws ClientException {
        this.receiver.disposition(this.delivery, (org.apache.qpid.protonj2.types.transport.DeliveryState)new Rejected().setError(new ErrorCondition(condition, description)), true);
        return this;
    }

    @Override
    public Delivery modified(boolean deliveryFailed, boolean undeliverableHere) throws ClientException {
        this.receiver.disposition(this.delivery, (org.apache.qpid.protonj2.types.transport.DeliveryState)new Modified().setDeliveryFailed(deliveryFailed).setUndeliverableHere(undeliverableHere), true);
        return this;
    }

    @Override
    public Delivery disposition(DeliveryState state, boolean settle) throws ClientException {
        this.receiver.disposition(this.delivery, ClientDeliveryState.asProtonType(state), settle);
        return this;
    }

    @Override
    public Delivery settle() throws ClientException {
        this.receiver.disposition(this.delivery, null, true);
        return this;
    }

    @Override
    public DeliveryState state() {
        return ClientDeliveryState.fromProtonType(this.delivery.getState());
    }

    @Override
    public DeliveryState remoteState() {
        return ClientDeliveryState.fromProtonType(this.delivery.getRemoteState());
    }

    @Override
    public boolean remoteSettled() {
        return this.delivery.isRemotelySettled();
    }

    @Override
    public int messageFormat() {
        return this.delivery.getMessageFormat();
    }

    @Override
    public Receiver receiver() {
        return this.receiver;
    }

    @Override
    public boolean settled() {
        return this.delivery.isSettled();
    }

    IncomingDelivery protonDelivery() {
        return this.delivery;
    }

    void deliveryAnnotations(DeliveryAnnotations deliveryAnnotations) {
        this.deliveryAnnotations = deliveryAnnotations;
    }
}

