/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.client.DeliveryMode;
import org.apache.qpid.protonj2.client.SourceOptions;
import org.apache.qpid.protonj2.client.TargetOptions;

public class SenderOptions {
    private long sendTimeout = -1L;
    private long requestTimeout = -1L;
    private long openTimeout = 15000L;
    private long closeTimeout = 60000L;
    private String linkName;
    private boolean autoSettle = true;
    private DeliveryMode deliveryMode = DeliveryMode.AT_LEAST_ONCE;
    private final SourceOptions source = new SourceOptions();
    private final TargetOptions target = new TargetOptions();
    private String[] offeredCapabilities;
    private String[] desiredCapabilities;
    private Map<String, Object> properties;

    public SenderOptions() {
    }

    public SenderOptions(SenderOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public SenderOptions linkName(String linkName) {
        this.linkName = linkName;
        return this;
    }

    public String linkName() {
        return this.linkName;
    }

    public SenderOptions autoSettle(boolean autoSettle) {
        this.autoSettle = autoSettle;
        return this;
    }

    public boolean autoSettle() {
        return this.autoSettle;
    }

    public SenderOptions deliveryMode(DeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    public DeliveryMode deliveryMode() {
        return this.deliveryMode;
    }

    public long closeTimeout() {
        return this.closeTimeout;
    }

    public SenderOptions closeTimeout(long closeTimeout) {
        return this.closeTimeout(closeTimeout, TimeUnit.MILLISECONDS);
    }

    public SenderOptions closeTimeout(long timeout, TimeUnit units) {
        this.closeTimeout = units.toMillis(timeout);
        return this;
    }

    public long openTimeout() {
        return this.openTimeout;
    }

    public SenderOptions openTimeout(long openTimeout) {
        return this.openTimeout(openTimeout, TimeUnit.MILLISECONDS);
    }

    public SenderOptions openTimeout(long timeout, TimeUnit units) {
        this.openTimeout = units.toMillis(timeout);
        return this;
    }

    public long sendTimeout() {
        return this.sendTimeout;
    }

    public SenderOptions sendTimeout(long sendTimeout) {
        return this.sendTimeout(sendTimeout, TimeUnit.MILLISECONDS);
    }

    public SenderOptions sendTimeout(long timeout, TimeUnit units) {
        this.sendTimeout = units.toMillis(timeout);
        return this;
    }

    public long requestTimeout() {
        return this.requestTimeout;
    }

    public SenderOptions requestTimeout(long requestTimeout) {
        return this.requestTimeout(requestTimeout, TimeUnit.MILLISECONDS);
    }

    public SenderOptions requestTimeout(long timeout, TimeUnit units) {
        this.requestTimeout = units.toMillis(timeout);
        return this;
    }

    public String[] offeredCapabilities() {
        return this.offeredCapabilities;
    }

    public SenderOptions offeredCapabilities(String ... offeredCapabilities) {
        this.offeredCapabilities = offeredCapabilities;
        return this;
    }

    public String[] desiredCapabilities() {
        return this.desiredCapabilities;
    }

    public SenderOptions desiredCapabilities(String ... desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public SenderOptions properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public SourceOptions sourceOptions() {
        return this.source;
    }

    public TargetOptions targetOptions() {
        return this.target;
    }

    public SenderOptions clone() {
        return this.copyInto(new SenderOptions());
    }

    protected SenderOptions copyInto(SenderOptions other) {
        other.autoSettle(this.autoSettle);
        other.linkName(this.linkName);
        other.closeTimeout(this.closeTimeout);
        other.openTimeout(this.openTimeout);
        other.sendTimeout(this.sendTimeout);
        other.requestTimeout(this.requestTimeout);
        if (this.offeredCapabilities != null) {
            other.offeredCapabilities(Arrays.copyOf(this.offeredCapabilities, this.offeredCapabilities.length));
        }
        if (this.desiredCapabilities != null) {
            other.desiredCapabilities(Arrays.copyOf(this.desiredCapabilities, this.desiredCapabilities.length));
        }
        if (this.properties != null) {
            other.properties(new HashMap<String, Object>(this.properties));
        }
        this.source.copyInto(other.sourceOptions());
        this.target.copyInto(other.targetOptions());
        return this;
    }
}

