/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.protonj2.client.DeliveryState;
import org.apache.qpid.protonj2.client.Sender;
import org.apache.qpid.protonj2.client.Tracker;
import org.apache.qpid.protonj2.client.exceptions.ClientDeliveryStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientDeliveryState;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientSender;
import org.apache.qpid.protonj2.engine.OutgoingDelivery;

class ClientTracker
implements Tracker {
    private final ClientSender sender;
    private final OutgoingDelivery delivery;
    private final ClientFuture<Tracker> remoteSettlementFuture;
    private volatile boolean remotelySettled;
    private volatile DeliveryState remoteDeliveryState;

    ClientTracker(ClientSender sender, OutgoingDelivery delivery) {
        this.sender = sender;
        this.delivery = delivery;
        this.delivery.deliveryStateUpdatedHandler(this::processDeliveryUpdated);
        this.remoteSettlementFuture = sender.session().getFutureFactory().createFuture();
    }

    OutgoingDelivery delivery() {
        return this.delivery;
    }

    @Override
    public Sender sender() {
        return this.sender;
    }

    @Override
    public synchronized DeliveryState state() {
        return ClientDeliveryState.fromProtonType(this.delivery.getState());
    }

    @Override
    public DeliveryState remoteState() {
        return this.remoteDeliveryState;
    }

    @Override
    public boolean remoteSettled() {
        return this.remotelySettled;
    }

    @Override
    public Tracker disposition(DeliveryState state, boolean settle) throws ClientException {
        try {
            this.sender.disposition(this.delivery, ClientDeliveryState.asProtonType(state), settle);
        }
        finally {
            if (settle) {
                this.remoteSettlementFuture.complete(this);
            }
        }
        return this;
    }

    @Override
    public Tracker settle() throws ClientException {
        try {
            this.sender.disposition(this.delivery, null, true);
        }
        finally {
            this.remoteSettlementFuture.complete(this);
        }
        return this;
    }

    @Override
    public synchronized boolean settled() {
        return this.delivery.isSettled();
    }

    public ClientFuture<Tracker> settlementFuture() {
        if (this.delivery.isSettled()) {
            this.remoteSettlementFuture.complete(this);
        }
        return this.remoteSettlementFuture;
    }

    @Override
    public Tracker awaitSettlement() throws ClientException {
        try {
            if (this.settled()) {
                return this;
            }
            return (Tracker)((ClientFuture)this.settlementFuture()).get();
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ClientException("Wait for settlement was interrupted", e);
        }
    }

    @Override
    public Tracker awaitSettlement(long timeout, TimeUnit unit) throws ClientException {
        try {
            if (this.settled()) {
                return this;
            }
            return (Tracker)((ClientFuture)this.settlementFuture()).get(timeout, unit);
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ClientException("Wait for settlement was interrupted", ie);
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (TimeoutException te) {
            throw new ClientOperationTimedOutException("Timed out waiting for remote settlement", te);
        }
    }

    @Override
    public Tracker awaitAccepted() throws ClientException {
        try {
            if (this.settled() && !this.remoteSettled()) {
                return this;
            }
            ((ClientFuture)this.settlementFuture()).get();
            if (this.remoteState() != null && this.remoteState().isAccepted()) {
                return this;
            }
            throw new ClientDeliveryStateException("Remote did not accept the sent message", this.remoteState());
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ClientException("Wait for Accepted outcome was interrupted", ie);
        }
    }

    @Override
    public Tracker awaitAccepted(long timeout, TimeUnit unit) throws ClientException {
        try {
            if (this.settled() && !this.remoteSettled()) {
                return this;
            }
            ((ClientFuture)this.settlementFuture()).get(timeout, unit);
            if (this.remoteState() != null && this.remoteState().isAccepted()) {
                return this;
            }
            throw new ClientDeliveryStateException("Remote did not accept the sent message", this.remoteState());
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ClientException("Wait for Accepted outcome was interrupted", ie);
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (TimeoutException te) {
            throw new ClientOperationTimedOutException("Timed out waiting for remote Accepted outcome", te);
        }
    }

    private void processDeliveryUpdated(OutgoingDelivery delivery) {
        this.remotelySettled = delivery.isRemotelySettled();
        this.remoteDeliveryState = ClientDeliveryState.fromProtonType(delivery.getRemoteState());
        if (delivery.isRemotelySettled()) {
            this.remoteSettlementFuture.complete(this);
        }
        if (this.sender.options().autoSettle() && delivery.isRemotelySettled()) {
            delivery.settle();
        }
    }
}

