/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.StreamReceiverMessage;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientMessageFormatViolationException;
import org.apache.qpid.protonj2.client.exceptions.ClientUnsupportedOperationException;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientStreamDelivery;
import org.apache.qpid.protonj2.client.impl.ClientStreamReceiver;
import org.apache.qpid.protonj2.codec.DecodeEOFException;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamDecoderFactory;
import org.apache.qpid.protonj2.codec.decoders.primitives.BinaryTypeDecoder;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.messaging.AmqpSequence;
import org.apache.qpid.protonj2.types.messaging.AmqpValue;
import org.apache.qpid.protonj2.types.messaging.ApplicationProperties;
import org.apache.qpid.protonj2.types.messaging.Data;
import org.apache.qpid.protonj2.types.messaging.DeliveryAnnotations;
import org.apache.qpid.protonj2.types.messaging.Footer;
import org.apache.qpid.protonj2.types.messaging.Header;
import org.apache.qpid.protonj2.types.messaging.MessageAnnotations;
import org.apache.qpid.protonj2.types.messaging.Properties;
import org.apache.qpid.protonj2.types.messaging.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientStreamReceiverMessage
implements StreamReceiverMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ClientStreamReceiverMessage.class);
    private final ClientStreamReceiver receiver;
    private final ClientStreamDelivery delivery;
    private final InputStream deliveryStream;
    private final IncomingDelivery protonDelivery;
    private final StreamDecoder protonDecoder = ProtonStreamDecoderFactory.create();
    private final StreamDecoderState decoderState = this.protonDecoder.newDecoderState();
    private Header header;
    private DeliveryAnnotations deliveryAnnotations;
    private MessageAnnotations annotations;
    private Properties properties;
    private ApplicationProperties applicationProperties;
    private Footer footer;
    private StreamState currentState = StreamState.IDLE;
    private MessageBodyInputStream bodyStream;

    ClientStreamReceiverMessage(ClientStreamReceiver receiver, ClientStreamDelivery delivery, InputStream deliveryStream) {
        this.receiver = receiver;
        this.delivery = delivery;
        this.deliveryStream = deliveryStream;
        this.protonDelivery = delivery.getProtonDelivery();
    }

    @Override
    public ClientStreamReceiver receiver() {
        return this.receiver;
    }

    @Override
    public ClientStreamDelivery delivery() {
        return this.delivery;
    }

    @Override
    public boolean aborted() {
        if (this.protonDelivery != null) {
            return this.protonDelivery.isAborted();
        }
        return false;
    }

    @Override
    public boolean completed() {
        if (this.protonDelivery != null) {
            return !this.protonDelivery.isPartial() && !this.protonDelivery.isAborted();
        }
        return false;
    }

    @Override
    public int messageFormat() throws ClientException {
        return this.protonDelivery != null ? this.protonDelivery.getMessageFormat() : 0;
    }

    public StreamReceiverMessage messageFormat(int messageFormat) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiverMessage");
    }

    @Override
    public boolean durable() throws ClientException {
        return this.header() != null ? this.header.isDurable() : false;
    }

    public StreamReceiverMessage durable(boolean durable) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public byte priority() throws ClientException {
        return this.header() != null ? this.header.getPriority() : (byte)4;
    }

    public StreamReceiverMessage priority(byte priority) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public long timeToLive() throws ClientException {
        return this.header() != null ? this.header.getTimeToLive() : Header.DEFAULT_TIME_TO_LIVE;
    }

    public StreamReceiverMessage timeToLive(long timeToLive) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public boolean firstAcquirer() throws ClientException {
        return this.header() != null ? this.header.isFirstAcquirer() : false;
    }

    public StreamReceiverMessage firstAcquirer(boolean firstAcquirer) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public long deliveryCount() throws ClientException {
        return this.header() != null ? this.header.getDeliveryCount() : 0L;
    }

    public StreamReceiverMessage deliveryCount(long deliveryCount) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public Header header() throws ClientException {
        this.ensureStreamDecodedTo(StreamState.HEADER_READ);
        return this.header;
    }

    public StreamReceiverMessage header(Header header) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public Object messageId() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getMessageId();
        }
        return null;
    }

    public StreamReceiverMessage messageId(Object messageId) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public byte[] userId() throws ClientException {
        if (this.properties() != null) {
            byte[] copyOfUserId = null;
            if (this.properties != null && this.properties().getUserId() != null) {
                copyOfUserId = this.properties().getUserId().arrayCopy();
            }
            return copyOfUserId;
        }
        return null;
    }

    public StreamReceiverMessage userId(byte[] userId) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public String to() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getTo();
        }
        return null;
    }

    public StreamReceiverMessage to(String to) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public String subject() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getSubject();
        }
        return null;
    }

    public StreamReceiverMessage subject(String subject) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public String replyTo() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getReplyTo();
        }
        return null;
    }

    public StreamReceiverMessage replyTo(String replyTo) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public Object correlationId() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getCorrelationId();
        }
        return null;
    }

    public StreamReceiverMessage correlationId(Object correlationId) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public String contentType() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getContentType();
        }
        return null;
    }

    public StreamReceiverMessage contentType(String contentType) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public String contentEncoding() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getContentEncoding();
        }
        return null;
    }

    @Override
    public Message<?> contentEncoding(String contentEncoding) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public long absoluteExpiryTime() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getAbsoluteExpiryTime();
        }
        return 0L;
    }

    public StreamReceiverMessage absoluteExpiryTime(long expiryTime) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public long creationTime() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getCreationTime();
        }
        return 0L;
    }

    public StreamReceiverMessage creationTime(long createTime) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public String groupId() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getGroupId();
        }
        return null;
    }

    public StreamReceiverMessage groupId(String groupId) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public int groupSequence() throws ClientException {
        if (this.properties() != null) {
            return (int)this.properties().getGroupSequence();
        }
        return 0;
    }

    public StreamReceiverMessage groupSequence(int groupSequence) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public String replyToGroupId() throws ClientException {
        if (this.properties() != null) {
            return this.properties().getReplyToGroupId();
        }
        return null;
    }

    public StreamReceiverMessage replyToGroupId(String replyToGroupId) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public Properties properties() throws ClientException {
        this.ensureStreamDecodedTo(StreamState.PROPERTIES_READ);
        return this.properties;
    }

    public StreamReceiverMessage properties(Properties properties) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    DeliveryAnnotations deliveryAnnotations() throws ClientException {
        this.ensureStreamDecodedTo(StreamState.DELIVERY_ANNOTATIONS_READ);
        return this.deliveryAnnotations;
    }

    @Override
    public Object annotation(String key) throws ClientException {
        if (this.hasAnnotations()) {
            return this.annotations.getValue().get(Symbol.valueOf((String)key));
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(String key) throws ClientException {
        if (this.hasAnnotations()) {
            return this.annotations.getValue().containsKey(Symbol.valueOf((String)key));
        }
        return false;
    }

    @Override
    public boolean hasAnnotations() throws ClientException {
        this.ensureStreamDecodedTo(StreamState.MESSAGE_ANNOTATIONS_READ);
        return this.annotations != null && this.annotations.getValue() != null && this.annotations.getValue().size() > 0;
    }

    @Override
    public Object removeAnnotation(String key) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    public StreamReceiverMessage forEachAnnotation(BiConsumer<String, Object> action) throws ClientException {
        if (this.hasAnnotations()) {
            this.annotations.getValue().forEach((key, value) -> action.accept(key.toString(), value));
        }
        return this;
    }

    public StreamReceiverMessage annotation(String key, Object value) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public MessageAnnotations annotations() throws ClientException {
        if (this.hasAnnotations()) {
            return this.annotations;
        }
        return null;
    }

    public StreamReceiverMessage annotations(MessageAnnotations messageAnnotations) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public Object property(String key) throws ClientException {
        if (this.hasProperties()) {
            return this.applicationProperties.getValue().get(key);
        }
        return null;
    }

    @Override
    public boolean hasProperty(String key) throws ClientException {
        if (this.hasProperties()) {
            return this.applicationProperties.getValue().containsKey(key);
        }
        return false;
    }

    @Override
    public boolean hasProperties() throws ClientException {
        this.ensureStreamDecodedTo(StreamState.APPLICATION_PROPERTIES_READ);
        return this.applicationProperties != null && this.applicationProperties.getValue() != null && this.applicationProperties.getValue().size() > 0;
    }

    @Override
    public Object removeProperty(String key) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    public StreamReceiverMessage forEachProperty(BiConsumer<String, Object> action) throws ClientException {
        if (this.hasProperties()) {
            this.applicationProperties.getValue().forEach(action);
        }
        return this;
    }

    public StreamReceiverMessage property(String key, Object value) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public ApplicationProperties applicationProperties() throws ClientException {
        if (this.hasProperties()) {
            return this.applicationProperties;
        }
        return null;
    }

    public StreamReceiverMessage applicationProperties(ApplicationProperties applicationProperties) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public Object footer(String key) throws ClientException {
        if (this.hasFooters()) {
            return this.footer.getValue().get(Symbol.valueOf((String)key));
        }
        return null;
    }

    @Override
    public boolean hasFooter(String key) throws ClientException {
        if (this.hasFooters()) {
            return this.footer.getValue().containsKey(Symbol.valueOf((String)key));
        }
        return false;
    }

    @Override
    public boolean hasFooters() throws ClientException {
        this.ensureStreamDecodedTo(StreamState.BODY_READABLE);
        if (this.currentState != StreamState.FOOTER_READ) {
            if (this.currentState == StreamState.DECODE_ERROR) {
                throw new ClientException("Cannot read Footer due to decoding error in message payload");
            }
            throw new ClientIllegalStateException("Cannot read message Footer until message body fully read");
        }
        return this.footer != null && this.footer.getValue() != null && this.footer.getValue().size() > 0;
    }

    @Override
    public Object removeFooter(String key) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    public StreamReceiverMessage forEachFooter(BiConsumer<String, Object> action) throws ClientException {
        if (this.hasFooters()) {
            this.footer.getValue().forEach((key, value) -> action.accept(key.toString(), value));
        }
        return this;
    }

    public StreamReceiverMessage footer(String key, Object value) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    @Override
    public Footer footer() throws ClientException {
        if (this.hasFooters()) {
            return this.footer;
        }
        return null;
    }

    public StreamReceiverMessage footer(Footer footer) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot write to a StreamReceiveMessage");
    }

    public StreamReceiverMessage addBodySection(Section<?> bodySection) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot encode from an StreamReceiverMessage instance.");
    }

    public StreamReceiverMessage bodySections(Collection<Section<?>> sections) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot encode from an StreamReceiverMessage instance.");
    }

    @Override
    public Collection<Section<?>> bodySections() throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot decode all body sections from a StreamReceiverMessage instance.");
    }

    public StreamReceiverMessage forEachBodySection(Consumer<Section<?>> consumer) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot decode all body sections from a StreamReceiverMessage instance.");
    }

    public StreamReceiverMessage clearBodySections() throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot encode from an StreamReceiverMessage instance.");
    }

    @Override
    public InputStream body() throws ClientException {
        if (this.currentState.ordinal() > StreamState.BODY_READABLE.ordinal()) {
            if (this.currentState == StreamState.DECODE_ERROR) {
                throw new ClientException("Cannot read body due to decoding error in message payload");
            }
            if (this.bodyStream != null) {
                throw new ClientIllegalStateException("Cannot read body from message whose body has already been read.");
            }
        }
        this.ensureStreamDecodedTo(StreamState.BODY_READABLE);
        return this.bodyStream;
    }

    public StreamReceiverMessage body(InputStream value) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot encode from an StreamReceiverMessage instance.");
    }

    @Override
    public ProtonBuffer encode(Map<String, Object> deliveryAnnotations) throws ClientUnsupportedOperationException {
        throw new ClientUnsupportedOperationException("Cannot encode from an StreamReceiverMessage instance.");
    }

    private void checkClosedOrAborted() throws ClientIllegalStateException {
        if (this.receiver.isClosed()) {
            throw new ClientIllegalStateException("The parent Receiver instance has already been closed.");
        }
        if (this.aborted()) {
            throw new ClientIllegalStateException("The incoming delivery was aborted.");
        }
    }

    private void ensureStreamDecodedTo(StreamState desiredState) throws ClientException {
        this.checkClosedOrAborted();
        while (this.currentState.ordinal() < desiredState.ordinal()) {
            try {
                StreamTypeDecoder decoder;
                try {
                    decoder = this.protonDecoder.readNextTypeDecoder(this.deliveryStream, this.decoderState);
                }
                catch (DecodeEOFException eof) {
                    this.currentState = StreamState.FOOTER_READ;
                    break;
                }
                Class typeClass = decoder.getTypeClass();
                if (typeClass == Header.class) {
                    this.header = (Header)decoder.readValue(this.deliveryStream, this.decoderState);
                    this.currentState = StreamState.HEADER_READ;
                    continue;
                }
                if (typeClass == DeliveryAnnotations.class) {
                    this.deliveryAnnotations = (DeliveryAnnotations)decoder.readValue(this.deliveryStream, this.decoderState);
                    this.currentState = StreamState.DELIVERY_ANNOTATIONS_READ;
                    continue;
                }
                if (typeClass == MessageAnnotations.class) {
                    this.annotations = (MessageAnnotations)decoder.readValue(this.deliveryStream, this.decoderState);
                    this.currentState = StreamState.MESSAGE_ANNOTATIONS_READ;
                    continue;
                }
                if (typeClass == Properties.class) {
                    this.properties = (Properties)decoder.readValue(this.deliveryStream, this.decoderState);
                    this.currentState = StreamState.PROPERTIES_READ;
                    continue;
                }
                if (typeClass == ApplicationProperties.class) {
                    this.applicationProperties = (ApplicationProperties)decoder.readValue(this.deliveryStream, this.decoderState);
                    this.currentState = StreamState.APPLICATION_PROPERTIES_READ;
                    continue;
                }
                if (typeClass == AmqpSequence.class) {
                    this.currentState = StreamState.BODY_READABLE;
                    if (this.bodyStream != null) continue;
                    this.bodyStream = new AmqpSequenceInputStream(this.deliveryStream);
                    continue;
                }
                if (typeClass == AmqpValue.class) {
                    this.currentState = StreamState.BODY_READABLE;
                    if (this.bodyStream != null) continue;
                    this.bodyStream = new AmqpValueInputStream(this.deliveryStream);
                    continue;
                }
                if (typeClass == Data.class) {
                    this.currentState = StreamState.BODY_READABLE;
                    if (this.bodyStream != null) continue;
                    this.bodyStream = new DataSectionInputStream(this.deliveryStream);
                    continue;
                }
                if (typeClass == Footer.class) {
                    this.footer = (Footer)decoder.readValue(this.deliveryStream, this.decoderState);
                    this.currentState = StreamState.FOOTER_READ;
                    continue;
                }
                throw new ClientMessageFormatViolationException("Incoming message carries unknown Section");
            }
            catch (ClientMessageFormatViolationException | DecodeException ex) {
                this.currentState = StreamState.DECODE_ERROR;
                if (this.deliveryStream != null) {
                    try {
                        this.deliveryStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw ClientExceptionSupport.createNonFatalOrPassthrough(ex);
            }
        }
    }

    private class AmqpValueInputStream
    extends MessageBodyInputStream {
        private Class<?> bodyTypeClass;

        public AmqpValueInputStream(InputStream deliveryStream) throws ClientException {
            super(deliveryStream);
            this.bodyTypeClass = Void.class;
        }

        @Override
        public Class<?> getBodyTypeClass() {
            return this.bodyTypeClass;
        }

        @Override
        protected void validateAndScanNextSection() throws ClientException {
            throw new DecodeException("Cannot read the payload of an AMQP Sequence payload.");
        }
    }

    private class AmqpSequenceInputStream
    extends MessageBodyInputStream {
        public AmqpSequenceInputStream(InputStream deliveryStream) throws ClientException {
            super(deliveryStream);
        }

        @Override
        public Class<?> getBodyTypeClass() {
            return List.class;
        }

        @Override
        protected void validateAndScanNextSection() throws ClientException {
            throw new DecodeException("Cannot read the payload of an AMQP Sequence payload.");
        }
    }

    private class DataSectionInputStream
    extends MessageBodyInputStream {
        public DataSectionInputStream(InputStream deliveryStream) throws ClientException {
            super(deliveryStream);
        }

        @Override
        public Class<?> getBodyTypeClass() {
            return byte[].class;
        }

        @Override
        protected void validateAndScanNextSection() throws ClientException {
            StreamTypeDecoder typeDecoder = ClientStreamReceiverMessage.this.protonDecoder.readNextTypeDecoder(ClientStreamReceiverMessage.this.deliveryStream, ClientStreamReceiverMessage.this.decoderState);
            if (typeDecoder.getTypeClass() == Binary.class) {
                LOG.trace("Data Section of size {} ready for read.", (Object)this.remainingSectionBytes);
                BinaryTypeDecoder binaryDecoder = (BinaryTypeDecoder)typeDecoder;
                this.remainingSectionBytes = binaryDecoder.readSize(ClientStreamReceiverMessage.this.deliveryStream);
            } else if (typeDecoder.getTypeClass() == Void.class) {
                LOG.trace("Data Section with no Binary payload read and skipped.");
                this.remainingSectionBytes = 0L;
            } else {
                throw new DecodeException("Unknown payload in body of Data Section encoding.");
            }
        }
    }

    private abstract class MessageBodyInputStream
    extends FilterInputStream {
        protected boolean closed;
        protected long remainingSectionBytes;

        protected MessageBodyInputStream(InputStream deliveryStream) throws ClientException {
            super(deliveryStream);
            this.remainingSectionBytes = 0L;
            this.validateAndScanNextSection();
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.remainingSectionBytes == 0L) {
                    ClientStreamReceiverMessage.this.ensureStreamDecodedTo(StreamState.FOOTER_READ);
                }
            }
            catch (ClientException e) {
                throw new IOException("Caught error while attempting to advance past remaining message body");
            }
            finally {
                this.closed = true;
                super.close();
            }
        }

        @Override
        public int read() throws IOException {
            this.checkClosed();
            if (this.remainingSectionBytes == 0L && !this.tryMoveToNextBodySection()) {
                return -1;
            }
            --this.remainingSectionBytes;
            return super.read();
        }

        @Override
        public int read(byte[] target, int offset, int length) throws IOException {
            this.checkClosed();
            int bytesRead = 0;
            while (bytesRead != length) {
                if (this.remainingSectionBytes == 0L && !this.tryMoveToNextBodySection()) {
                    bytesRead = bytesRead > 0 ? bytesRead : -1;
                    break;
                }
                int readChunk = (int)Math.min(this.remainingSectionBytes, (long)(length - bytesRead));
                int actualRead = super.read(target, offset + bytesRead, readChunk);
                if (actualRead <= 0) continue;
                bytesRead += actualRead;
                this.remainingSectionBytes -= (long)actualRead;
            }
            return bytesRead;
        }

        @Override
        public long skip(long skipSize) throws IOException {
            this.checkClosed();
            int bytesSkipped = 0;
            while ((long)bytesSkipped != skipSize) {
                if (this.remainingSectionBytes == 0L && !this.tryMoveToNextBodySection()) {
                    bytesSkipped = bytesSkipped > 0 ? bytesSkipped : -1;
                    break;
                }
                long skipChunk = (int)Math.min(this.remainingSectionBytes, skipSize - (long)bytesSkipped);
                long actualSkip = super.skip(skipChunk);
                if (actualSkip <= 0L) continue;
                bytesSkipped = (int)((long)bytesSkipped + actualSkip);
                this.remainingSectionBytes -= actualSkip;
            }
            return bytesSkipped;
        }

        public abstract Class<?> getBodyTypeClass();

        protected abstract void validateAndScanNextSection() throws ClientException;

        protected boolean tryMoveToNextBodySection() throws IOException {
            try {
                if (ClientStreamReceiverMessage.this.currentState != StreamState.FOOTER_READ) {
                    ClientStreamReceiverMessage.this.currentState = StreamState.BODY_PENDING;
                    ClientStreamReceiverMessage.this.ensureStreamDecodedTo(StreamState.BODY_READABLE);
                    if (ClientStreamReceiverMessage.this.currentState == StreamState.BODY_READABLE) {
                        this.validateAndScanNextSection();
                        return true;
                    }
                }
                return false;
            }
            catch (ClientException e) {
                throw new IOException(e);
            }
        }

        protected void checkClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Stream was closed previously");
            }
        }
    }

    private static enum StreamState {
        IDLE,
        HEADER_READ,
        DELIVERY_ANNOTATIONS_READ,
        MESSAGE_ANNOTATIONS_READ,
        PROPERTIES_READ,
        APPLICATION_PROPERTIES_READ,
        BODY_PENDING,
        BODY_READABLE,
        FOOTER_READ,
        DECODE_ERROR;

    }
}

