/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;
import org.apache.qpid.protonj2.types.UnsignedInteger;

public final class UnsignedIntegerTypeEncoder
extends AbstractPrimitiveTypeEncoder<UnsignedInteger> {
    @Override
    public Class<UnsignedInteger> getTypeClass() {
        return UnsignedInteger.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, UnsignedInteger value) {
        int intValue = value.intValue();
        if (intValue == 0) {
            buffer.writeByte(67);
        } else if (intValue > 0 && intValue <= 255) {
            buffer.writeByte(82);
            buffer.writeByte(intValue);
        } else {
            buffer.writeByte(112);
            buffer.writeInt(intValue);
        }
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, byte value) {
        if (value == 0) {
            buffer.writeByte(67);
        } else {
            buffer.writeByte(82);
            buffer.writeByte(value);
        }
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, int value) {
        if (value == 0) {
            buffer.writeByte(67);
        } else if (value > 0 && value <= 255) {
            buffer.writeByte(82);
            buffer.writeByte(value);
        } else {
            buffer.writeByte(112);
            buffer.writeInt(value);
        }
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, long value) {
        if (value < 0L || value >= 0x100000000L) {
            throw new IllegalArgumentException("Value \"" + value + "\" lies outside the range [0-4294967296).");
        }
        int intValue = (int)value;
        if (intValue == 0) {
            buffer.writeByte(67);
        } else if (intValue > 0 && intValue <= 255) {
            buffer.writeByte(82);
            buffer.writeByte(intValue);
        } else {
            buffer.writeByte(112);
            buffer.writeInt(intValue);
        }
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(112);
        for (Object value : values) {
            buffer.writeInt(((UnsignedInteger)value).intValue());
        }
    }
}

