/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.transactions;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transactions.Discharge;

public final class DischargeTypeDecoder
extends AbstractDescribedTypeDecoder<Discharge> {
    private static final int MIN_DISCHARGE_LIST_ENTRIES = 1;
    private static final int MAX_DISCHARGE_LIST_ENTRIES = 2;

    @Override
    public Class<Discharge> getTypeClass() {
        return Discharge.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Discharge.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Discharge.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Discharge readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readDischarge(buffer, state, (ListTypeDecoder)DischargeTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Discharge[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Discharge[] result = new Discharge[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDischarge(buffer, state, (ListTypeDecoder)DischargeTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        DischargeTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private Discharge readDischarge(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Discharge discharge = new Discharge();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 1) {
            throw new DecodeException("Not enough entries in Discharge list encoding: " + count);
        }
        if (count > 2) {
            throw new DecodeException("To many entries in Discharge list encoding: " + count);
        }
        block4: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    discharge.setTxnId(state.getDecoder().readBinary(buffer, state));
                    continue block4;
                }
                case 1: {
                    discharge.setFail(state.getDecoder().readBoolean(buffer, state, false));
                }
            }
        }
        return discharge;
    }

    @Override
    public Discharge readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readDischarge(stream, state, (ListTypeDecoder)DischargeTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Discharge[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Discharge[] result = new Discharge[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDischarge(stream, state, (ListTypeDecoder)DischargeTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        DischargeTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private Discharge readDischarge(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Discharge discharge = new Discharge();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 1) {
            throw new DecodeException("Not enough entries in Discharge list encoding: " + count);
        }
        if (count > 2) {
            throw new DecodeException("To many entries in Discharge list encoding: " + count);
        }
        block4: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    discharge.setTxnId(state.getDecoder().readBinary(stream, state));
                    continue block4;
                }
                case 1: {
                    discharge.setFail(state.getDecoder().readBoolean(stream, state, false));
                }
            }
        }
        return discharge;
    }
}

