/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.security;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.security.SaslInit;

public final class SaslInitTypeDecoder
extends AbstractDescribedTypeDecoder<SaslInit> {
    private static final int MIN_SASL_INIT_LIST_ENTRIES = 0;
    private static final int MAX_SASL_INIT_LIST_ENTRIES = 3;

    @Override
    public UnsignedLong getDescriptorCode() {
        return SaslInit.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return SaslInit.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<SaslInit> getTypeClass() {
        return SaslInit.class;
    }

    @Override
    public SaslInit readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readProperties(buffer, state, (ListTypeDecoder)SaslInitTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public SaslInit[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        SaslInit[] result = new SaslInit[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readProperties(buffer, state, (ListTypeDecoder)SaslInitTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        SaslInitTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private SaslInit readProperties(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        SaslInit init = new SaslInit();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 0) {
            throw new DecodeException("Not enough entries in SaslInit list encoding: " + count);
        }
        if (count > 3) {
            throw new DecodeException("To many entries in SaslInit list encoding: " + count);
        }
        block5: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    init.setMechanism(state.getDecoder().readSymbol(buffer, state));
                    continue block5;
                }
                case 1: {
                    init.setInitialResponse(state.getDecoder().readBinaryAsBuffer(buffer, state));
                    continue block5;
                }
                case 2: {
                    init.setHostname(state.getDecoder().readString(buffer, state));
                }
            }
        }
        return init;
    }

    @Override
    public SaslInit readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readProperties(stream, state, (ListTypeDecoder)SaslInitTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public SaslInit[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        SaslInit[] result = new SaslInit[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readProperties(stream, state, (ListTypeDecoder)SaslInitTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        SaslInitTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private SaslInit readProperties(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        SaslInit init = new SaslInit();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 0) {
            throw new DecodeException("Not enough entries in SaslInit list encoding: " + count);
        }
        if (count > 3) {
            throw new DecodeException("To many entries in SaslInit list encoding: " + count);
        }
        block5: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    init.setMechanism(state.getDecoder().readSymbol(stream, state));
                    continue block5;
                }
                case 1: {
                    init.setInitialResponse(state.getDecoder().readBinaryAsBuffer(stream, state));
                    continue block5;
                }
                case 2: {
                    init.setHostname(state.getDecoder().readString(stream, state));
                }
            }
        }
        return init;
    }
}

