/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.primitives.BinaryTypeDecoder;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Data;

public final class DataTypeDecoder
extends AbstractDescribedTypeDecoder<Data> {
    private static final Data EMPTY_DATA = new Data((Binary)null);

    @Override
    public Class<Data> getTypeClass() {
        return Data.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Data.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Data.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Data readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int size;
        byte encodingCode = buffer.readByte();
        switch (encodingCode) {
            case -96: {
                size = buffer.readByte() & 0xFF;
                break;
            }
            case -80: {
                size = buffer.readInt();
                break;
            }
            case 64: {
                return EMPTY_DATA;
            }
            default: {
                throw new DecodeException("Expected Binary type but found encoding: " + encodingCode);
            }
        }
        if (size > buffer.getReadableBytes()) {
            throw new DecodeException("Binary data size " + size + " is specified to be greater than the amount of data available (" + buffer.getReadableBytes() + ")");
        }
        int position = buffer.getReadIndex();
        ProtonByteBuffer data = ProtonByteBufferAllocator.DEFAULT.allocate(size, size);
        buffer.getBytes(position, data.getArray(), data.getArrayOffset(), size);
        data.setWriteIndex(size);
        buffer.setReadIndex(position + size);
        return new Data(new Binary(data));
    }

    public Data[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        BinaryTypeDecoder valueDecoder = (BinaryTypeDecoder)DataTypeDecoder.checkIsExpectedTypeAndCast(BinaryTypeDecoder.class, decoder);
        Binary[] binaryArray = (Binary[])valueDecoder.readArrayElements(buffer, state, count);
        Data[] dataArray = new Data[count];
        for (int i = 0; i < count; ++i) {
            dataArray[i] = new Data(binaryArray[i]);
        }
        return dataArray;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        DataTypeDecoder.checkIsExpectedType(BinaryTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    @Override
    public Data readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        int size;
        byte encodingCode = ProtonStreamUtils.readByte(stream);
        switch (encodingCode) {
            case -96: {
                size = ProtonStreamUtils.readByte(stream) & 0xFF;
                break;
            }
            case -80: {
                size = ProtonStreamUtils.readInt(stream);
                break;
            }
            case 64: {
                return EMPTY_DATA;
            }
            default: {
                throw new DecodeException("Expected Binary type but found encoding: " + encodingCode);
            }
        }
        return new Data(new Binary(ProtonStreamUtils.readBytes(stream, size)));
    }

    public Data[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        BinaryTypeDecoder valueDecoder = (BinaryTypeDecoder)DataTypeDecoder.checkIsExpectedTypeAndCast(BinaryTypeDecoder.class, decoder);
        Binary[] binaryArray = (Binary[])valueDecoder.readArrayElements(stream, state, count);
        Data[] dataArray = new Data[count];
        for (int i = 0; i < count; ++i) {
            dataArray[i] = new Data(binaryArray[i]);
        }
        return dataArray;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        DataTypeDecoder.checkIsExpectedType(BinaryTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }
}

